/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.documentvectorizer;

import com.ibm.es.nuvo.search.summarizer.documentvectorizer.DocumentVector;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.DocumentVectorizer;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.Occurrence;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.OccurrenceArrayFactory;

public class PrefetchingDocumentVector
extends DocumentVector {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private DocumentVectorizer documentVectorizer;
    private boolean allOccurrencesFound = false;
    private int numberOfOccurrencesToPrefetch;

    public PrefetchingDocumentVector(DocumentVectorizer documentVectorizer, OccurrenceArrayFactory occurrenceArrayFactory, int numberOfOccurrencesToPrefetch) {
        super(occurrenceArrayFactory);
        this.documentVectorizer = documentVectorizer;
        this.numberOfOccurrencesToPrefetch = numberOfOccurrencesToPrefetch;
        this.loadMoreOccurrences();
    }

    protected boolean loadMoreOccurrences() {
        if (!this.allOccurrencesFound) {
            for (int i = 0; i < this.numberOfOccurrencesToPrefetch; ++i) {
                if (!this.documentVectorizer.hasNextOccurrence()) {
                    this.allOccurrencesFound = true;
                    break;
                }
                Occurrence o = this.addOccurrence();
                this.documentVectorizer.nextOccurrence(o);
            }
            return true;
        }
        return false;
    }
}

