/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.documentvectorizer;

import com.ibm.es.nuvo.search.summarizer.documentvectorizer.DocumentVectorizer;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.Occurrence;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightQueryTerms;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightTerm;
import com.ibm.es.nuvo.search.summarizer.queryterms.WeightedTerm;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Token;

public class DocumentVectorizerUsingStringComparison
implements DocumentVectorizer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private HighlightQueryTerms queryTerms;
    private Map<String, List<TermIndex>> termStringMap = null;
    private TokenVector curTokenVector = null;
    private PhrasePosition[] phrasePositions;
    private boolean hasNext = false;
    private int nextOccurrencePosition;
    private int nextOccurrenceQueryTermIndex;
    private int curPosition = -1;
    private Iterator<TermIndex> curHitTermIterator = null;

    public DocumentVectorizerUsingStringComparison(HighlightQueryTerms queryTerms) {
        this.queryTerms = queryTerms;
        this.phrasePositions = new PhrasePosition[this.queryTerms.length()];
        this.createTermStringMap();
    }

    public void nextDocument(TokenVector tokenVector) {
        this.curTokenVector = tokenVector;
        this.curTokenVector.setReadMode(1);
        this.curTokenVector.begin();
        this.curPosition = -1;
        for (int i = 0; i < this.phrasePositions.length; ++i) {
            this.phrasePositions[i].clear();
        }
        this.hasNext = this.findNextOccurrence();
    }

    public boolean hasNextOccurrence() {
        return this.hasNext;
    }

    public void nextOccurrence(Occurrence occurrence) {
        if (!this.hasNext) {
            return;
        }
        occurrence.pos = this.nextOccurrencePosition;
        occurrence.queryTermIndex = this.nextOccurrenceQueryTermIndex;
        this.hasNext = this.findNextOccurrence();
    }

    private void addTermToMap(String termText, TermIndex termIndex) {
        List<TermIndex> indexList = this.termStringMap.get(termText);
        if (indexList == null) {
            indexList = new LinkedList<TermIndex>();
            this.termStringMap.put(termText, indexList);
        }
        indexList.add(termIndex);
    }

    private void createTermStringMap() {
        this.termStringMap = new HashMap<String, List<TermIndex>>();
        for (int i = 0; i < this.queryTerms.length(); ++i) {
            WeightedTerm curTerm = this.queryTerms.getWeightedTerm(i);
            this.phrasePositions[i] = new PhrasePosition(curTerm.length());
            if (curTerm.isSpecialTerm()) continue;
            for (int j = curTerm.length() - 1; j >= 0; --j) {
                HighlightTerm curHighlightTerm = curTerm.getTermArray(j);
                TermIndex termIndex = new TermIndex(i, j);
                this.addTermToMap(curHighlightTerm.getTermText(), termIndex);
                if (!curHighlightTerm.hasLemma()) continue;
                for (String lemma : curHighlightTerm.getLemmas()) {
                    this.addTermToMap(lemma, termIndex);
                }
            }
        }
    }

    private boolean findNextOccurrence() {
        Token curToken;
        if (this.curHitTermIterator != null && this.findNextOccurrenceInIterator()) {
            return true;
        }
        while ((curToken = this.curTokenVector.next()) != null) {
            this.shiftAllPhrasePositions(curToken.getPositionIncrement());
            this.curPosition += curToken.getPositionIncrement();
            List<TermIndex> matchedWeightedTerm = this.termStringMap.get(curToken.termText());
            if (matchedWeightedTerm == null) continue;
            this.curHitTermIterator = matchedWeightedTerm.iterator();
            if (!this.findNextOccurrenceInIterator()) continue;
            return true;
        }
        return false;
    }

    private void shiftAllPhrasePositions(int n) {
        for (int i = 0; i < this.phrasePositions.length; ++i) {
            this.phrasePositions[i].shift(n);
        }
    }

    private boolean findNextOccurrenceInIterator() {
        while (this.curHitTermIterator.hasNext()) {
            TermIndex curTermIndex = this.curHitTermIterator.next();
            this.phrasePositions[curTermIndex.weightedTermIndex].addMatch(curTermIndex);
            if (!this.phrasePositions[curTermIndex.weightedTermIndex].matches()) continue;
            int length = this.queryTerms.getWeightedTerm(curTermIndex.weightedTermIndex).length() - 1;
            this.nextOccurrencePosition = this.curPosition - length;
            this.nextOccurrenceQueryTermIndex = curTermIndex.weightedTermIndex;
            return true;
        }
        this.curHitTermIterator = null;
        return false;
    }

    private static class PhrasePosition {
        private List<List<TermIndex>> matchingPositions = new ArrayList<List<TermIndex>>();
        private int size;
        private int offset;

        PhrasePosition(int size) {
            for (int i = 0; i < size; ++i) {
                this.matchingPositions.add(new ArrayList());
            }
            this.size = size;
            this.offset = 0;
        }

        private int index(int i) {
            return (i + this.offset) % this.size;
        }

        void addMatch(TermIndex ti) {
            this.matchingPositions.get(this.index(this.size - 1)).add(ti);
        }

        void clear(int i) {
            this.matchingPositions.get(this.index(i)).clear();
        }

        void clear() {
            for (int i = 0; i < this.size; ++i) {
                this.clear(i);
            }
        }

        void shift(int n) {
            this.offset = (this.offset + n) % this.size;
            if (n > 0) {
                this.clear(this.size - 1);
            }
        }

        boolean matches() {
            for (int i = 0; i < this.size; ++i) {
                List<TermIndex> curMatchList = this.matchingPositions.get(i);
                boolean match = false;
                for (int j = 0; j < curMatchList.size(); ++j) {
                    if (i != this.index(curMatchList.get((int)j).indexInTermArray)) continue;
                    match = true;
                }
                if (match) continue;
                return false;
            }
            return true;
        }
    }

    private static class TermIndex {
        int weightedTermIndex;
        int indexInTermArray;

        TermIndex(int weightedTermIndex, int indexInTermArray) {
            this.weightedTermIndex = weightedTermIndex;
            this.indexInTermArray = indexInTermArray;
        }
    }
}

