/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.documentvectorizer;

import com.ibm.es.nuvo.search.summarizer.documentvectorizer.DocumentVectorizer;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.Occurrence;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightQueryTerms;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightTerm;
import com.ibm.es.nuvo.search.summarizer.queryterms.WeightedTerm;
import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultipleTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;

public class DocumentVectorizerUsingIndex
implements DocumentVectorizer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private HighlightQueryTerms queryTerms;
    private IndexReader indexReader;
    private String field;
    private PriorityQueue<MultiTermPositions> queue;
    private MultiTermPositions[] multiTermPositions = null;
    private int curDocId;
    private boolean hasNext = false;
    private int nextOccurrencePosition;
    private int nextOccurrenceQueryTermIndex;
    private IOException exception = null;

    public DocumentVectorizerUsingIndex(HighlightQueryTerms queryTerms, IndexReader indexReader, String field) {
        this.queryTerms = queryTerms;
        this.indexReader = indexReader;
        this.field = field;
        this.queue = new PriorityQueue();
    }

    public void nextDocument(int docId) {
        this.curDocId = docId;
        this.queue.clear();
        try {
            if (this.multiTermPositions == null) {
                this.createMultiTermPositions();
            }
            for (int i = 0; i < this.multiTermPositions.length; ++i) {
                if (!this.multiTermPositions[i].nextDoc(this.curDocId) || !this.multiTermPositions[i].nextPosition()) continue;
                this.queue.offer(this.multiTermPositions[i]);
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
        this.hasNext = this.findNextOccurrence();
    }

    public boolean hasNextOccurrence() {
        return this.hasNext;
    }

    public void nextOccurrence(Occurrence occurrence) {
        if (!this.hasNext) {
            return;
        }
        occurrence.pos = this.nextOccurrencePosition;
        occurrence.queryTermIndex = this.nextOccurrenceQueryTermIndex;
        this.hasNext = this.findNextOccurrence();
    }

    public IOException getException() {
        return this.exception;
    }

    private boolean findNextOccurrence() {
        try {
            if (!this.queue.isEmpty()) {
                MultiTermPositions positions = this.queue.poll();
                this.nextOccurrencePosition = positions.getCurPosition();
                this.nextOccurrenceQueryTermIndex = positions.queryTermIndex;
                if (positions.nextPosition()) {
                    this.queue.offer(positions);
                }
                return true;
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
        return false;
    }

    public void close() throws IOException {
        for (int i = 0; i < this.multiTermPositions.length; ++i) {
            this.multiTermPositions[i].close();
        }
    }

    private void createMultiTermPositions() throws IOException {
        this.multiTermPositions = new MultiTermPositions[this.queryTerms.getNumberOfNormalTerms()];
        int curMultiTermPositionIndex = 0;
        for (int i = 0; i < this.queryTerms.length(); ++i) {
            WeightedTerm curTerm = this.queryTerms.getWeightedTerm(i);
            if (curTerm.isSpecialTerm()) continue;
            TermPositions[] termPositions = new TermPositions[curTerm.length()];
            for (int j = 0; j < termPositions.length; ++j) {
                HighlightTerm curHighlightTerm = curTerm.getTermArray(j);
                if (curHighlightTerm.hasLemma()) {
                    String[] lemmas = curHighlightTerm.getLemmas();
                    Term[] t = new Term[1 + lemmas.length];
                    t[0] = new Term(this.field, curHighlightTerm.getTermText());
                    for (int k = 0; k < lemmas.length; ++k) {
                        t[k + 1] = new Term(this.field, lemmas[k]);
                    }
                    termPositions[j] = new MultipleTermPositions(this.indexReader, t);
                    continue;
                }
                termPositions[j] = this.indexReader.termPositions(new Term(this.field, curHighlightTerm.getTermText()));
            }
            this.multiTermPositions[curMultiTermPositionIndex] = new MultiTermPositions(termPositions, i);
            ++curMultiTermPositionIndex;
        }
    }

    private static final class MultiTermPositions
    implements Comparable {
        private int queryTermIndex;
        private TermPositions[] termPositions;
        private int[] curPosition;
        private int[] positionIndex;
        private int numTerms;

        private int getCurPosition() {
            return this.curPosition[0];
        }

        private MultiTermPositions(TermPositions[] termPositions, int queryTermIndex) throws IOException {
            this.termPositions = termPositions;
            this.numTerms = termPositions.length;
            this.queryTermIndex = queryTermIndex;
            this.curPosition = new int[this.numTerms];
            this.positionIndex = new int[this.numTerms];
            for (int i = 0; i < this.numTerms; ++i) {
                this.termPositions[i].next();
                this.positionIndex[i] = 0;
            }
        }

        private boolean nextDoc(int docId) throws IOException {
            for (int i = 0; i < this.numTerms; ++i) {
                if (this.termPositions[i].doc() < docId) {
                    this.termPositions[i].skipTo(docId);
                }
                if (this.termPositions[i].doc() != docId) {
                    return false;
                }
                this.positionIndex[i] = 0;
                this.curPosition[i] = 0;
            }
            return true;
        }

        private boolean nextPosition() throws IOException {
            if (this.positionIndex[0] == this.termPositions[0].freq()) {
                return false;
            }
            this.curPosition[0] = this.termPositions[0].nextPosition();
            this.positionIndex[0] = this.positionIndex[0] + 1;
            for (int i = 1; i < this.numTerms; ++i) {
                while (this.curPosition[i] <= this.curPosition[i - 1]) {
                    if (this.positionIndex[i] == this.termPositions[i].freq()) {
                        return false;
                    }
                    this.curPosition[i] = this.termPositions[i].nextPosition();
                    int n = i;
                    this.positionIndex[n] = this.positionIndex[n] + 1;
                }
                if (this.curPosition[i] == this.curPosition[i - 1] + 1) continue;
                return this.nextPosition();
            }
            return true;
        }

        private void close() throws IOException {
            for (int i = 0; i < this.numTerms; ++i) {
                this.termPositions[i].close();
            }
        }

        public int compareTo(Object o) {
            MultiTermPositions otherPositions = (MultiTermPositions)o;
            return this.curPosition[0] - otherPositions.curPosition[0];
        }
    }
}

