/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.documentvectorizer;

import com.ibm.es.nuvo.search.summarizer.documentvectorizer.DocumentVectorizer;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.Occurrence;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightQueryTerms;
import com.ibm.es.nuvo.search.summarizer.util.TokenUtils;
import com.ibm.es.nuvo.search.summarizer.util.TokenVectorIterator;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import java.util.BitSet;
import org.apache.lucene.analysis.Token;

public class DocumentVectorizerForSpecialQueries
implements DocumentVectorizer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private HighlightQueryTerms queryTerms;
    private int maxCharacters = Integer.MAX_VALUE;
    private TokenVectorIterator tokenIterator;
    private int numCharacters;
    private int curPosition;
    private int nextOccurrencePosition;
    private int nextOccurrenceQueryTermIndex;
    private boolean hasNext;
    private BitSet hitIndexSorter;

    public DocumentVectorizerForSpecialQueries(HighlightQueryTerms queryTerms) {
        this.queryTerms = queryTerms;
        this.hitIndexSorter = new BitSet(queryTerms.length());
        this.tokenIterator = this.queryTerms.getTokenVectorIterator();
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public void nextDocument(TokenVector tokenVector) {
        tokenVector.setReadMode(1);
        tokenVector.begin();
        this.tokenIterator.setTokenVector(tokenVector, false);
        this.curPosition = -1;
        this.numCharacters = 0;
        this.hitIndexSorter.clear();
        this.hasNext = this.findNextOccurrence();
    }

    public boolean hasNextOccurrence() {
        return this.hasNext;
    }

    public void nextOccurrence(Occurrence occurrence) {
        if (!this.hasNext) {
            return;
        }
        occurrence.pos = this.nextOccurrencePosition;
        occurrence.queryTermIndex = this.nextOccurrenceQueryTermIndex;
        this.hasNext = this.findNextOccurrence();
    }

    private boolean findNextOccurrence() {
        Token curToken;
        if (this.hitIndexSorter.cardinality() > 0) {
            this.nextOccurrencePosition = this.curPosition;
            int nextSetBit = this.hitIndexSorter.nextSetBit(0);
            this.hitIndexSorter.clear(nextSetBit);
            this.nextOccurrenceQueryTermIndex = nextSetBit;
            return true;
        }
        while ((curToken = this.tokenIterator.next()) != null) {
            this.curPosition += curToken.getPositionIncrement();
            if (TokenUtils.isTextToken(curToken)) {
                this.numCharacters += TokenUtils.tokenLength(curToken);
            }
            if (this.numCharacters > this.maxCharacters) {
                return false;
            }
            this.queryTerms.specialTermMatches(this.hitIndexSorter);
            if (this.hitIndexSorter.cardinality() <= 0) continue;
            return this.findNextOccurrence();
        }
        return false;
    }
}

