/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer.documentvectorizer;

import com.ibm.es.nuvo.search.summarizer.documentvectorizer.Occurrence;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.OccurrenceArrayFactory;
import java.util.LinkedList;
import java.util.List;

public class DocumentVector {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected List<Occurrence[]> occurrences = new LinkedList<Occurrence[]>();
    private OccurrenceArrayFactory occurrenceArrayFactory;
    private BufferIndex bufferIndex = new BufferIndex();
    protected BufferIndex bufferIterator = new BufferIndex();
    protected BufferIndex length = new BufferIndex();

    public DocumentVector(OccurrenceArrayFactory occurrenceArrayFactory) {
        this.occurrenceArrayFactory = occurrenceArrayFactory;
    }

    protected void addBuffer() {
        this.occurrences.add(this.occurrenceArrayFactory.getOccurrenceArray());
    }

    private void calcBufferIndex(int index, BufferIndex bi) {
        bi.bufferId = index / 1000;
        bi.indexInBuffer = index % 1000;
    }

    public void addOccurrence(int pos, int queryTermIndex) {
        Occurrence o = this.addOccurrence();
        o.pos = pos;
        o.queryTermIndex = queryTermIndex;
    }

    public Occurrence addOccurrence() {
        if (this.length.bufferId == this.occurrences.size()) {
            this.addBuffer();
        }
        Occurrence o = this.occurrences.get(this.length.bufferId)[this.length.indexInBuffer];
        this.length.increment();
        return o;
    }

    public Occurrence getOccurrence(int index) {
        this.calcBufferIndex(index, this.bufferIndex);
        return this.occurrences.get(this.bufferIndex.bufferId)[this.bufferIndex.indexInBuffer];
    }

    public int length() {
        return this.length.getValue();
    }

    public int getNextOccurrence(int pos) {
        while (this.bufferIterator.compareTo(this.length) < 0) {
            Occurrence o = this.occurrences.get(this.bufferIterator.bufferId)[this.bufferIterator.indexInBuffer];
            if (pos == o.pos) {
                this.bufferIterator.increment();
                return o.queryTermIndex;
            }
            if (pos < o.pos) {
                return -1;
            }
            this.bufferIterator.increment();
        }
        if (this.loadMoreOccurrences()) {
            return this.getNextOccurrence(pos);
        }
        return -1;
    }

    public int getNextOccurrencePosition() {
        if (this.bufferIterator.compareTo(this.length) < 0) {
            return this.occurrences.get((int)this.bufferIterator.bufferId)[this.bufferIterator.indexInBuffer].pos;
        }
        if (this.loadMoreOccurrences()) {
            return this.getNextOccurrencePosition();
        }
        return -1;
    }

    protected boolean loadMoreOccurrences() {
        return false;
    }

    public void resetOccurrenceIterator() {
        this.bufferIterator.reset();
    }

    public void releaseBuffers() {
        for (int i = 0; i < this.occurrences.size(); ++i) {
            this.occurrenceArrayFactory.releaseOccurrenceArray(this.occurrences.remove(0));
        }
    }

    protected static final class BufferIndex
    implements Comparable {
        int bufferId = 0;
        int indexInBuffer = 0;

        protected BufferIndex() {
        }

        void increment() {
            ++this.indexInBuffer;
            if (this.indexInBuffer == 1000) {
                this.indexInBuffer = 0;
                ++this.bufferId;
            }
        }

        void decrement() {
            --this.indexInBuffer;
            if (this.indexInBuffer < 0) {
                this.indexInBuffer = 999;
                --this.bufferId;
            }
        }

        void reset() {
            this.bufferId = 0;
            this.indexInBuffer = 0;
        }

        int getValue() {
            return this.bufferId * 1000 + this.indexInBuffer;
        }

        public int compareTo(Object o) {
            BufferIndex other = (BufferIndex)o;
            if (this.bufferId < other.bufferId) {
                return -1;
            }
            if (this.bufferId > other.bufferId) {
                return 1;
            }
            if (this.indexInBuffer < other.indexInBuffer) {
                return -1;
            }
            if (this.indexInBuffer > other.indexInBuffer) {
                return 1;
            }
            return 0;
        }
    }
}

