/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.summarizer;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.search.summarizer.SummarizerException;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.DocumentVector;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.DocumentVectorizerForSpecialQueries;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.DocumentVectorizerUsingIndex;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.DocumentVectorizerUsingStringComparison;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.OccurrenceArrayFactory;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.PooledOccurrenceArrayFactory;
import com.ibm.es.nuvo.search.summarizer.documentvectorizer.PrefetchingDocumentVector;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.Fragment;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.FragmentBuilder;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.FragmentFactory;
import com.ibm.es.nuvo.search.summarizer.fragmentbuilder.PooledFragmentFactory;
import com.ibm.es.nuvo.search.summarizer.highlighter.HTMLFormatter;
import com.ibm.es.nuvo.search.summarizer.highlighter.Highlighter;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightQueryTerms;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Summarizer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static OccurrenceArrayFactory occurrenceArrayFactory;
    private static FragmentFactory fragmentFactory;
    private IndexReader reader;
    private FragmentBuilder fragmentBuilder;
    private Highlighter highlighter;

    public Summarizer(IndexReader reader) {
        this.reader = reader;
        this.fragmentBuilder = new FragmentBuilder(this.getFragmentFactory());
        this.highlighter = new Highlighter(new HTMLFormatter());
    }

    private SortableDocId[] getSortedDocIds(ScoreDoc[] docs, Document[] loadedDocs, TokenizedDocument[] tokenizedDocs, int offset, int length) {
        Object[] sortedDocIds = new SortableDocId[length];
        for (int i = 0; i < length; ++i) {
            sortedDocIds[i] = new SortableDocId(docs[i + offset].doc, i, loadedDocs[i + offset], tokenizedDocs[i + offset]);
        }
        Arrays.sort(sortedDocIds);
        return sortedDocIds;
    }

    private FragmentFactory getFragmentFactory() {
        if (fragmentFactory == null) {
            fragmentFactory = PooledFragmentFactory.instance();
        }
        return fragmentFactory;
    }

    private OccurrenceArrayFactory getOccurrenceArrayFactory() {
        if (occurrenceArrayFactory == null) {
            occurrenceArrayFactory = PooledOccurrenceArrayFactory.instance();
        }
        return occurrenceArrayFactory;
    }

    private void highlightTermsUsingIndex(SortableDocId[] docIds, Summary[] summaries, int offset, HighlightQueryTerms queryTerms, String field, boolean summarize, int maxNumberOfSentences) throws SummarizerException {
        DocumentVectorizerUsingIndex vectorizer = new DocumentVectorizerUsingIndex(queryTerms, this.reader, field);
        for (int i = 0; i < docIds.length; ++i) {
            vectorizer.nextDocument(docIds[i].docId);
            PrefetchingDocumentVector documentVector = new PrefetchingDocumentVector(vectorizer, this.getOccurrenceArrayFactory(), 10);
            TokenVector tokenVector = docIds[i].getTokenVector(field);
            if (tokenVector == null) {
                summaries[((SortableDocId)docIds[i]).index + offset] = new Summary(null, false);
                continue;
            }
            summaries[((SortableDocId)docIds[i]).index + offset] = this.highlightTerms(queryTerms, documentVector, tokenVector, summarize, maxNumberOfSentences, field);
            documentVector.releaseBuffers();
        }
        if (vectorizer.getException() != null) {
            Message msg = new Message("S0076E.CANNOT_ACCESS_INDEX");
            throw new SummarizerException(msg, (Throwable)vectorizer.getException());
        }
        try {
            vectorizer.close();
        }
        catch (IOException e) {
            Message msg = new Message("S0076E.CANNOT_ACCESS_INDEX");
            throw new SummarizerException(msg, (Throwable)e);
        }
    }

    private void highlightTermsUsingStringComparison(SortableDocId[] docIds, Summary[] summaries, int offset, HighlightQueryTerms queryTerms, String field, boolean summarize, int maxNumberOfSentences) throws SummarizerException {
        DocumentVectorizerUsingStringComparison vectorizer = new DocumentVectorizerUsingStringComparison(queryTerms);
        for (int i = 0; i < docIds.length; ++i) {
            TokenVector tokenVector = docIds[i].getTokenVector(field);
            if (tokenVector == null) {
                String lookupField = "url".equals(field) ? "uri" : field;
                String stored = docIds[i].getStoredField(lookupField);
                summaries[((SortableDocId)docIds[i]).index + offset] = new Summary(stored, false);
                continue;
            }
            vectorizer.nextDocument(tokenVector);
            PrefetchingDocumentVector documentVector = new PrefetchingDocumentVector(vectorizer, this.getOccurrenceArrayFactory(), Integer.MAX_VALUE);
            summaries[((SortableDocId)docIds[i]).index + offset] = this.highlightTerms(queryTerms, documentVector, tokenVector, summarize, maxNumberOfSentences, field);
            documentVector.releaseBuffers();
        }
    }

    private void summarizeSpecialQuery(SortableDocId[] docIds, Summary[] summaries, int offset, HighlightQueryTerms queryTerms, String field, int maxNumberOfSentences) throws SummarizerException {
        DocumentVectorizerForSpecialQueries vectorizer = new DocumentVectorizerForSpecialQueries(queryTerms);
        vectorizer.setMaxCharacters(100000);
        for (int i = 0; i < docIds.length; ++i) {
            TokenVector tokenVector = docIds[i].getTokenVector(field);
            if (tokenVector == null) {
                summaries[((SortableDocId)docIds[i]).index + offset] = new Summary(null, false);
                continue;
            }
            vectorizer.nextDocument(tokenVector);
            PrefetchingDocumentVector documentVector = new PrefetchingDocumentVector(vectorizer, this.getOccurrenceArrayFactory(), Integer.MAX_VALUE);
            summaries[((SortableDocId)docIds[i]).index + offset] = this.highlightTerms(queryTerms, documentVector, tokenVector, true, maxNumberOfSentences, field);
            documentVector.releaseBuffers();
        }
    }

    private Summary highlightTerms(HighlightQueryTerms queryTerms, DocumentVector documentVector, TokenVector tokenVector, boolean summarize, int maxNumberOfSentences, String field) {
        Fragment[] fragments = summarize ? this.fragmentBuilder.buildFragments(queryTerms, tokenVector, documentVector, 2, 80) : new Fragment[]{new Fragment(){

            public int getStartToken() {
                return 0;
            }

            public int getEndToken() {
                return Integer.MAX_VALUE;
            }
        }};
        Summary summary = this.highlighter.highlight(queryTerms, field, tokenVector, documentVector, fragments, summarize);
        if (summarize) {
            this.fragmentBuilder.releaseFragments(fragments);
        }
        return summary;
    }

    public Summary[] highlightTerms(ScoreDoc[] hits, Document[] loadedDocs, TokenizedDocument[] tokenizedDocs, HighlightQueryTerms queryTerms, String field) throws SummarizerException {
        return this.highlightTerms(hits, loadedDocs, tokenizedDocs, 0, hits.length, queryTerms, field, Integer.MAX_VALUE);
    }

    public Summary[] highlightTerms(ScoreDoc[] hits, Document[] loadedDocs, TokenizedDocument[] tokenizedDocs, int offset, int length, HighlightQueryTerms queryTerms, String field) throws SummarizerException {
        return this.highlightTerms(hits, loadedDocs, tokenizedDocs, offset, length, queryTerms, field, Integer.MAX_VALUE);
    }

    public Summary[] highlightTerms(ScoreDoc[] hits, Document[] loadedDocs, TokenizedDocument[] tokenizedDocs, HighlightQueryTerms queryTerms, String field, int maxNumberOfSentences) throws SummarizerException {
        return this.highlightTerms(hits, loadedDocs, tokenizedDocs, 0, hits.length, queryTerms, field, maxNumberOfSentences);
    }

    public Summary[] highlightTerms(ScoreDoc[] hits, Document[] loadedDocs, TokenizedDocument[] tokenizedDocs, int offset, int length, HighlightQueryTerms queryTerms, String field, int maxNumberOfSentences) throws SummarizerException {
        if (hits.length == 0 || length == 0) {
            return new Summary[0];
        }
        queryTerms.initialize();
        Summary[] summaries = new Summary[length];
        SortableDocId[] docIds = this.getSortedDocIds(hits, loadedDocs, tokenizedDocs, offset, length);
        this.highlightTermsUsingStringComparison(docIds, summaries, 0, queryTerms, field, false, maxNumberOfSentences);
        return summaries;
    }

    public List<Map<String, Summary>> highlightTerms(ScoreDoc[] hits, Document[] loadedDocs, TokenizedDocument[] tokenizedDocs, Map<String, HighlightQueryTerms> queryTermsMap, String[] fields) throws SummarizerException {
        return this.highlightTerms(hits, loadedDocs, tokenizedDocs, 0, hits.length, queryTermsMap, fields);
    }

    public List<Map<String, Summary>> highlightTerms(ScoreDoc[] hits, Document[] loadedDocs, TokenizedDocument[] tokenizedDocs, int offset, int length, Map<String, HighlightQueryTerms> queryTermsMap, String[] fields) throws SummarizerException {
        int i;
        ArrayList<Map<String, Summary>> results = new ArrayList<Map<String, Summary>>();
        for (i = 0; i < length; ++i) {
            HashMap summaryMap = new HashMap();
            results.add(summaryMap);
        }
        for (i = 0; i < fields.length; ++i) {
            HighlightQueryTerms queryTerms = queryTermsMap.get(fields[i]);
            if (queryTerms == null) continue;
            Summary[] summaries = this.highlightTerms(hits, loadedDocs, tokenizedDocs, offset, length, queryTerms, fields[i]);
            for (int j = 0; j < length; ++j) {
                ((Map)results.get(j)).put(fields[i], summaries[j]);
            }
        }
        return results;
    }

    public Summary[] getSummaries(ScoreDoc[] hits, Document[] loadedDocs, TokenizedDocument[] tokenizedDocs, HighlightQueryTerms queryTerms, String field) throws SummarizerException {
        return this.getSummaries(hits, loadedDocs, tokenizedDocs, 0, hits.length, queryTerms, field);
    }

    public Summary[] getSummaries(ScoreDoc[] hits, Document[] loadedDocs, TokenizedDocument[] tokenizedDocs, int offset, int length, HighlightQueryTerms queryTerms, String field) throws SummarizerException {
        if (hits.length == 0 || length == 0) {
            return new Summary[0];
        }
        queryTerms.initialize();
        Summary[] summaries = new Summary[length];
        SortableDocId[] docIds = this.getSortedDocIds(hits, loadedDocs, tokenizedDocs, offset, length);
        if (queryTerms.isSpecialQuery()) {
            this.summarizeSpecialQuery(docIds, summaries, 0, queryTerms, field, Integer.MAX_VALUE);
        } else {
            this.highlightTermsUsingIndex(docIds, summaries, 0, queryTerms, field, true, Integer.MAX_VALUE);
        }
        return summaries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SortableDocId
    implements Comparable<SortableDocId> {
        private int docId;
        private int index;
        private Document document;
        private TokenizedDocument tokenizedDocument;

        SortableDocId(int docId, int index, Document doc, TokenizedDocument td) {
            this.docId = docId;
            this.index = index;
            this.document = doc;
            this.tokenizedDocument = td;
        }

        @Override
        public int compareTo(SortableDocId other) {
            if (this.docId < other.docId) {
                return -1;
            }
            if (this.docId > other.docId) {
                return 1;
            }
            return 0;
        }

        TokenVector getTokenVector(String field) throws SummarizerException {
            if (field.equals("language") || field.equals("doctype")) {
                String content = this.getStoredField(field);
                if (content == null) {
                    return null;
                }
                TokenVector tokenVector = new TokenVector();
                tokenVector.addToken(TToken.newToken(content, TToken.Type.ORIGINAL));
                return tokenVector;
            }
            TokenVector tv = this.tokenizedDocument.getField(field);
            return tv;
        }

        String getStoredField(String field) {
            return this.document.get(field);
        }
    }

    public static final class Summary {
        private String summary;
        private boolean containsHighlightedTerms;
        private Document document;
        private int shortVersionBreakPosition;

        public Summary(String summary, boolean containsHighlightedTerms) {
            this(summary, containsHighlightedTerms, null);
        }

        public Summary(String summary, boolean containsHighlightedTerms, Document doc) {
            this.summary = summary;
            this.containsHighlightedTerms = containsHighlightedTerms;
            this.document = doc;
        }

        public String toString() {
            return this.summary;
        }

        public boolean containsHighlightedTerms() {
            return this.containsHighlightedTerms;
        }

        public Document getDocument() {
            return this.document;
        }

        public int getShortVersionBreakPosition() {
            return this.shortVersionBreakPosition;
        }

        public void setShortVersionBreakPosition(int shortVersionBreakPosition) {
            this.shortVersionBreakPosition = shortVersionBreakPosition;
        }
    }
}

