/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.servlets;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.XMLDOMUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SearchServlet
extends HttpServlet {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 3046713457544749029L;
    private String AbsoluteWhitneyPackageHome = "";
    private String RelativeCustomizationDir = "/config/customskins/";
    private Hashtable<String, Transformer> xslTransformers = new Hashtable();
    private Hashtable<String, Long> xslTransformersTS = new Hashtable();
    private Hashtable<String, Document> xmlPageStructureDoc = new Hashtable();
    private Hashtable<String, Long> xmlPageStructureDocTS = new Hashtable();
    private String getParamQuery = "";
    private String getParamIndex = "";
    private String getParamStartOffset = "";
    private String getParamResults = "";
    private String getParamSkin = "";

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.receiveGetParameters(request);
            String currentSkinName = this.getParamSkin;
            Transformer currentXSLTransformer = this.getXSLTransformer(currentSkinName);
            Document pageStructureXMLDoc = this.getPageStructureXML(currentSkinName);
            Document resultSetXMLDoc = this.getResultSetXML();
            Document sessionVariablesXMLDoc = this.getSessionVariablesXML();
            Document mergedXMLDoc = this.getMergedXML(pageStructureXMLDoc, resultSetXMLDoc, sessionVariablesXMLDoc);
            PrintWriter out = response.getWriter();
            StreamResult streamResult = new StreamResult(out);
            this.applyXSLTransformation(currentXSLTransformer, mergedXMLDoc, streamResult);
        }
        catch (Throwable t) {
            ExtendedException e = new ExtendedException(t);
            try {
                response.sendError(500, e.getFormattedText(request.getLocale(), true));
            }
            catch (IOException e1) {
                Loggers.logger.log(new ExtendedException(e1));
                throw e1;
            }
            return;
        }
    }

    public void init() throws ServletException {
        this.AbsoluteWhitneyPackageHome = GlobalConfiguration.getConfiguration().getInstallPath();
        this.l("Absolute customization path = " + this.AbsoluteWhitneyPackageHome + this.RelativeCustomizationDir);
    }

    private Transformer getXSLTransformer(String skinName) {
        this.l("GET XSL TRANSFORMER...");
        Transformer currentTransformer = null;
        String fileName = this.AbsoluteWhitneyPackageHome + this.RelativeCustomizationDir + skinName + "/xsl/MainStylesheet.xsl";
        boolean reloadXSLFile = true;
        if (this.xslTransformers.containsKey(skinName)) {
            this.l("  XSL for skin " + skinName + " already cached. Check if still valid.");
            long newTimeStamp = 0L;
            try {
                newTimeStamp = new File(fileName).lastModified();
            }
            catch (Exception ex) {
                this.p("Exception = " + ex);
                ex.printStackTrace();
            }
            if (this.xslTransformersTS.get(skinName).equals(newTimeStamp)) {
                reloadXSLFile = false;
                this.l("  XSL timestamps are the same. No need to reload stylesheet.");
            } else {
                this.l("  XSL timestamps differ!");
            }
        } else {
            this.l("  XSL for skin " + skinName + " is not cached!");
        }
        if (reloadXSLFile) {
            this.l("  Load/reload XSL for skin " + skinName + "...");
            StreamSource xslSource = null;
            try {
                xslSource = new StreamSource(new File(fileName));
            }
            catch (Exception ex) {
                this.p("Exception = " + ex);
                ex.printStackTrace();
            }
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                currentTransformer = transformerFactory.newTransformer(xslSource);
                this.xslTransformers.put(skinName, currentTransformer);
                long timeStamp = new File(fileName).lastModified();
                this.xslTransformersTS.put(skinName, timeStamp);
            }
            catch (Exception ex) {
                this.p("Exception = " + ex);
                ex.printStackTrace();
            }
        }
        return this.xslTransformers.get(skinName);
    }

    private void receiveGetParameters(HttpServletRequest request) {
        if (request.getParameter("query") != null) {
            this.getParamQuery = request.getParameter("query");
        }
        if (request.getParameter("index") != null) {
            this.getParamIndex = request.getParameter("index");
        }
        if (request.getParameter("start") != null) {
            this.getParamStartOffset = request.getParameter("start");
        }
        if (request.getParameter("results") != null) {
            this.getParamResults = request.getParameter("results");
        }
        this.getParamSkin = request.getParameter("skin") != null ? request.getParameter("skin") : "default";
    }

    private Document getResultSetXML() {
        String ipAddress = "localhost";
        int port = 8888;
        String msg = "/whitney/api/search?query=" + this.getParamQuery + "&index=" + this.getParamIndex + "&start=" + this.getParamStartOffset + "&results=" + this.getParamResults;
        Document document = null;
        try {
            this.l("Sending msg " + msg + " to " + ipAddress + ":" + port);
            URL url = new URL("http", ipAddress, port, msg);
            HttpURLConnection connection = null;
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            this.l("Response Code = " + connection.getResponseCode());
            InputStream is = (InputStream)connection.getContent();
            document = XMLDOMUtils.readAsNonValidatingDOM(is);
            OutputFormat format = new OutputFormat(document);
            format.setLineWidth(65);
            format.setIndenting(true);
            format.setIndent(2);
        }
        catch (MalformedURLException ex1) {
            this.p("Exception = " + ex1);
            ex1.printStackTrace();
        }
        catch (IOException ex2) {
            this.p("Exception = " + ex2);
            ex2.printStackTrace();
        }
        catch (ParserConfigurationException ex3) {
            this.p("Exception = " + ex3);
            ex3.printStackTrace();
        }
        catch (SAXException ex4) {
            this.p("Exception = " + ex4);
            ex4.printStackTrace();
        }
        return document;
    }

    private Document getPageStructureXML(String skinName) {
        this.l("GET XSL TRANSFORMER...");
        Document pageStructureXMLDoc = null;
        String fileName = this.AbsoluteWhitneyPackageHome + this.RelativeCustomizationDir + skinName + "/xml/PageStructure.xml";
        boolean reloadXMLFile = true;
        if (this.xmlPageStructureDoc.containsKey(skinName)) {
            long newTimeStamp = new File(fileName).lastModified();
            if (this.xmlPageStructureDocTS.get(skinName).equals(newTimeStamp)) {
                reloadXMLFile = false;
            }
        }
        if (reloadXMLFile) {
            DOMParser parser = new DOMParser();
            try {
                parser.parse(fileName);
            }
            catch (IOException e) {
                this.p("Exception = " + e);
                e.printStackTrace();
            }
            catch (SAXException e) {
                this.p("Exception = " + e);
                e.printStackTrace();
            }
            pageStructureXMLDoc = parser.getDocument();
            this.xmlPageStructureDoc.put(skinName, pageStructureXMLDoc);
            long timeStamp = new File(fileName).lastModified();
            this.xmlPageStructureDocTS.put(skinName, timeStamp);
        }
        return this.xmlPageStructureDoc.get(skinName);
    }

    private Document getSessionVariablesXML() {
        Document sessionVarsXMLDoc = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            sessionVarsXMLDoc = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.p("Exception = " + e);
            e.printStackTrace();
        }
        Element rootElement = sessionVarsXMLDoc.createElement("SessionVariables");
        sessionVarsXMLDoc.appendChild(rootElement);
        Element itfLang = sessionVarsXMLDoc.createElement("InterfaceLanguage");
        itfLang.appendChild(sessionVarsXMLDoc.createTextNode("EN_US"));
        rootElement.appendChild(itfLang);
        return sessionVarsXMLDoc;
    }

    private Document getMergedXML(Document pageStructureXMLDoc, Document resultSetXMLDoc, Document sessionVariablesXMLDoc) {
        Document mergedXMLDoc = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            mergedXMLDoc = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.p("Exception = " + e);
            e.printStackTrace();
        }
        Element rootElement = mergedXMLDoc.createElement("Response");
        mergedXMLDoc.appendChild(rootElement);
        Element searchResponseElem = resultSetXMLDoc.getDocumentElement();
        rootElement.appendChild(rootElement.getOwnerDocument().importNode(searchResponseElem, true));
        Element pageStructureElem = pageStructureXMLDoc.getDocumentElement();
        rootElement.appendChild(rootElement.getOwnerDocument().importNode(pageStructureElem, true));
        Element sessionVarsElem = sessionVariablesXMLDoc.getDocumentElement();
        rootElement.appendChild(rootElement.getOwnerDocument().importNode(sessionVarsElem, true));
        OutputFormat format = new OutputFormat(mergedXMLDoc);
        format.setLineWidth(65);
        format.setIndenting(true);
        format.setIndent(2);
        return mergedXMLDoc;
    }

    private void applyXSLTransformation(Transformer xslTransformer, Document mergedXMLDoc, StreamResult streamResult) {
        DOMSource source = new DOMSource(mergedXMLDoc);
        try {
            xslTransformer.transform(source, streamResult);
        }
        catch (Exception ex) {
            this.p("Exception = " + ex);
            ex.printStackTrace();
        }
    }

    private void p(String outputString) {
        System.out.println(outputString);
    }

    private void l(String logString) {
        System.out.println(logString);
    }
}

