/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.security;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.authentication.LocalOSAuthenticationModule;
import com.ibm.es.nuvo.authentication.UserIdPasswordException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.security.DSSecurityManager;
import com.ibm.es.nuvo.crawler.security.DomainValidationException;
import com.ibm.es.nuvo.crawler.security.model.Identity;
import com.ibm.es.nuvo.crawler.security.model.SecurityDomain;
import com.ibm.es.nuvo.crawler.security.model.UserGroupInformationList;
import com.ibm.es.nuvo.crawler.security.model.UserPasswordCredential;
import com.ibm.es.nuvo.crawler.security.model.UserValidationResult;
import com.ibm.es.nuvo.search.security.IdentityContext;
import com.ibm.supa.config.AnalysisScopeConfig;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.security.AuthObjectLookup;
import com.ibm.supa.security.AuthenticationModule;
import com.ibm.supa.security.Permission;
import com.ibm.supa.security.PermissionsModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSecurityContext {
    private static String FULL_TOKEN = "|0";
    private static String PARTIAL_TOKEN = "|1";
    private static String SECURITY_LEVEL_1 = "|1";
    private static String SECURITY_LEVEL_2 = "|2";
    private static String SECURITY_LEVEL_UNKNOWN = "|0";
    private static String[] securityLevels = new String[]{SECURITY_LEVEL_UNKNOWN, SECURITY_LEVEL_1, SECURITY_LEVEL_2};
    private UserPasswordCredential authenticatedCredential = null;
    private List<Identity> identities = new ArrayList<Identity>();
    private PermissionsModule permissionsModule;
    private Map<String, Set<? extends Permission>> loadedPermissions;
    private Map<String, Long> timeouts;
    private boolean administrator;

    public UserSecurityContext(String userId, String password) throws DomainValidationException, UserIdPasswordException {
        this(userId, password, false);
    }

    public UserSecurityContext(String userId, String password, boolean administrator) throws DomainValidationException, UserIdPasswordException {
        this.administrator = administrator;
        AuthenticationModule supaAuth = ConfigurationLoader.getGlobalConfig().getAuthenticationModule();
        UserPasswordCredential credential = new UserPasswordCredential();
        credential.setUsername(userId);
        credential.setPassword(password);
        this.permissionsModule = supaAuth.createPermissionsModule(credential);
        if (this.permissionsModule == null || !this.permissionsModule.authenticate()) {
            throw new UserIdPasswordException(null);
        }
        this.loadedPermissions = new HashMap<String, Set<? extends Permission>>();
        this.timeouts = new HashMap<String, Long>();
        if (!supaAuth.isLocalOSLoginRequired()) {
            this.authenticatedCredential = credential;
            return;
        }
        credential = new UserPasswordCredential();
        credential.setUsername(LocalOSAuthenticationModule.getFullyQualifiedUserId(userId));
        credential.setPassword(password);
        DSSecurityManager manager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getSecurityManager();
        List<SecurityDomain> domains = manager.getAllDomainNames();
        if (domains.size() <= 0) {
            Message msg = new Message("C3803E.CRWL_SECURITY_DOMAINS_NOT_FOUND");
            throw new DomainValidationException(msg);
        }
        IdentityContext identityContext = new IdentityContext();
        identityContext.setDomain(domains.get(0));
        identityContext.setCredential(credential);
        UserValidationResult result = manager.validateUserInformation(identityContext);
        if (!result.isValid()) {
            throw new UserIdPasswordException(null);
        }
        UserGroupInformationList list = manager.getUserGroupInformationList(identityContext);
        identityContext.setUserGroupInformationList(list);
        this.identities.add(identityContext);
        this.authenticatedCredential = credential;
    }

    public synchronized boolean hasPermission(String collectionId, Permission permission) {
        if (this.permissionsModule == null) {
            return false;
        }
        if (!this.loadedPermissions.containsKey(collectionId)) {
            return this.loadPermissionsAndCheck(collectionId, permission);
        }
        Long timeout = this.timeouts.get(collectionId);
        if (timeout == null || timeout < System.currentTimeMillis()) {
            return this.loadPermissionsAndCheck(collectionId, permission);
        }
        return this.loadedPermissions.get(collectionId).contains(permission);
    }

    private boolean loadPermissionsAndCheck(String collectionId, Permission permission) {
        AuthObjectLookup authObjectLookup;
        Set<Enum> permissions;
        this.loadedPermissions.remove(collectionId);
        this.timeouts.remove(collectionId);
        AnalysisScopeConfig analysisScopeConfig = ConfigurationLoader.getAnalysisScopeConfig(collectionId);
        if (this.administrator) {
            AuthObjectLookup.AdminAuthObjectLookup<?> adminAuthLocationLookup = analysisScopeConfig.getAdminAuthLocationLookup();
            permissions = this.permissionsModule.loadAdminPermissions(adminAuthLocationLookup);
            authObjectLookup = adminAuthLocationLookup;
        } else {
            AuthObjectLookup.UserAuthObjectLookup<?> userAuthLocationLookup = analysisScopeConfig.getUserAuthLocationLookup();
            permissions = this.permissionsModule.loadUserPermissions(userAuthLocationLookup);
            authObjectLookup = userAuthLocationLookup;
        }
        long timeout = authObjectLookup.getTimeout();
        if (timeout > 0L) {
            this.loadedPermissions.put(collectionId, permissions);
            this.timeouts.put(collectionId, System.currentTimeMillis() + timeout);
        }
        return permissions.contains(permission);
    }

    public String getAuthenticatedUserId() {
        return this.authenticatedCredential.getUsername();
    }

    public List<Identity> getIdentities() {
        return this.identities;
    }

    public static String generateACLToken(String value, int level, boolean isPartial) {
        return value + securityLevels[level] + (isPartial ? PARTIAL_TOKEN : FULL_TOKEN);
    }

    public String toString() {
        String toString = "";
        for (Identity identity : this.identities) {
            toString = toString + identity;
        }
        return toString;
    }
}

