/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.security;

import com.ibm.es.nuvo.common.Constants;
import com.ibm.es.nuvo.crawler.security.model.Identity;
import com.ibm.es.nuvo.crawler.security.model.UserGroupInformation;
import com.ibm.es.nuvo.search.query.NegatedQuery;
import com.ibm.es.nuvo.search.security.UserSecurityContext;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class QueryBuilder {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static Query buildSecurity(UserSecurityContext securityContext) {
        boolean isPartial = false;
        BooleanQuery securityQuery = new BooleanQuery(true);
        securityQuery.setBoost(0.0f);
        securityQuery.add(new BooleanClause((Query)new NegatedQuery((Query)new TermQuery(Constants.SECURITY_ON_TERM)), BooleanClause.Occur.SHOULD));
        if (securityContext == null) {
            return securityQuery;
        }
        List<Identity> identities = securityContext.getIdentities();
        if (identities == null) {
            return securityQuery;
        }
        for (Identity identity : identities) {
            String userName = identity.getCredential().getUsername();
            for (UserGroupInformation domain : identity.getUserGroupInformationList().getUserGroups()) {
                int numLevels = domain.getACLLevel();
                String domainId = domain.getSecurityDomainId();
                List<String> groupNames = domain.getGroupNames();
                String secFieldName = "_sec_" + domainId;
                BooleanQuery domainQuery = new BooleanQuery(true);
                for (int level = 1; level <= numLevels; ++level) {
                    BooleanQuery levelQuery = new BooleanQuery(true);
                    String userACLToken = UserSecurityContext.generateACLToken(userName, level, isPartial);
                    levelQuery.add(new BooleanClause((Query)new TermQuery(new Term(secFieldName, userACLToken)), BooleanClause.Occur.SHOULD));
                    for (String groupName : groupNames) {
                        String groupACLToken = UserSecurityContext.generateACLToken(groupName, level, isPartial);
                        levelQuery.add(new BooleanClause((Query)new TermQuery(new Term(secFieldName, groupACLToken)), BooleanClause.Occur.SHOULD));
                    }
                    domainQuery.add(new BooleanClause((Query)levelQuery, BooleanClause.Occur.MUST));
                }
                if (domainQuery.clauses().size() <= 0) continue;
                securityQuery.add(new BooleanClause((Query)domainQuery, BooleanClause.Occur.SHOULD));
            }
        }
        return securityQuery;
    }
}

