/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query.xpath;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.markup.query.MarkupAndQuery;
import com.ibm.es.nuvo.markup.query.MarkupAttributeQuery;
import com.ibm.es.nuvo.markup.query.MarkupBooleanQuery;
import com.ibm.es.nuvo.markup.query.MarkupContainsQuery;
import com.ibm.es.nuvo.markup.query.MarkupLeafQuery;
import com.ibm.es.nuvo.markup.query.MarkupOrQuery;
import com.ibm.es.nuvo.markup.query.MarkupTagQuery;
import com.ibm.es.nuvo.markup.search.spans.SpanMultiPhraseQuery;
import com.ibm.es.nuvo.markup.search.spans.SpanMultiTermQuery;
import com.ibm.es.nuvo.markup.search.spans.SpanNumericQuery;
import com.ibm.es.nuvo.search.query.NegatedQuery;
import com.ibm.es.nuvo.search.query.ProximityQuery;
import com.ibm.es.nuvo.search.query.xpath.XPathComparison;
import com.ibm.es.nuvo.search.query.xpath.XPathContains;
import com.ibm.es.nuvo.search.query.xpath.XPathLiteral;
import com.ibm.es.nuvo.search.query.xpath.XPathLogicalOp;
import com.ibm.es.nuvo.search.query.xpath.XPathQuery;
import com.ibm.es.nuvo.util.decimal.Decimal;
import com.ibm.es.nuvo.util.decimal.DecimalCondition;
import com.ibm.es.nuvo.util.decimal.DecimalEquals;
import com.ibm.es.nuvo.util.decimal.DecimalLower;
import com.ibm.es.nuvo.util.decimal.DecimalNotEquals;
import com.ibm.es.nuvo.util.decimal.DecimalUpper;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;

public class XPathToMarkup {
    public static MarkupBooleanQuery convertToMarkup(XPathQuery inputTree) throws ExtendedException {
        return inputTree == null ? null : XPathToMarkup.toMarkup(inputTree, new MarkupAndQuery(), BooleanClause.Occur.MUST);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MarkupBooleanQuery toMarkup(XPathQuery inputTree, MarkupBooleanQuery outputTree, BooleanClause.Occur incomingAttachSense) throws ExtendedException {
        void var3_10;
        Object var3_3 = null;
        MarkupLeafQuery mlq = null;
        String fieldName = inputTree.getPathContext().isAttribute() ? "_xmlvals" : "_plain";
        BooleanClause.Occur outgoingAttachSense = incomingAttachSense;
        if (inputTree instanceof XPathLogicalOp) {
            XPathLogicalOp.Op logicalOperator = ((XPathLogicalOp)inputTree).getOperator();
            if (logicalOperator == XPathLogicalOp.Op.And) {
                MarkupAndQuery markupAndQuery = new MarkupAndQuery();
                outgoingAttachSense = BooleanClause.Occur.MUST;
            } else if (logicalOperator == XPathLogicalOp.Op.Or) {
                MarkupOrQuery markupOrQuery = new MarkupOrQuery();
                outgoingAttachSense = BooleanClause.Occur.SHOULD;
            } else {
                if (logicalOperator != XPathLogicalOp.Op.Not) throw new IllegalStateException("Unexpected logical operator " + (Object)((Object)logicalOperator));
                outgoingAttachSense = BooleanClause.Occur.MUST_NOT;
            }
        } else {
            if (inputTree instanceof XPathContains) {
                XPathContains xpc = (XPathContains)inputTree;
                if (xpc.getQuery() != null) {
                    BooleanClause[] booleanClauseArray = XPathToMarkup.convertParsedQuery(xpc.getQuery(), fieldName, incomingAttachSense);
                    for (int j = 0; j < booleanClauseArray.length; ++j) {
                        outputTree.add(booleanClauseArray[j], false);
                    }
                    return outputTree;
                }
                System.out.println("Should not get here 2.");
                return null;
            }
            if (inputTree instanceof XPathComparison) {
                XPathComparison xc = (XPathComparison)inputTree;
                String string = inputTree.getPathContext().getName();
                if (xc.getQuery() != null) {
                    MarkupBooleanQuery markupBooleanQuery = XPathToMarkup.convertStringComparison(xc.getOperator(), xc.getQuery());
                } else {
                    mlq = XPathToMarkup.convertNumericComparison(xc.getOperator(), xc.getValue(), string);
                }
            } else {
                int inputDepth = inputTree.getDepth();
                if (inputDepth == 1 && (inputTree.getParent() == null || inputTree.isAttribute())) {
                    inputDepth = 0;
                }
                if (!inputTree.getName().equals("*")) {
                    void var8_22;
                    XPathQuery xPathQuery = inputTree.getParent();
                    while (var8_22 != null && var8_22.getName().equals("*")) {
                        inputDepth += var8_22.getDepth();
                        XPathQuery xPathQuery2 = var8_22.getParent();
                    }
                    MarkupTagQuery markupTagQuery = inputTree.isAttribute() ? new MarkupAttributeQuery(inputTree.getName()) : new MarkupTagQuery(inputTree.getName(), inputTree.isTarget());
                    MarkupContainsQuery markupContainsQuery = new MarkupContainsQuery(BooleanClause.Occur.MUST, markupTagQuery, inputDepth);
                } else if (inputTree.getChildren() == null || inputTree.getChildren().size() == 0) {
                    boolean bl;
                    boolean bl2 = true;
                    for (XPathQuery p = inputTree.getParent(); p != null; p = p.getParent()) {
                        if (p.getName().equals("*")) {
                            inputDepth += p.getDepth();
                            continue;
                        }
                        bl = false;
                        break;
                    }
                    if (bl) {
                        throw new ExtendedException(new Message("X0051E.XML"));
                    }
                }
            }
        }
        if (mlq != null) {
            outputTree.add(new BooleanClause(mlq, incomingAttachSense));
            return null;
        }
        if (var3_10 != null) {
            outputTree.add(new BooleanClause((Query)var3_10, incomingAttachSense));
            outputTree = var3_10;
        }
        if (inputTree.getChildren() == null) return outputTree;
        Iterator it = inputTree.getChildren().iterator();
        while (it.hasNext()) {
            XPathToMarkup.toMarkup((XPathQuery)it.next(), outputTree, outgoingAttachSense);
        }
        return outputTree;
    }

    private static MarkupLeafQuery convertNumericComparison(XPathComparison.Op op, XPathLiteral comparisonValue, String attributeName) {
        Decimal decimal;
        Decimal decimal2 = comparisonValue.doubleLiteral != null ? new Decimal(comparisonValue.doubleLiteral, 3) : (decimal = comparisonValue.longLiteral != null ? new Decimal(comparisonValue.longLiteral) : Decimal.parseDecimal(comparisonValue.stringLiteral, 3));
        DecimalCondition check = op == XPathComparison.Op.Equal ? new DecimalEquals(decimal) : (op == XPathComparison.Op.NotEqual ? new DecimalNotEquals(decimal) : (op == XPathComparison.Op.GreaterThan ? new DecimalLower(decimal, false) : (op == XPathComparison.Op.GreaterThanOrEqual ? new DecimalLower(decimal, true) : (op == XPathComparison.Op.LessThan ? new DecimalUpper(decimal, false) : new DecimalUpper(decimal, true)))));
        SpanNumericQuery sq = new SpanNumericQuery(attributeName, check);
        return new MarkupLeafQuery((Query)sq, (SpanQuery)sq);
    }

    private static MarkupBooleanQuery convertStringComparison(XPathComparison.Op op, Query comparisonQuery) throws ExtendedException {
        if (comparisonQuery instanceof ProximityQuery) {
            comparisonQuery = ((ProximityQuery)comparisonQuery).getTextQuery();
        }
        if (!(comparisonQuery instanceof BooleanQuery)) {
            Message m = new Message("X0038E.XML");
            m.addArgument("T:" + comparisonQuery.getClass().getName());
            throw new ExtendedException(m);
        }
        BooleanClause[] originalClauses = ((BooleanQuery)comparisonQuery).getClauses();
        MarkupOrQuery moq = new MarkupOrQuery();
        for (int j = 0; j < originalClauses.length; ++j) {
            MarkupLeafQuery mlq;
            Query subquery1 = originalClauses[j].getQuery();
            if (subquery1 instanceof TermQuery) {
                if (((TermQuery)subquery1).getTerm().text().indexOf(1) >= 0) continue;
                TermQuery termQuery = (TermQuery)subquery1;
                SpanTermQuery spanTermQuery = new SpanTermQuery(termQuery.getTerm());
                moq.add(XPathToMarkup.getBooleanClause(originalClauses[j].getOccur(), (Query)termQuery, (SpanQuery)spanTermQuery)[0], true);
                continue;
            }
            if (subquery1 instanceof MultiTermQuery) {
                try {
                    SpanMultiTermQuery spanMultiTermQuery = new SpanMultiTermQuery(subquery1);
                    mlq = new MarkupLeafQuery(comparisonQuery, spanMultiTermQuery);
                    mlq.setCompleteMatchRequired(true);
                    moq.add(mlq, originalClauses[j].getOccur(), true);
                    continue;
                }
                catch (IOException e) {
                    Message m = new Message("X0038E.XML");
                    m.addArgument("IOException");
                    throw new ExtendedException(m, (Throwable)e);
                }
            }
            if (subquery1 instanceof MultiPhraseQuery) {
                SpanMultiPhraseQuery spanMultiPhraseQuery = new SpanMultiPhraseQuery((MultiPhraseQuery)subquery1);
                mlq = new MarkupLeafQuery(comparisonQuery, spanMultiPhraseQuery);
                mlq.setCompleteMatchRequired(true);
                moq.add(mlq, originalClauses[j].getOccur(), true);
                continue;
            }
            if (subquery1 instanceof BooleanQuery) {
                BooleanClause[] subclauses = ((BooleanQuery)subquery1).getClauses();
                MarkupOrQuery moq2 = new MarkupOrQuery();
                for (int k = 0; k < subclauses.length; ++k) {
                    Query subquery2 = subclauses[k].getQuery();
                    if (subquery2 instanceof TermQuery) {
                        if (((TermQuery)subquery2).getTerm().text().indexOf(1) >= 0) continue;
                        TermQuery termQuery = (TermQuery)subquery2;
                        SpanTermQuery spanTermQuery = new SpanTermQuery(termQuery.getTerm());
                        moq2.add(XPathToMarkup.getBooleanClause(subclauses[k].getOccur(), (Query)termQuery, (SpanQuery)spanTermQuery)[0], true);
                        continue;
                    }
                    Message m = new Message("X0038E.XML");
                    m.addArgument("2:" + subquery2.getClass().getName());
                    throw new ExtendedException(m);
                }
                if (moq2.clauses().size() <= 0) continue;
                moq.add((Query)moq2, originalClauses[j].getOccur(), true);
                continue;
            }
            Message m = new Message("X0038E.XML");
            m.addArgument("3:" + subquery1.getClass().getName());
            throw new ExtendedException(m);
        }
        if (op == XPathComparison.Op.NotEqual) {
            MarkupAndQuery maq = new MarkupAndQuery();
            maq.add(new BooleanClause((Query)moq, BooleanClause.Occur.MUST_NOT), true);
            return maq;
        }
        return moq;
    }

    private static BooleanClause[] convertParsedQuery(Query query, String fieldName, BooleanClause.Occur attachSense) throws ExtendedException {
        BooleanClause[] result = null;
        if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            SpanTermQuery spanTermQuery = new SpanTermQuery(termQuery.getTerm());
            result = XPathToMarkup.getBooleanClause(attachSense, (Query)termQuery, (SpanQuery)spanTermQuery);
        } else if (query instanceof ProximityQuery) {
            ProximityQuery proximityQuery = (ProximityQuery)query;
            result = XPathToMarkup.convertParsedQuery(proximityQuery.getTextQuery(), fieldName, attachSense);
        } else if (query instanceof PhraseQuery) {
            PhraseQuery phraseQuery = (PhraseQuery)query;
            SpanNearQuery spanNearQuery = XPathToMarkup.phraseQuery2SpanNearQuery(phraseQuery, fieldName);
            result = XPathToMarkup.getBooleanClause(attachSense, query, (SpanQuery)spanNearQuery);
        } else if (query instanceof MultiTermQuery || query instanceof PrefixQuery || query instanceof RangeQuery) {
            SpanMultiTermQuery spanMultiTermQuery = null;
            try {
                spanMultiTermQuery = new SpanMultiTermQuery(query);
            }
            catch (IOException e) {
                throw new ExtendedException(e.getMessage());
            }
            result = XPathToMarkup.getBooleanClause(attachSense, query, spanMultiTermQuery);
        } else if (query instanceof MultiPhraseQuery) {
            SpanMultiPhraseQuery spanMultiPhraseQuery = null;
            spanMultiPhraseQuery = new SpanMultiPhraseQuery((MultiPhraseQuery)query);
            result = XPathToMarkup.getBooleanClause(attachSense, query, spanMultiPhraseQuery);
        } else if (query instanceof NegatedQuery) {
            MarkupOrQuery mbq = new MarkupOrQuery();
            boolean force = false;
            BooleanClause[] subResults = XPathToMarkup.convertParsedQuery(((NegatedQuery)query).getQuery(), fieldName, BooleanClause.Occur.MUST_NOT);
            for (int j = 0; j < subResults.length; ++j) {
                ((MarkupBooleanQuery)mbq).add(subResults[j], force);
            }
            result = new BooleanClause[]{new BooleanClause((Query)mbq, attachSense)};
        } else if (query instanceof BooleanQuery) {
            int lim;
            BooleanQuery booleanQuery = (BooleanQuery)query;
            BooleanClause[] clauses = booleanQuery.getClauses();
            MarkupBooleanQuery mbq = null;
            boolean hasMust = false;
            boolean hasShould = false;
            boolean force = false;
            int n = lim = clauses == null ? 0 : clauses.length;
            for (int j = 0; j < lim; ++j) {
                if (clauses[j].getOccur() == BooleanClause.Occur.MUST) {
                    hasMust = true;
                    continue;
                }
                if (clauses[j].getOccur() != BooleanClause.Occur.SHOULD) continue;
                hasShould = true;
            }
            if (hasMust) {
                if (!hasShould) {
                    mbq = new MarkupAndQuery();
                } else {
                    mbq = new MarkupOrQuery();
                    force = true;
                }
            } else {
                mbq = new MarkupOrQuery();
            }
            for (int i = 0; i < clauses.length; ++i) {
                BooleanClause[] subResults = XPathToMarkup.convertParsedQuery(clauses[i].getQuery(), fieldName, clauses[i].getOccur());
                for (int j = 0; j < subResults.length; ++j) {
                    mbq.add(subResults[j], force);
                }
            }
            result = new BooleanClause[]{new BooleanClause((Query)mbq, attachSense)};
        } else {
            Message m = new Message("X0038E.XML");
            m.addArgument(query.getClass().getName());
            throw new ExtendedException(m);
        }
        return result;
    }

    private static BooleanClause[] getBooleanClause(BooleanClause.Occur attachSense, Query query, SpanQuery spanQuery) {
        BooleanClause[] result = new BooleanClause[]{new BooleanClause((Query)new MarkupLeafQuery(query, spanQuery), attachSense)};
        return result;
    }

    private static SpanNearQuery phraseQuery2SpanNearQuery(PhraseQuery phraseQuery, String fieldName) {
        Term[] phraseQueryTerms = phraseQuery.getTerms();
        SpanQuery[] spanSubqueries = new SpanQuery[phraseQueryTerms.length];
        for (int j = 0; j < phraseQueryTerms.length; ++j) {
            spanSubqueries[j] = phraseQueryTerms[j].field().equals(fieldName) ? new SpanTermQuery(phraseQueryTerms[j]) : new SpanTermQuery(new Term(phraseQueryTerms[j].text(), fieldName));
        }
        return new SpanNearQuery(spanSubqueries, phraseQuery.getSlop(), true);
    }
}

