/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query.xpath;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.markup.query.MarkupBooleanQuery;
import com.ibm.es.nuvo.search.query.LinguisticQueryParser;
import com.ibm.es.nuvo.search.query.ParsedQuery;
import com.ibm.es.nuvo.search.query.xpath.XPathComparison;
import com.ibm.es.nuvo.search.query.xpath.XPathContains;
import com.ibm.es.nuvo.search.query.xpath.XPathLiteral;
import com.ibm.es.nuvo.search.query.xpath.XPathLogicalOp;
import com.ibm.es.nuvo.search.query.xpath.XPathQuery;
import com.ibm.es.nuvo.search.query.xpath.XPathQueryParserPool;
import com.ibm.es.nuvo.search.query.xpath.XPathToMarkup;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;

public class XPathQueryParser {
    private String queryString;
    private XPathQuery root;
    private XPathQuery target;
    private Stack<XPathQuery> tailStack;
    private int depth;
    private XPathComparison.Op compOp;
    private static final Pattern[] numberPatterns = new Pattern[]{Pattern.compile("([+-]?)(\\d+)?(\\.\\d+)?([Ee][+-]?(\\d+))?")};
    private int pos;
    private char currentChar;
    private char nextChar;
    private String nextString;
    private boolean endOfInput;
    private Token[] lexerTokenQueue = new Token[4];
    private LinguisticQueryParser.Options queryParserOptions;
    private static XPathQueryParserPool pool = new XPathQueryParserPool(5);
    private static String lexerChars = "/@.()[]<>=!-+'\"*";
    private static Token[] lexerTokens = new Token[]{Token.childToken, Token.attributeToken, Token.selfToken, Token.openParenToken, Token.closeParenToken, Token.openBracketToken, Token.closeBracketToken, Token.lessToken, Token.greaterToken, Token.equalToken, Token.notEqualToken, Token.minusToken, Token.plusToken, Token.singleQuoteToken, Token.doubleQuoteToken, Token.wildcardToken};
    private static char[][] lexerMC = new char[][]{{'a', 'n', 'd'}, {'o', 'r'}, {'c', 'o', 'n', 't', 'a', 'i', 'n', 's'}, {'e', 'x', 'c', 'l', 'u', 'd', 'e', 's'}};
    private static Token[] lexerMCTokens = new Token[]{Token.andToken, Token.orToken, Token.containsToken, Token.excludesToken};
    private static HashMap<String, String> queryCleanupTable = new HashMap();

    public static XPathQueryParser requestParser() {
        return (XPathQueryParser)pool.requestItem();
    }

    public static void releaseParser(XPathQueryParser xqp) {
        pool.releaseItem(xqp);
    }

    public Query parse(String clientQueryString) throws ParseException {
        return this.parse(clientQueryString, null);
    }

    public Query parse(String clientQueryString, LinguisticQueryParser.Options qpOptions) throws ParseException {
        Properties p;
        this.queryParserOptions = qpOptions;
        if (this.queryParserOptions != null && (p = this.queryParserOptions.getQueryProperties()) != null) {
            p.setProperty("staticScoring", "false");
        }
        try {
            XPathQuery xpq = this.parseToXPathQuery(clientQueryString);
            MarkupBooleanQuery mq = XPathToMarkup.convertToMarkup(xpq);
            return mq;
        }
        catch (Exception e) {
            ParseException pe = new ParseException("Conversion of XML Search query term \"" + clientQueryString + "\" failed.");
            pe.initCause((Throwable)e);
            throw pe;
        }
    }

    private XPathQuery parseToXPathQuery(String clientQueryString) throws ExtendedException {
        this.reset(this.cleanUpQueryString(clientQueryString));
        this.getNextToken();
        this.pathExpr();
        this.expect(Token.TokenType.End);
        if (this.target != null) {
            this.target.setTargetNode(true);
        }
        return this.root;
    }

    private String cleanUpQueryString(String clientQueryString) {
        String replacementQueryString = queryCleanupTable.get(clientQueryString);
        return replacementQueryString == null ? clientQueryString : replacementQueryString;
    }

    private void pathExpr() throws ExtendedException {
        if (!this.pathSep()) {
            this.depth = -1;
        }
        this.relativePathExpr();
    }

    private boolean pathSep() throws ExtendedException {
        if (this.accept(Token.TokenType.Child)) {
            this.depth = 1;
            return true;
        }
        if (this.accept(Token.TokenType.Descendant)) {
            this.depth = -1;
            return true;
        }
        return false;
    }

    private void relativePathExpr() throws ExtendedException {
        if (this.depth == 0 && this.pathSep() && this.depth != -1) {
            this.error();
        }
        if (this.stepExpr()) {
            if (this.pathSep()) {
                this.relativePathExpr();
            }
        } else if (this.depth == -1) {
            this.error();
        }
    }

    private boolean stepExpr() throws ExtendedException {
        String name = null;
        if (this.accept(Token.TokenType.Self)) {
            name = ".";
        } else {
            boolean isAttribute = this.accept(Token.TokenType.Attribute);
            if (this.accept(Token.TokenType.Wildcard)) {
                name = "*";
            } else {
                name = this.qName();
                if (name == null) {
                    return false;
                }
            }
            int d = this.depth == 0 ? 1 : this.depth;
            this.addToPath(new XPathQuery(name, d, isAttribute));
        }
        this.predicateList();
        return true;
    }

    private void predicateList() throws ExtendedException {
        while (this.accept(Token.TokenType.OpenBracket)) {
            this.checkNonWildcard(this.getTail());
            this.pushTail();
            this.predicateExpr();
            this.expect(Token.TokenType.CloseBracket);
            this.popTail();
        }
    }

    private void predicateExpr() throws ExtendedException {
        this.pushTail();
        if (this.accept(Token.TokenType.OpenParen)) {
            this.predicateExpr();
            this.expect(Token.TokenType.CloseParen);
        } else {
            this.expr();
        }
        XPathLogicalOp logicalNode = null;
        if (this.accept(Token.TokenType.Or)) {
            logicalNode = new XPathLogicalOp(XPathLogicalOp.Op.Or);
        } else if (this.accept(Token.TokenType.And)) {
            logicalNode = new XPathLogicalOp(XPathLogicalOp.Op.And);
        }
        if (logicalNode != null) {
            logicalNode.wrap(this.getTail().getLastChild());
            this.setTail(logicalNode);
            this.predicateExpr();
        }
        this.popTail();
    }

    private void expr() throws ExtendedException {
        this.pushTail();
        this.relativePathExpr();
        boolean isAttribute = this.getTail().getPathContext().isAttribute();
        if (this.accept(Token.TokenType.Contains)) {
            this.containsExcludesHelper(Token.TokenType.Contains, isAttribute);
        } else if (this.accept(Token.TokenType.Excludes)) {
            this.containsExcludesHelper(Token.TokenType.Excludes, isAttribute);
        } else if (this.eqCompOp()) {
            if (!isAttribute) {
                throw new ExtendedException(new Message("X0033E.XML"));
            }
            XPathLiteral literal = this.literal();
            if (literal.stringLiteral != null) {
                Query query = this.processFreeText(literal.stringLiteral, true);
                this.addToPath(new XPathComparison(this.compOp, query));
            } else {
                this.addToPath(new XPathComparison(this.compOp, literal));
            }
        } else if (this.lgCompOp()) {
            XPathLiteral literal = this.literal();
            if (!isAttribute || literal.stringLiteral != null) {
                throw new ExtendedException(new Message("X0033E.XML"));
            }
            this.addToPath(new XPathComparison(this.compOp, literal));
        }
        this.popTail();
    }

    private void checkNonWildcard(XPathQuery node) throws ExtendedException {
        if (node != null && node.getName() != null && node.getName().equals("*")) {
            throw new ExtendedException(new Message("X0052E.XML"));
        }
    }

    private void containsExcludesHelper(Token.TokenType which, boolean isAttribute) throws ExtendedException {
        this.expect(Token.TokenType.OpenParen);
        this.expect(Token.TokenType.StringLiteral);
        String theString = this.previousToken().stringValue;
        this.expect(Token.TokenType.CloseParen);
        if (this.queryParserOptions != null) {
            this.addToPath(new XPathContains(this.processFreeText(theString, isAttribute)));
        } else {
            this.addToPath(new XPathContains(theString));
        }
        if (which == Token.TokenType.Excludes) {
            new XPathLogicalOp(XPathLogicalOp.Op.Not).wrap(this.getTail());
        }
    }

    private boolean eqCompOp() throws ExtendedException {
        if (this.accept(Token.TokenType.Equal)) {
            this.compOp = XPathComparison.Op.Equal;
            return true;
        }
        if (this.accept(Token.TokenType.NotEqual)) {
            this.compOp = XPathComparison.Op.NotEqual;
            return true;
        }
        return false;
    }

    private boolean lgCompOp() throws ExtendedException {
        if (this.accept(Token.TokenType.Less)) {
            this.compOp = XPathComparison.Op.LessThan;
            return true;
        }
        if (this.accept(Token.TokenType.LessEqual)) {
            this.compOp = XPathComparison.Op.LessThanOrEqual;
            return true;
        }
        if (this.accept(Token.TokenType.Greater)) {
            this.compOp = XPathComparison.Op.GreaterThan;
            return true;
        }
        if (this.accept(Token.TokenType.GreaterEqual)) {
            this.compOp = XPathComparison.Op.GreaterThanOrEqual;
            return true;
        }
        return false;
    }

    private XPathLiteral literal() throws ExtendedException {
        if (this.accept(Token.TokenType.StringLiteral)) {
            return new XPathLiteral(this.previousToken().stringValue);
        }
        if (this.accept(Token.TokenType.IntegerLiteral)) {
            return new XPathLiteral(this.previousToken().longValue);
        }
        if (this.accept(Token.TokenType.RealLiteral)) {
            return new XPathLiteral(this.previousToken().doubleValue);
        }
        this.error();
        return null;
    }

    private String qName() throws ExtendedException {
        return this.accept(Token.TokenType.QName) ? this.previousToken().stringValue : null;
    }

    private void reset(String clientQueryString) {
        this.queryString = clientQueryString;
        this.tailStack = new Stack();
        this.target = null;
        this.root = null;
        this.depth = 0;
        this.compOp = null;
        this.pos = 0;
        this.nextString = null;
        this.lexerTokenQueue[3] = null;
        this.lexerTokenQueue[2] = null;
        this.lexerTokenQueue[1] = null;
        this.lexerTokenQueue[0] = null;
    }

    private XPathQuery addToPath(XPathQuery newChild) throws ExtendedException {
        if (this.getTail() == null) {
            this.setTail(newChild);
            if (this.root == null) {
                this.root = this.getTail();
                if (this.root.getDepth() == 1) {
                    this.root.setDepth(0);
                }
            }
        } else {
            XPathQuery currentPathContext;
            if (newChild.definesPathContext() && (currentPathContext = this.getTail().getPathContext()) != null && currentPathContext.isAttribute()) {
                throw new ExtendedException(new Message("X0053E.XML"));
            }
            this.getTail().addChild(newChild);
            this.setTail(newChild);
        }
        if (this.tailStack.size() == 1) {
            this.target = this.getTail();
        }
        return this.getTail();
    }

    private XPathQuery getTail() {
        return this.tailStack.isEmpty() ? null : this.tailStack.peek();
    }

    private void setTail(XPathQuery xpq) {
        if (!this.tailStack.isEmpty()) {
            this.tailStack.pop();
        }
        this.tailStack.push(xpq);
    }

    private XPathQuery popTail() {
        return this.tailStack.pop();
    }

    private void pushTail() throws ExtendedException {
        XPathQuery currentTail = this.getTail();
        if (currentTail == null) {
            this.error();
        }
        this.tailStack.push(currentTail);
        this.depth = 0;
    }

    private boolean accept(Token.TokenType tokenType) throws ExtendedException {
        if (this.currentToken().type == tokenType) {
            this.getNextToken();
            return true;
        }
        return false;
    }

    private boolean expect(Token.TokenType tokenType) throws ExtendedException {
        if (this.accept(tokenType)) {
            return true;
        }
        this.error(tokenType);
        return false;
    }

    private void error() throws ExtendedException {
        this.error(Token.TokenType.Null);
    }

    private void error(Token.TokenType expectedTT) throws ExtendedException {
        Message m = new Message(expectedTT == Token.TokenType.Null ? "X0034E.XML" : "X0035E.XML");
        m.addArgument(this.pos);
        if (expectedTT != Token.TokenType.Null) {
            m.addArgument((Object)expectedTT);
            m.addArgument((Object)this.currentToken().type);
        }
        throw new ExtendedException(m);
    }

    private void getNextToken() throws ExtendedException {
        Token.TokenType tt;
        if (this.pushedBackToken() != null) {
            this.acceptPushedBackToken();
            return;
        }
        this.skipWhitespace();
        if (this.endOfInput) {
            this.acceptToken(Token.endToken);
            return;
        }
        Token token = this.lexerToken(this.currentChar);
        Token.TokenType tokenType = tt = token == null ? Token.TokenType.Null : token.type;
        if (tt == Token.TokenType.Self) {
            Token numberToken = this.tryNumberPattern();
            if (numberToken != null) {
                this.acceptToken(numberToken);
                return;
            }
            this.acceptToken(token);
            return;
        }
        if (tt == Token.TokenType.Minus) {
            Token numberToken = this.tryNumberPattern();
            if (numberToken != null) {
                this.acceptToken(numberToken);
                return;
            }
            this.consumeQName();
            return;
        }
        if (tt == Token.TokenType.Plus) {
            Token numberToken = this.tryNumberPattern();
            if (numberToken != null) {
                this.acceptToken(numberToken);
                return;
            }
            this.consumeQName();
            return;
        }
        if (tt == Token.TokenType.Digit) {
            Token numberToken = this.tryNumberPattern();
            if (numberToken != null) {
                this.acceptToken(numberToken);
                return;
            }
            throw new ExtendedException(new Message("X0036E.XML"));
        }
        if (tt == Token.TokenType.Child) {
            if (this.more(1) && this.nextChar == '/') {
                this.acceptToken(Token.descendantToken);
                ++this.pos;
            } else {
                this.acceptToken(token);
            }
            return;
        }
        if (tt == Token.TokenType.Less || tt == Token.TokenType.Greater) {
            if (this.more(1) && this.nextChar == '=') {
                this.acceptToken(tt == Token.TokenType.Less ? Token.lessEqualToken : Token.greaterEqualToken);
                ++this.pos;
            } else {
                this.acceptToken(token);
            }
            return;
        }
        if (tt == Token.TokenType.NotEqual) {
            if (this.more(1) && this.nextChar == '=') {
                this.acceptToken(Token.notEqualToken);
                ++this.pos;
                return;
            }
            this.error();
        }
        if (tt == Token.TokenType.DoubleQuote || tt == Token.TokenType.SingleQuote) {
            char terminator = tt == Token.TokenType.DoubleQuote ? (char)'\"' : '\'';
            StringBuffer sb = new StringBuffer();
            while (this.more(0)) {
                if (this.currentChar != terminator) {
                    sb.append(this.currentChar);
                    continue;
                }
                if (this.more(1) && this.nextChar == terminator) {
                    sb.append(terminator);
                    ++this.pos;
                    continue;
                }
                this.acceptToken(new Token(sb));
                return;
            }
            this.error();
        }
        if (token != null) {
            this.acceptToken(token);
            return;
        }
        for (int whichMC = 0; whichMC < lexerMC.length; ++whichMC) {
            int p = this.pos - 1;
            char[] mc = lexerMC[whichMC];
            int eos = p + mc.length;
            if (eos > this.queryString.length()) continue;
            int k = 0;
            while (p < eos && this.queryString.charAt(p++) == mc[k++]) {
            }
            if (p != eos || !this.endsQName(eos)) continue;
            this.pos = eos;
            this.acceptToken(lexerMCTokens[whichMC]);
            return;
        }
        this.consumeQName();
    }

    private void consumeQName() {
        for (int k = this.pos; k <= this.queryString.length(); ++k) {
            if (k != this.queryString.length() && !this.endsQName(k)) continue;
            this.acceptToken(new Token(this.queryString.substring(this.pos - 1, k)));
            this.pos = k;
            return;
        }
    }

    private Token tryNumberPattern() {
        Matcher m = numberPatterns[0].matcher(this.queryString);
        m.region(this.pos - 1, this.queryString.length());
        if (!m.lookingAt()) {
            return null;
        }
        if (m.group(2) == null && m.group(3) == null) {
            return null;
        }
        boolean error = false;
        try {
            if (m.group(3) == null && m.group(4) == null && m.group(5) == null) {
                long l = Long.parseLong(m.group(2));
                if (m.group(1) != null && m.group(1).indexOf(45) >= 0) {
                    l = 0L - l;
                }
                Token token = new Token(l);
                return token;
            }
            double d = 0.0;
            if (m.group(2) != null) {
                d += Double.parseDouble(m.group(2));
            }
            if (m.group(3) != null) {
                d += Double.parseDouble(m.group(3));
            }
            if (m.group(1) != null && m.group(1).indexOf(45) >= 0) {
                d *= -1.0;
            }
            if (m.group(5) != null) {
                double dm = 1.0;
                int e = Integer.parseInt(m.group(5));
                for (int j = 0; j < e; ++j) {
                    dm *= 10.0;
                }
                if (m.group(4) != null && m.group(4).indexOf(45) >= 0) {
                    dm = 1.0 / dm;
                }
                d *= dm;
            }
            Token token = new Token(d);
            return token;
        }
        catch (NumberFormatException nfe) {
            error = true;
            throw nfe;
        }
        finally {
            if (!error) {
                this.pos = m.end();
            }
        }
    }

    private boolean more(int ncSelector) {
        boolean isMore;
        if (ncSelector < 0) {
            throw new IllegalArgumentException("Number of chars requested is " + ncSelector);
        }
        int ncNeeded = ncSelector;
        if (ncSelector == 0) {
            this.endOfInput = false;
            ncNeeded = 1;
        }
        boolean bl = isMore = this.pos + ncNeeded <= this.queryString.length();
        if (isMore) {
            if (ncSelector == 0) {
                this.currentChar = this.queryString.charAt(this.pos++);
            } else if (ncSelector == 1) {
                this.nextChar = this.queryString.charAt(this.pos);
            } else {
                this.nextString = this.queryString.substring(this.pos, this.pos + ncNeeded);
            }
        } else if (ncSelector == 0) {
            this.endOfInput = true;
        }
        return isMore;
    }

    private void skipWhitespace() {
        while (this.more(0)) {
            if (Character.isWhitespace(this.currentChar)) continue;
            return;
        }
    }

    private Token lexerToken(char c) {
        if (Character.isWhitespace(c)) {
            return Token.whiteToken;
        }
        if (Character.isDigit(c)) {
            return Token.digitToken;
        }
        int ix = lexerChars.indexOf(c);
        return ix < 0 ? null : lexerTokens[ix];
    }

    private boolean endsQName(int p) {
        Token t = this.lexerToken(this.queryString.charAt(p));
        return t == null ? false : t.endsQName;
    }

    private void acceptToken(Token t) {
        this.lexerTokenQueue[0] = this.lexerTokenQueue[1];
        this.lexerTokenQueue[1] = this.lexerTokenQueue[2];
        this.lexerTokenQueue[2] = t;
        this.lexerTokenQueue[3] = null;
    }

    private void pushBackToken() throws ExtendedException {
        if (this.lexerTokenQueue[3] != null) {
            this.error();
        }
        this.lexerTokenQueue[3] = this.lexerTokenQueue[2];
        this.lexerTokenQueue[2] = this.lexerTokenQueue[1];
        this.lexerTokenQueue[1] = this.lexerTokenQueue[0];
        this.lexerTokenQueue[0] = null;
    }

    private void acceptPushedBackToken() {
        this.lexerTokenQueue[0] = this.lexerTokenQueue[1];
        this.lexerTokenQueue[1] = this.lexerTokenQueue[2];
        this.lexerTokenQueue[2] = this.lexerTokenQueue[3];
        this.lexerTokenQueue[3] = null;
    }

    private Token currentToken() {
        return this.lexerTokenQueue[2];
    }

    private Token previousToken() {
        return this.lexerTokenQueue[1];
    }

    private Token pushedBackToken() {
        return this.lexerTokenQueue[3];
    }

    public static void main(String[] args) {
        try {
            XPathQueryParser p = new XPathQueryParser();
            FileReader fr = new FileReader(args[0]);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim()).length() != 0 && !line.startsWith("#")) {
                    PrintStream ps;
                    ByteArrayOutputStream baos;
                    StringBuffer sb = new StringBuffer("For input string:\n");
                    sb.append(line);
                    sb.append("\nParser returns:\n");
                    try {
                        XPathQuery xpq = p.parseToXPathQuery(line);
                        if (xpq != null) {
                            xpq.toPrettyString(sb, 1);
                        } else {
                            sb.append("NULL!\n");
                        }
                        MarkupBooleanQuery mbq = XPathToMarkup.convertToMarkup(xpq);
                        sb.append(" and conversion to markup yields:\n").append(mbq.toString());
                        sb.append("\n\n\n\n\n");
                    }
                    catch (NullPointerException npe) {
                        sb.append("  NPE:\n");
                        baos = new ByteArrayOutputStream();
                        ps = new PrintStream(baos);
                        npe.printStackTrace(ps);
                        ps.flush();
                        ps.close();
                        sb.append(baos.toString()).append("\n");
                    }
                    catch (RuntimeException re) {
                        sb.append("  RE:\n");
                        baos = new ByteArrayOutputStream();
                        ps = new PrintStream(baos);
                        re.printStackTrace(ps);
                        ps.flush();
                        ps.close();
                        sb.append(baos.toString()).append("\n");
                    }
                    catch (ExtendedException xppe) {
                        sb.append("  Parse Exception:\n");
                        sb.append(xppe.getFormattedText()).append("\n");
                        baos = new ByteArrayOutputStream();
                        ps = new PrintStream(baos);
                        xppe.printStackTrace(ps);
                        ps.flush();
                        ps.close();
                        sb.append(baos.toString()).append("\n");
                    }
                    System.out.println(sb.toString());
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Query processFreeText(String freeText, boolean isAttribute) throws ExtendedException {
        try {
            LinguisticQueryParser queryParser = new LinguisticQueryParser(this.queryParserOptions.getTokenizerPool(), this.queryParserOptions.getSynonymIndexSearcher(), this.queryParserOptions.getCollectionConfig(), null, isAttribute ? "_xmlvals" : "_plain");
            ParsedQuery parsedQuery = queryParser.parseAndExtract(freeText, this.queryParserOptions.getQueryLanguage(), this.queryParserOptions.getQueryProperties());
            return parsedQuery.getQuery();
        }
        catch (ParseException e) {
            throw new ExtendedException(new Message("X0037E.XML"), (Throwable)e);
        }
    }

    static {
        queryCleanupTable.put("/", "/*");
        queryCleanupTable.put("//", "//*");
        queryCleanupTable.put("/@", "/@*");
        queryCleanupTable.put("//@", "//@*");
    }

    private static class Token {
        public TokenType type;
        public String stringValue;
        public long longValue;
        public double doubleValue;
        public boolean endsQName = true;
        public static Token attributeToken = new Token(TokenType.Attribute);
        public static Token childToken = new Token(TokenType.Child);
        public static Token descendantToken = new Token(TokenType.Descendant);
        public static Token openParenToken = new Token(TokenType.OpenParen);
        public static Token closeParenToken = new Token(TokenType.CloseParen);
        public static Token openBracketToken = new Token(TokenType.OpenBracket);
        public static Token closeBracketToken = new Token(TokenType.CloseBracket);
        public static Token equalToken = new Token(TokenType.Equal);
        public static Token notEqualToken = new Token(TokenType.NotEqual);
        public static Token lessToken = new Token(TokenType.Less);
        public static Token lessEqualToken = new Token(TokenType.LessEqual);
        public static Token greaterToken = new Token(TokenType.Greater);
        public static Token greaterEqualToken = new Token(TokenType.GreaterEqual);
        public static Token minusToken = new Token(TokenType.Minus, false);
        public static Token plusToken = new Token(TokenType.Plus, false);
        public static Token singleQuoteToken = new Token(TokenType.SingleQuote);
        public static Token doubleQuoteToken = new Token(TokenType.DoubleQuote);
        public static Token wildcardToken = new Token(TokenType.Wildcard);
        public static Token selfToken = new Token(TokenType.Self);
        public static Token andToken = new Token(TokenType.And);
        public static Token orToken = new Token(TokenType.Or);
        public static Token containsToken = new Token(TokenType.Contains);
        public static Token excludesToken = new Token(TokenType.Excludes);
        public static Token whiteToken = new Token(TokenType.White);
        public static Token digitToken = new Token(TokenType.Digit, false);
        public static Token integerToken = new Token(TokenType.IntegerLiteral);
        public static Token realToken = new Token(TokenType.RealLiteral);
        public static Token endToken = new Token(TokenType.End);
        public static Token errorToken = new Token(TokenType.Error);

        public String toString() {
            return "Token(" + (Object)((Object)this.type) + ")";
        }

        private Token(TokenType tokenType) {
            this(tokenType, true);
        }

        private Token(TokenType tokenType, boolean endsQName) {
            this.type = tokenType;
            this.endsQName = endsQName;
        }

        public Token(StringBuffer sb) {
            this.type = TokenType.StringLiteral;
            this.stringValue = sb == null ? null : sb.toString();
        }

        public Token(String s) {
            this.type = TokenType.QName;
            this.stringValue = s;
        }

        public Token(long longValue) {
            this.type = TokenType.IntegerLiteral;
            this.longValue = longValue;
        }

        public Token(double doubleValue) {
            this.type = TokenType.RealLiteral;
            this.doubleValue = doubleValue;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TokenType {
            Attribute,
            Child,
            Descendant,
            OpenParen,
            CloseParen,
            OpenBracket,
            CloseBracket,
            Equal,
            NotEqual,
            Less,
            LessEqual,
            Greater,
            GreaterEqual,
            Minus,
            Plus,
            SingleQuote,
            DoubleQuote,
            Self,
            Wildcard,
            QName,
            StringLiteral,
            And,
            Or,
            Contains,
            Excludes,
            White,
            Digit,
            IntegerLiteral,
            RealLiteral,
            Null,
            End,
            Error;

        }
    }
}

