/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query.xpath;

import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathQuery {
    protected XPathQuery parent;
    protected LinkedList<XPathQuery> children;
    protected int depth;
    protected String name;
    protected boolean attribute;
    protected boolean targetNode;
    private static final long serialVersionUID = 1L;

    XPathQuery() {
    }

    XPathQuery(String name, int depth) {
        this(name, depth, false);
    }

    XPathQuery(String name, int depth, boolean isAttribute) {
        this.name = this.removeNamespacePrefix(name);
        this.depth = depth;
        this.attribute = isAttribute;
    }

    public synchronized XPathQuery addChild(XPathQuery child) {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(child);
        child.parent = this;
        return child;
    }

    public boolean definesPathContext() {
        return true;
    }

    public LinkedList<XPathQuery> getChildren() {
        return this.children;
    }

    public int getDepth() {
        return this.depth;
    }

    public XPathQuery getLastChild() {
        return this.children == null ? null : this.children.getLast();
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public XPathQuery getParent() {
        return this.parent;
    }

    public XPathQuery getPathContext() {
        for (XPathQuery xpq = this; xpq != null; xpq = xpq.getParent()) {
            if (!xpq.definesPathContext()) continue;
            return xpq;
        }
        return null;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public boolean isTag() {
        return false;
    }

    public boolean isTarget() {
        return this.targetNode;
    }

    private String removeNamespacePrefix(String originalName) {
        int lastColonIndex;
        String unprefixedName = originalName;
        if (unprefixedName != null && (lastColonIndex = unprefixedName.lastIndexOf(58)) >= 0) {
            unprefixedName = unprefixedName.substring(lastColonIndex + 1);
        }
        return unprefixedName;
    }

    public void setTargetNode(boolean yesno) {
        this.targetNode = yesno;
    }

    public void removeChild(XPathQuery child) {
        if (this.children != null) {
            this.children.remove(child);
            child.parent = null;
        }
    }

    public void reparentChild(XPathQuery child) {
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        this.addChild(child);
    }

    public void setAttribute(boolean yesno) {
        this.attribute = yesno;
    }

    public void setDepth(int newDepth) {
        this.depth = newDepth;
    }

    public void setParent(XPathQuery parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.depth == 1) {
            sb.append("/");
        } else if (this.depth == -1) {
            sb.append("//");
        }
        if (this.attribute) {
            sb.append("@");
        }
        sb.append(this.name);
        if (this.targetNode) {
            sb.append("(T)");
        }
        return sb.toString();
    }

    public void toPrettyString(StringBuffer sb, int indent) {
        Iterator it;
        for (int j = 0; j < indent; ++j) {
            sb.append("    ");
        }
        sb.append(this.toString());
        sb.append("\n");
        Iterator iterator = it = this.children == null ? null : this.children.iterator();
        while (it != null && it.hasNext()) {
            ((XPathQuery)it.next()).toPrettyString(sb, indent + 1);
        }
    }

    public void wrap(XPathQuery node) {
        XPathQuery p = node.getParent();
        if (p != null) {
            p.removeChild(node);
        }
        this.addChild(node);
        p.addChild(this);
    }
}

