/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query.xpath;

import com.ibm.es.nuvo.search.query.xpath.XPathLiteral;
import com.ibm.es.nuvo.search.query.xpath.XPathQuery;
import org.apache.lucene.search.Query;

public class XPathComparison
extends XPathQuery {
    protected Op operator;
    protected XPathLiteral value;
    protected Query query;
    private static final long serialVersionUID = 1L;

    XPathComparison(Op operator, XPathLiteral value) {
        super("Comparison", 0);
        this.operator = operator;
        this.value = value;
    }

    XPathComparison(Op operator, Query query) {
        super("Comparison", 0);
        this.operator = operator;
        this.query = query;
    }

    XPathComparison(String name, int depth, boolean isAttribute, Op operator, XPathLiteral value) {
        super(name, depth, isAttribute);
        this.operator = operator;
        this.value = value;
    }

    public boolean definesPathContext() {
        return false;
    }

    public Op getOperator() {
        return this.operator;
    }

    public Query getQuery() {
        return this.query;
    }

    public XPathLiteral getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        switch (this.operator) {
            case Equal: {
                sb.append(" = ");
                break;
            }
            case NotEqual: {
                sb.append(" != ");
                break;
            }
            case LessThan: {
                sb.append(" < ");
                break;
            }
            case GreaterThan: {
                sb.append(" > ");
                break;
            }
            case LessThanOrEqual: {
                sb.append(" <= ");
                break;
            }
            case GreaterThanOrEqual: {
                sb.append(" >= ");
            }
        }
        if (this.value != null) {
            sb.append(this.value);
        } else {
            sb.append(this.query);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Op {
        Equal,
        NotEqual,
        LessThan,
        GreaterThan,
        LessThanOrEqual,
        GreaterThanOrEqual;

    }
}

