/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query.parser;

import com.ibm.es.nuvo.search.query.ExtendedBooleanClause;
import com.ibm.es.nuvo.search.query.NegatedQuery;
import com.ibm.es.nuvo.search.query.parser.QueryParserConstants;
import com.ibm.es.nuvo.search.query.parser.QueryParserTokenManager;
import com.ibm.es.nuvo.search.query.parser.TokenMgrError;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.FastCharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.Token;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Parameter;

public abstract class QueryParser
implements QueryParserConstants {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int CONJ_NONE = 0;
    private static final int CONJ_AND = 1;
    private static final int CONJ_OR = 2;
    private static final int MOD_NONE = 0;
    private static final int MOD_NOT = 10;
    private static final int MOD_REQ = 11;
    private static final int MOD_OPT = 12;
    public static final Operator AND_OPERATOR = Operator.AND;
    public static final Operator OR_OPERATOR = Operator.OR;
    private Operator operator = OR_OPERATOR;
    boolean lowercaseExpandedTerms = false;
    boolean useOldRangeQuery = false;
    boolean allowLeadingWildcard = true;
    Analyzer analyzer;
    String field;
    int phraseSlop = 0;
    float fuzzyMinSim = 0.5f;
    int fuzzyPrefixLength = 0;
    Locale locale = Locale.getDefault();
    DateTools.Resolution dateResolution = null;
    Map fieldToDateResolution = null;
    public QueryParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[29];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public QueryParser(String f, Analyzer a) {
        this((CharStream)new FastCharStream((Reader)new StringReader("")));
        this.analyzer = a;
        this.field = f;
    }

    public Query parse(String query) throws ParseException {
        this.ReInit((CharStream)new FastCharStream((Reader)new StringReader(query)));
        try {
            return this.TopLevelQuery(this.field);
        }
        catch (ParseException tme) {
            ParseException e = new ParseException("Cannot parse '" + query + "': " + tme.getMessage());
            e.initCause((Throwable)tme);
            throw e;
        }
        catch (TokenMgrError tme) {
            ParseException e = new ParseException("Cannot parse '" + query + "': " + tme.getMessage());
            e.initCause((Throwable)tme);
            throw e;
        }
        catch (BooleanQuery.TooManyClauses tmc) {
            throw new ParseException("Cannot parse '" + query + "': too many boolean clauses");
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public String getField() {
        return this.field;
    }

    public float getFuzzyMinSim() {
        return this.fuzzyMinSim;
    }

    public void setFuzzyMinSim(float fuzzyMinSim) {
        this.fuzzyMinSim = fuzzyMinSim;
    }

    public int getFuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public int getPhraseSlop() {
        return this.phraseSlop;
    }

    public void setAllowLeadingWildcard(boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    public boolean getAllowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public void setDefaultOperator(Operator op) {
        this.operator = op;
    }

    public Operator getDefaultOperator() {
        return this.operator;
    }

    public void setLowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.lowercaseExpandedTerms = lowercaseExpandedTerms;
    }

    public boolean getLowercaseExpandedTerms() {
        return this.lowercaseExpandedTerms;
    }

    public void setUseOldRangeQuery(boolean useOldRangeQuery) {
        this.useOldRangeQuery = useOldRangeQuery;
    }

    public boolean getUseOldRangeQuery() {
        return this.useOldRangeQuery;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setDateResolution(DateTools.Resolution dateResolution) {
        this.dateResolution = dateResolution;
    }

    public void setDateResolution(String fieldName, DateTools.Resolution dateResolution) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field cannot be null.");
        }
        if (this.fieldToDateResolution == null) {
            this.fieldToDateResolution = new HashMap();
        }
        this.fieldToDateResolution.put(fieldName, dateResolution);
    }

    public DateTools.Resolution getDateResolution(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field cannot be null.");
        }
        if (this.fieldToDateResolution == null) {
            return this.dateResolution;
        }
        DateTools.Resolution resolution = (DateTools.Resolution)this.fieldToDateResolution.get(fieldName);
        if (resolution == null) {
            resolution = this.dateResolution;
        }
        return resolution;
    }

    protected void addClause(Vector clauses, int conj, int mods, Query q) {
        boolean required;
        boolean prohibited;
        ExtendedBooleanClause c;
        boolean hasExplicitModifier;
        boolean bl = hasExplicitModifier = conj != 0 || mods != 0;
        if (clauses.size() > 0 && conj == 1 && !(c = (ExtendedBooleanClause)((Object)clauses.elementAt(clauses.size() - 1))).hasExplicitModifier()) {
            c.setOccur(BooleanClause.Occur.MUST);
            c.setExplicitModifier(true);
        }
        if (clauses.size() > 0 && conj == 2) {
            c = (ExtendedBooleanClause)((Object)clauses.elementAt(clauses.size() - 1));
            c.setExplicitModifier(true);
            if (c.isProhibited()) {
                c.setQuery(new NegatedQuery(c.getQuery()));
            }
            c.setOccur(BooleanClause.Occur.SHOULD);
        }
        if (q == null) {
            return;
        }
        if (this.operator == OR_OPERATOR) {
            prohibited = mods == 10;
            boolean bl2 = required = mods == 11;
            if (conj == 1 && !prohibited) {
                required = true;
            }
        } else {
            prohibited = mods == 10;
            boolean bl3 = required = !prohibited && conj != 2 && mods != 12;
        }
        if (required && !prohibited) {
            clauses.addElement(new ExtendedBooleanClause(q, BooleanClause.Occur.MUST, hasExplicitModifier));
        } else if (!required && !prohibited) {
            clauses.addElement(new ExtendedBooleanClause(q, BooleanClause.Occur.SHOULD, hasExplicitModifier));
        } else if (!required && prohibited) {
            if (conj == 2) {
                clauses.addElement(new ExtendedBooleanClause(new NegatedQuery(q), BooleanClause.Occur.SHOULD, hasExplicitModifier));
            } else {
                clauses.addElement(new ExtendedBooleanClause(q, BooleanClause.Occur.MUST_NOT, hasExplicitModifier));
            }
        } else {
            throw new RuntimeException("Clause cannot be both required and prohibited");
        }
    }

    protected abstract Query getFieldQuery(String var1, String var2, int var3, int var4, boolean var5) throws ParseException;

    protected abstract Query getFieldQuery(String var1, String var2, int var3, int var4, int var5, boolean var6) throws ParseException;

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            part1 = part1.toLowerCase();
            part2 = part2.toLowerCase();
        }
        try {
            DateTools.Resolution resolution;
            DateFormat df = DateFormat.getDateInstance(3, this.locale);
            df.setLenient(true);
            Date d1 = df.parse(part1);
            Date d2 = df.parse(part2);
            if (inclusive) {
                Calendar cal = Calendar.getInstance(this.locale);
                cal.setTime(d2);
                cal.set(11, 23);
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(14, 999);
                d2 = cal.getTime();
            }
            if ((resolution = this.getDateResolution(field)) == null) {
                part1 = DateField.dateToString((Date)d1);
                part2 = DateField.dateToString((Date)d2);
            } else {
                part1 = DateTools.dateToString((Date)d1, (DateTools.Resolution)resolution);
                part2 = DateTools.dateToString((Date)d2, (DateTools.Resolution)resolution);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.useOldRangeQuery) {
            return new RangeQuery(new Term(field, part1), new Term(field, part2), inclusive);
        }
        return new ConstantScoreRangeQuery(field, part1, part2, inclusive, inclusive);
    }

    protected Query getBooleanQuery(Vector clauses) throws ParseException {
        return this.getBooleanQuery(clauses, false);
    }

    protected Query getBooleanQuery(Vector clauses, boolean disableCoord) throws ParseException {
        BooleanQuery query = new BooleanQuery(disableCoord);
        for (int i = 0; i < clauses.size(); ++i) {
            query.add((BooleanClause)clauses.elementAt(i));
        }
        return query;
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if ("*".equals(field) && "*".equals(termStr)) {
            return new MatchAllDocsQuery();
        }
        if (!this.allowLeadingWildcard && (termStr.startsWith("*") || termStr.startsWith("?"))) {
            throw new ParseException("'*' or '?' not allowed as first character in WildcardQuery");
        }
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new WildcardQuery(t);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (!this.allowLeadingWildcard && termStr.startsWith("*")) {
            throw new ParseException("'*' not allowed as first character in PrefixQuery");
        }
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new PrefixQuery(t);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (this.lowercaseExpandedTerms) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new FuzzyQuery(t, minSimilarity, this.fuzzyPrefixLength);
    }

    protected Query getOpaqueQuery(String schema, String value) throws ParseException {
        throw new ParseException("Opaque queries of schema \"" + schema + "\" are not supported.");
    }

    protected Query getParametricQuery(String field, CompareOperator comp, String value) throws ParseException {
        throw new ParseException("Parametric queries are not supported.");
    }

    private String discardEscapeChar(String input) throws ParseException {
        char[] output = new char[input.length()];
        int length = 0;
        boolean lastCharWasEscapeChar = false;
        int codePointMultiplier = 0;
        int codePoint = 0;
        for (int i = 0; i < input.length(); ++i) {
            char curChar = input.charAt(i);
            if (codePointMultiplier > 0) {
                codePoint += QueryParser.hexToInt(curChar) * codePointMultiplier;
                if ((codePointMultiplier >>>= 4) != 0) continue;
                output[length++] = (char)codePoint;
                codePoint = 0;
                continue;
            }
            if (lastCharWasEscapeChar) {
                if (curChar == 'u') {
                    codePointMultiplier = 4096;
                } else {
                    output[length] = curChar;
                    ++length;
                }
                lastCharWasEscapeChar = false;
                continue;
            }
            if (curChar == '\\') {
                lastCharWasEscapeChar = true;
                continue;
            }
            output[length] = curChar;
            ++length;
        }
        if (codePointMultiplier > 0) {
            throw new ParseException("Truncated unicode escape sequence.");
        }
        if (lastCharWasEscapeChar) {
            throw new ParseException("Term can not end with escape character.");
        }
        return new String(output, 0, length);
    }

    private static final int hexToInt(char c) throws ParseException {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new ParseException("None-hex character in unicode escape sequence: " + c);
    }

    public static String escape(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '@') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public final int Modifiers() throws ParseException {
        int ret = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.jj_consume_token(10);
                        ret = 11;
                        break block0;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        ret = 10;
                        break block0;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        ret = 10;
                        break block0;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        ret = 12;
                        break block0;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return ret;
    }

    public final CompareOperator Comparator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                return CompareOperator.LE;
            }
            case 13: {
                this.jj_consume_token(13);
                return CompareOperator.LT;
            }
            case 16: {
                this.jj_consume_token(16);
                return CompareOperator.GE;
            }
            case 15: {
                this.jj_consume_token(15);
                return CompareOperator.GT;
            }
            case 17: {
                this.jj_consume_token(17);
                return CompareOperator.EQ;
            }
            case 18: {
                this.jj_consume_token(18);
                return CompareOperator.NE;
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Query TopLevelQuery(String field) throws ParseException {
        Query q = this.Query(field);
        this.jj_consume_token(0);
        return q;
    }

    public final Query Query(String field) throws ParseException {
        Vector clauses = new Vector();
        Query firstQuery = null;
        Clause c = this.DisjQuery(field);
        this.addClause(clauses, 0, c.modifier, c.query);
        if (c.modifier == 0) {
            firstQuery = c.query;
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 20: 
                case 22: 
                case 23: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            c = this.DisjQuery(field);
            this.addClause(clauses, 0, c.modifier, c.query);
        }
        if (clauses.size() == 1 && firstQuery != null) {
            return firstQuery;
        }
        return this.getBooleanQuery(clauses);
    }

    public final Clause DisjQuery(String field) throws ParseException {
        Vector clauses = null;
        Clause first = this.ConjQuery(field);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(8);
            Clause c = this.ConjQuery(field);
            if (clauses == null) {
                clauses = new Vector();
                this.addClause(clauses, 2, first.modifier, first.query);
            }
            this.addClause(clauses, 2, c.modifier, c.query);
        }
        if (clauses != null) {
            Query q = this.getBooleanQuery(clauses);
            return new Clause(q, 0);
        }
        return first;
    }

    public final Clause ConjQuery(String field) throws ParseException {
        Vector clauses = null;
        Clause first = this.Clause(field);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            Clause c = this.Clause(field);
            if (clauses == null) {
                clauses = new Vector();
                this.addClause(clauses, 1, first.modifier, first.query);
            }
            this.addClause(clauses, 1, c.modifier, c.query);
        }
        if (clauses != null) {
            Query q = this.getBooleanQuery(clauses);
            return new Clause(q, 0);
        }
        return first;
    }

    public final String Value() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                Token term = this.jj_consume_token(26);
                return this.discardEscapeChar(term.image);
            }
            case 25: {
                Token term = this.jj_consume_token(25);
                return this.discardEscapeChar(term.image.substring(1, term.image.length() - 1));
            }
        }
        this.jj_la1[6] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Clause Clause(String field) throws ParseException {
        Query q;
        Token fieldToken = null;
        Token boost = null;
        boolean attached = false;
        int mods = this.Modifiers();
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                q = this.OpaqueQuery();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                if (this.jj_2_2(2)) {
                    fieldToken = this.jj_consume_token(26);
                    CompareOperator comp = this.Comparator();
                    String value = this.Value();
                    field = this.discardEscapeChar(fieldToken.image);
                    q = this.getParametricQuery(field, comp, value);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: 
                    case 23: 
                    case 25: 
                    case 26: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 35: {
                        if (this.jj_2_1(2)) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 26: {
                                    fieldToken = this.jj_consume_token(26);
                                    this.jj_consume_token(32);
                                    field = this.discardEscapeChar(fieldToken.image);
                                    attached = true;
                                    break;
                                }
                                case 23: {
                                    this.jj_consume_token(23);
                                    this.jj_consume_token(32);
                                    field = "*";
                                    break;
                                }
                                default: {
                                    this.jj_la1[7] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 23: 
                            case 25: 
                            case 26: 
                            case 28: 
                            case 29: 
                            case 30: 
                            case 31: 
                            case 35: {
                                q = this.Term(field, attached);
                                break block1;
                            }
                            case 20: {
                                this.jj_consume_token(20);
                                q = this.Query(field);
                                this.jj_consume_token(21);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 24: {
                                        this.jj_consume_token(24);
                                        boost = this.jj_consume_token(35);
                                        break block1;
                                    }
                                }
                                this.jj_la1[8] = this.jj_gen;
                                break block1;
                            }
                        }
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (boost != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(boost.image).floatValue();
                q.setBoost(f);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return new Clause(q, mods);
    }

    public final Query OpaqueQuery() throws ParseException {
        Token schemaToken = this.jj_consume_token(33);
        this.jj_consume_token(32);
        Token valueToken = this.jj_consume_token(34);
        String schema = this.discardEscapeChar(schemaToken.image);
        String value = this.discardEscapeChar(valueToken.image.substring(1, valueToken.image.length() - 1));
        return this.getOpaqueQuery(schema, value);
    }

    public final Query Term(String field, boolean attached) throws ParseException {
        Query q;
        Token boost = null;
        Token fuzzySlop = null;
        boolean prefix = false;
        boolean wildcard = false;
        boolean fuzzy = false;
        boolean rangein = false;
        boolean bang = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 35: {
                Token term;
                block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        term = this.jj_consume_token(26);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 19: {
                                this.jj_consume_token(19);
                                bang = true;
                                break block9;
                            }
                        }
                        this.jj_la1[12] = this.jj_gen;
                        break;
                    }
                    case 23: {
                        term = this.jj_consume_token(23);
                        wildcard = true;
                        break;
                    }
                    case 28: {
                        term = this.jj_consume_token(28);
                        prefix = true;
                        break;
                    }
                    case 29: {
                        term = this.jj_consume_token(29);
                        wildcard = true;
                        break;
                    }
                    case 35: {
                        term = this.jj_consume_token(35);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 19: {
                                this.jj_consume_token(19);
                                bang = true;
                                break block9;
                            }
                        }
                        this.jj_la1[13] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        fuzzySlop = this.jj_consume_token(27);
                        fuzzy = true;
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                    }
                }
                block25 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        boost = this.jj_consume_token(35);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 27: {
                                fuzzySlop = this.jj_consume_token(27);
                                fuzzy = true;
                                break block25;
                            }
                        }
                        this.jj_la1[16] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                    }
                }
                String termImage = this.discardEscapeChar(term.image);
                if (bang) {
                    termImage = termImage + "!";
                }
                if (wildcard) {
                    q = this.getWildcardQuery(field, termImage);
                    break;
                }
                if (prefix) {
                    q = this.getPrefixQuery(field, this.discardEscapeChar(term.image.substring(0, term.image.length() - 1)));
                    break;
                }
                if (fuzzy) {
                    float fms = this.fuzzyMinSim;
                    try {
                        fms = Float.valueOf(fuzzySlop.image.substring(1)).floatValue();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    if (fms < 0.0f || fms > 1.0f) {
                        throw new ParseException("Minimum similarity for a FuzzyQuery has to be between 0.0f and 1.0f !");
                    }
                    q = this.getFuzzyQuery(field, termImage, fms);
                    break;
                }
                q = this.getFieldQuery(field, termImage, term.beginColumn, term.endColumn, attached);
                break;
            }
            case 30: {
                Token goop2;
                Token goop1;
                this.jj_consume_token(30);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 39: {
                        goop1 = this.jj_consume_token(39);
                        break;
                    }
                    case 38: {
                        goop1 = this.jj_consume_token(38);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: {
                        this.jj_consume_token(36);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 39: {
                        goop2 = this.jj_consume_token(39);
                        break;
                    }
                    case 38: {
                        goop2 = this.jj_consume_token(38);
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(37);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        boost = this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                    }
                }
                if (goop1.kind == 38) {
                    goop1.image = goop1.image.substring(1, goop1.image.length() - 1);
                }
                if (goop2.kind == 38) {
                    goop2.image = goop2.image.substring(1, goop2.image.length() - 1);
                }
                q = this.getRangeQuery(field, this.discardEscapeChar(goop1.image), this.discardEscapeChar(goop2.image), true);
                break;
            }
            case 31: {
                Token goop2;
                Token goop1;
                this.jj_consume_token(31);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 43: {
                        goop1 = this.jj_consume_token(43);
                        break;
                    }
                    case 42: {
                        goop1 = this.jj_consume_token(42);
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 40: {
                        this.jj_consume_token(40);
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 43: {
                        goop2 = this.jj_consume_token(43);
                        break;
                    }
                    case 42: {
                        goop2 = this.jj_consume_token(42);
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(41);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        boost = this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                    }
                }
                if (goop1.kind == 42) {
                    goop1.image = goop1.image.substring(1, goop1.image.length() - 1);
                }
                if (goop2.kind == 42) {
                    goop2.image = goop2.image.substring(1, goop2.image.length() - 1);
                }
                q = this.getRangeQuery(field, this.discardEscapeChar(goop1.image), this.discardEscapeChar(goop2.image), false);
                break;
            }
            case 25: {
                Token term = this.jj_consume_token(25);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        fuzzySlop = this.jj_consume_token(27);
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        boost = this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[27] = this.jj_gen;
                    }
                }
                int s = this.phraseSlop;
                if (fuzzySlop != null) {
                    try {
                        s = Float.valueOf(fuzzySlop.image.substring(1)).intValue();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                q = this.getFieldQuery(field, this.discardEscapeChar(term.image.substring(1, term.image.length() - 1)), s, term.beginColumn + 1, term.endColumn - 1, attached);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (boost != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(boost.image).floatValue();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (q != null) {
                q.setBoost(f);
            }
        }
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private final boolean jj_3R_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_8()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_9()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_10()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_11()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_12()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_7() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_3R_6();
    }

    private final boolean jj_3R_5() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(32);
    }

    private final boolean jj_3R_4() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_scan_token(32);
    }

    private final boolean jj_3R_12() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_5()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_11() {
        return this.jj_scan_token(17);
    }

    private final boolean jj_3R_10() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_9() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3R_8() {
        return this.jj_scan_token(13);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{7680, 7680, 516096, -154132992, 256, 128, 0x6000000, 0x4800000, 0x1000000, -158334976, 0x400000, -158334976, 524288, 524288, 880803840, 0x8000000, 0x8000000, 0x1000000, 0, 0, 0, 0x1000000, 0, 0, 0, 0x1000000, 0x8000000, 0x1000000, -159383552};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 8, 0, 0, 0, 0, 0, 8, 0, 8, 0, 0, 8, 0, 0, 0, 192, 16, 192, 0, 3072, 256, 3072, 0, 0, 0, 8};
    }

    public QueryParser(CharStream stream) {
        int i;
        this.token_source = new QueryParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public QueryParser(QueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(QueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[44];
        for (i = 0; i < 44; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 29; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 44; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, (int[][])exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        QueryParser.jj_la1_0();
        QueryParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static class Clause {
        Query query;
        int modifier;

        Clause(Query q, int mod) {
            this.query = q;
            this.modifier = mod;
        }
    }

    public static final class Operator
    extends Parameter {
        public static final Operator OR = new Operator("OR");
        public static final Operator AND = new Operator("AND");

        private Operator(String name) {
            super(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum CompareOperator {
        LE,
        LT,
        GE,
        GT,
        EQ,
        NE;


        public String toString() {
            if (LE.equals((Object)this)) {
                return "<=";
            }
            if (LT.equals((Object)this)) {
                return "<";
            }
            if (GE.equals((Object)this)) {
                return ">=";
            }
            if (GT.equals((Object)this)) {
                return ">";
            }
            if (EQ.equals((Object)this)) {
                return "=";
            }
            if (NE.equals((Object)this)) {
                return "!=";
            }
            throw new IllegalArgumentException("Unknown operator");
        }
    }
}

