/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.search.query.MatchNoDocsQuery;
import com.ibm.es.nuvo.search.query.NoLemmaTermEnum;
import com.ibm.es.nuvo.search.query.NoLemmaWildcardQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardTermEnum;
import org.apache.lucene.util.ToStringUtils;

public class WildcardPhraseQuery
extends Query {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 1L;
    private MultiPhraseQuery phrase = new MultiPhraseQuery();
    private ArrayList<Entry> entries;
    int addedToPhrase = 0;
    int currentPos = 0;
    static Term[] dummyTerms = new Term[0];

    public void add(Term term) {
        this.add(new Term[]{term});
    }

    public void setSlop(int s) {
        this.phrase.setSlop(s);
    }

    public boolean isEmpty() {
        return this.addedToPhrase == 0 && this.entries == null;
    }

    public void add(Term[] terms) {
        this.add(terms, this.currentPos);
    }

    public void add(Term[] terms, int pos) {
        if (this.entries == null) {
            this.phrase.add(terms, pos);
            ++this.addedToPhrase;
        } else {
            this.entries.add(new Entry(terms, pos, false));
        }
        ++this.currentPos;
    }

    public void addWildcard(Term term) {
        if (WildcardPhraseQuery.isPureWildcard(term)) {
            ++this.currentPos;
            return;
        }
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        this.entries.add(new Entry(new Term[]{term}, this.currentPos, true));
        ++this.currentPos;
    }

    public static boolean isPureWildcard(Term term) {
        return WildcardPhraseQuery.isPureWildcard(term.text());
    }

    public static boolean isPureWildcard(String text) {
        boolean hasStar = false;
        boolean hasMark = false;
        block4: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '*': {
                    hasStar = true;
                    continue block4;
                }
                case '?': {
                    if (hasMark) {
                        return false;
                    }
                    hasMark = true;
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return hasStar;
    }

    public Query rewrite() {
        if (this.entries == null) {
            return this.phrase;
        }
        if (this.addedToPhrase == 0 && this.entries.size() == 1) {
            return new NoLemmaWildcardQuery(this.entries.get((int)0).terms[0]);
        }
        return this;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.entries != null) {
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry = this.entries.get(i);
                Term[] terms = entry.terms;
                if (entry.wild && (terms = this.expandWildcard(reader, terms[0])).length == 0) {
                    return new MatchNoDocsQuery();
                }
                if (entry.pos == -1) {
                    this.phrase.add(terms);
                    continue;
                }
                this.phrase.add(terms, entry.pos);
            }
        }
        this.entries = null;
        return this.phrase.rewrite(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Term[] expandWildcard(IndexReader reader, Term term) throws IOException {
        ArrayList<Term> expansions = new ArrayList<Term>();
        NoLemmaTermEnum enumerator = new NoLemmaTermEnum((FilteredTermEnum)new WildcardTermEnum(reader, term));
        try {
            do {
                Term t;
                if ((t = enumerator.term()) == null) continue;
                expansions.add(t);
            } while (enumerator.next());
        }
        finally {
            enumerator.close();
        }
        return expansions.toArray(dummyTerms);
    }

    public final String toString(String f) {
        if (this.entries == null) {
            return this.phrase.toString(f);
        }
        StringBuffer buffer = new StringBuffer();
        String field = this.entries.get((int)0).terms[0].field();
        if (!field.equals(f)) {
            buffer.append(field);
            buffer.append(":");
        }
        if (this.addedToPhrase > 0) {
            buffer.append(this.phrase.toString(field));
            buffer.append("!");
        }
        buffer.append("\"");
        Iterator<Entry> i = this.entries.iterator();
        while (i.hasNext()) {
            Entry entry = i.next();
            Term[] terms = entry.terms;
            if (terms.length > 1) {
                buffer.append("(");
                for (int j = 0; j < terms.length; ++j) {
                    buffer.append(terms[j].text());
                    if (j >= terms.length - 1) continue;
                    buffer.append(" ");
                }
                buffer.append(")");
            } else {
                buffer.append(terms[0].text());
                if (entry.wild) {
                    buffer.append("[W]");
                }
            }
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
        buffer.append("\"");
        if (this.phrase.getSlop() != 0) {
            buffer.append("~");
            buffer.append(this.phrase.getSlop());
        }
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    static class Entry {
        Term[] terms;
        int pos;
        boolean wild;

        Entry(Term[] terms, int pos, boolean wild) {
            this.terms = terms;
            this.pos = pos;
            this.wild = wild;
        }
    }
}

