/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ScoringWeights;
import com.ibm.es.nuvo.search.TextSearcher;
import com.ibm.es.nuvo.search.query.MatchNoDocsQuery;
import com.ibm.es.nuvo.util.TimeUtils;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class StaticScoreQuery
extends Query {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static Config DEFAULT_CONFIG = new Config(0.25f, 0.0f, 0.25f, 0.5f);
    private static final long serialVersionUID = 1L;
    private Query textQuery;

    public StaticScoreQuery(Query query) {
        this.textQuery = query;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<static score>(");
        buffer.append(this.textQuery);
        buffer.append(")");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StaticScoreQuery)) {
            return false;
        }
        StaticScoreQuery other = (StaticScoreQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.textQuery.equals(other.textQuery);
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        Weight textWeight = this.textQuery.weight(searcher);
        return new StaticScoreWeight(searcher, textWeight);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ 0x1AA71190 ^ this.textQuery.hashCode();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrittenTextQuery = this.textQuery.rewrite(reader);
        if (rewrittenTextQuery == null) {
            return new MatchNoDocsQuery();
        }
        if (rewrittenTextQuery != this.textQuery) {
            StaticScoreQuery rewrittenQuery = new StaticScoreQuery(rewrittenTextQuery);
            rewrittenQuery.setBoost(this.getBoost());
            return rewrittenQuery;
        }
        return this;
    }

    private class StaticScoreWeight
    implements Weight {
        private static final long serialVersionUID = 1L;
        private Searcher searcher;
        private Weight textWeight;
        private Config config = DEFAULT_CONFIG;

        public StaticScoreWeight(Searcher searcher, Weight textWeight) {
            TextSearcher textSearcher;
            CollectionConfiguration colConfig;
            this.searcher = searcher;
            this.textWeight = textWeight;
            ScoringWeights weights = null;
            if (searcher instanceof TextSearcher && (colConfig = (textSearcher = (TextSearcher)searcher).getCollectionConfiguration()) != null) {
                weights = colConfig.getScoringWeights();
            }
            if (weights != null) {
                this.config = new Config((float)weights.getDepthWeight(), (float)weights.getAgeWeight(), (float)weights.getLinkCountWeight(), (float)weights.getTextWeight());
            }
        }

        public String toString() {
            return "static score weight(" + this.textWeight.toString() + ")";
        }

        public Query getQuery() {
            return StaticScoreQuery.this;
        }

        public float getValue() {
            return this.textWeight.getValue();
        }

        public float sumOfSquaredWeights() throws IOException {
            float boost = StaticScoreQuery.this.getBoost();
            return boost * boost * this.textWeight.sumOfSquaredWeights();
        }

        public void normalize(float norm) {
            this.textWeight.normalize(norm);
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            Scorer textScorer = this.textWeight.scorer(reader);
            return new StaticScorer(reader, StaticScoreQuery.this.getSimilarity(this.searcher), this, textScorer, this.config);
        }

        public Explanation explain(IndexReader reader, int doc) {
            Explanation queryExpl = new Explanation();
            queryExpl.setDescription("StaticScoreQuery, product of:");
            queryExpl.setValue(this.getValue());
            if (StaticScoreQuery.this.getBoost() != 1.0f) {
                queryExpl.addDetail(new Explanation(StaticScoreQuery.this.getBoost(), "boost"));
            }
            return queryExpl;
        }
    }

    private class StaticScorer
    extends Scorer {
        final Config config;
        final IndexReader reader;
        final float weight;
        private Scorer textScorer;
        private int currentDateDays;
        private TermPositions datePositions;
        private int dateDoc;

        StaticScorer(IndexReader reader, Similarity similarity, Weight w, Scorer textScorer, Config config) throws IOException {
            super(similarity);
            this.reader = reader;
            this.weight = w.getValue();
            this.textScorer = textScorer;
            this.config = config;
            this.currentDateDays = TimeUtils.computeDaysSinceEpoch(System.currentTimeMillis());
            this.dateDoc = -1;
            this.datePositions = null;
            if (config.dateWeight > 0.0f) {
                this.datePositions = reader.termPositions(new Term("_datedays", "_datedays"));
                if (this.datePositions.next()) {
                    this.dateDoc = this.datePositions.doc();
                } else {
                    this.datePositions.close();
                    this.datePositions = null;
                }
            }
        }

        public Explanation explain(int doc) {
            return null;
        }

        public int doc() {
            return this.textScorer.doc();
        }

        public boolean next() throws IOException {
            return this.textScorer.next();
        }

        float getUrlDepth() throws IOException {
            return Similarity.decodeNorm((byte)this.reader.norms("_urldepth")[this.doc()]);
        }

        float getLinkCount() throws IOException {
            return Similarity.decodeNorm((byte)this.reader.norms("_links")[this.doc()]);
        }

        int getAgeDays() throws IOException {
            int dateDays = 0;
            if (this.dateDoc >= 0 && this.dateDoc < this.doc()) {
                this.dateDoc = this.datePositions.skipTo(this.doc()) ? this.datePositions.doc() : -1;
            }
            if (this.dateDoc == this.doc() && this.datePositions.freq() > 0) {
                dateDays = this.datePositions.nextPosition();
            }
            return this.currentDateDays - dateDays;
        }

        public float score() throws IOException {
            if (this.config.sumOfWeights <= 0.0f) {
                return 1.0f;
            }
            float score = 0.0f;
            float textScore = 0.0f;
            if (this.config.textWeight > 0.0f) {
                textScore = this.textScorer.score();
                score += this.config.textWeight * textScore;
            }
            if (this.config.urlDepthWeight > 0.0f) {
                float urlDepth = this.getUrlDepth();
                urlDepth = urlDepth < 2.0f ? 2.0f : urlDepth;
                float urlDepthScore = 1.0f / (urlDepth - 1.0f);
                score += this.config.urlDepthWeight * urlDepthScore;
            }
            if (this.config.linksWeight > 0.0f) {
                float linkCount = this.getLinkCount();
                float linkCountScore = linkCount / (linkCount + 1.0f);
                score += this.config.linksWeight * linkCountScore;
            }
            if (this.config.dateWeight > 0.0f) {
                float ageDays = this.getAgeDays();
                float dateScore = 1.0f / (ageDays + 1.0f);
                score += this.config.dateWeight * dateScore;
            }
            if ((double)(score /= this.config.sumOfWeights) == 0.0) {
                score = Float.MIN_VALUE;
            }
            return score;
        }

        public boolean skipTo(int target) throws IOException {
            return this.textScorer.skipTo(target);
        }
    }

    static class Config {
        float urlDepthWeight;
        float dateWeight;
        float linksWeight;
        float textWeight;
        float sumOfWeights;

        public Config(float urlDepthWeight, float dateWeight, float linksWeight, float textWeight) {
            this.urlDepthWeight = urlDepthWeight;
            this.dateWeight = dateWeight;
            this.linksWeight = linksWeight;
            this.textWeight = textWeight;
            this.sumOfWeights = urlDepthWeight + dateWeight + linksWeight + textWeight;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{ text: ");
            builder.append(this.textWeight);
            builder.append(", date: ");
            builder.append(this.dateWeight);
            builder.append(", link: ");
            builder.append(this.linksWeight);
            builder.append(", urldepth: ");
            builder.append(this.urlDepthWeight);
            builder.append(" }");
            return builder.toString();
        }
    }
}

