/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.search.query.ExtendedTermQuery;
import com.ibm.es.nuvo.tokenizer.ResultHandler;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.XMLToken;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryTokenizationHandler
implements ResultHandler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String field;
    private List<ExtendedTermQuery> results;
    private boolean lemmatize;
    private List<String> lemmas;
    private int lastEnd;
    private int beginOffset;
    private boolean separated;
    static final String[] dummyStringArray = new String[0];

    QueryTokenizationHandler(String field, int beginOffset, List<ExtendedTermQuery> results, boolean lemmatize) {
        this.field = field;
        this.results = results;
        this.lemmatize = lemmatize;
        this.lemmas = lemmatize ? new ArrayList() : null;
        this.lastEnd = 0;
        this.beginOffset = beginOffset;
        this.separated = false;
    }

    @Override
    public void addToken(TToken token, int begin, int end) {
        TToken.Type type = token.getType();
        if (!this.lemmatize || this.lemmas.size() == 0) {
            this.separated = begin > this.lastEnd;
            this.lastEnd = end;
        }
        String tokenString = token.toString();
        EnumSet<TToken.Property> props = token.getProperties();
        if (type == TToken.Type.LEMMA) {
            if (this.lemmatize) {
                this.lemmas.add(tokenString);
            }
        } else if (type == TToken.Type.BOTH) {
            if (this.lemmatize) {
                this.lemmas.add(tokenString);
            }
            this.addTerm(tokenString, begin, end, props.contains((Object)TToken.Property.STOPWORD), props.contains((Object)TToken.Property.ALL_UPPER), props.contains((Object)TToken.Property.HAS_WILDCARD), false);
        } else if (type == TToken.Type.ORIGINAL) {
            this.addTerm(tokenString, begin, end, props.contains((Object)TToken.Property.STOPWORD), props.contains((Object)TToken.Property.ALL_UPPER), props.contains((Object)TToken.Property.HAS_WILDCARD), false);
        } else if (type == TToken.Type.NGRAM) {
            this.addTerm(tokenString, begin, end, props.contains((Object)TToken.Property.STOPWORD), props.contains((Object)TToken.Property.ALL_UPPER), props.contains((Object)TToken.Property.HAS_WILDCARD), true);
        }
    }

    private void addTerm(String text, int begin, int end, boolean stopword, boolean upper, boolean hasWildcard, boolean ngram) {
        if (this.beginOffset < 0) {
            begin = -1;
            end = -1;
        } else {
            begin += this.beginOffset;
            end += this.beginOffset;
        }
        if (hasWildcard) {
            ExtendedTermQuery term = new ExtendedTermQuery(this.field, text, null, false, false, this.separated, ngram);
            term.setBegin(begin);
            term.setEnd(end);
            term.setWildcard(true);
            this.results.add(term);
        } else {
            String[] lemmaz = this.lemmatize && this.lemmas.size() > 0 ? this.lemmas.toArray(dummyStringArray) : null;
            ExtendedTermQuery term = new ExtendedTermQuery(this.field, text, lemmaz, stopword, upper, this.separated, ngram);
            term.setBegin(begin);
            term.setEnd(end);
            this.results.add(term);
        }
        if (this.lemmatize) {
            this.lemmas.clear();
        }
    }

    @Override
    public void addField(String name, String value) {
    }

    @Override
    public void addXMLToken(XMLToken xmlToken) {
    }

    @Override
    public void close() {
    }

    @Override
    public void reset() {
    }
}

