/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.FieldDefinition;
import com.ibm.es.nuvo.configuration.FieldDefinitions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFieldConfiguration {
    private Map<String, FieldDefinition> fieldDefinitions;
    private List<String> textSearchableFields;
    private static HashSet<String> filterFields = new HashSet();
    private static HashMap<String, Float> fieldBoosts;

    public QueryFieldConfiguration(CollectionConfiguration collectionConfig) {
        this.fieldDefinitions = collectionConfig.getFieldDefinitions().getFieldDefinitions(FieldDefinitions.ALL);
    }

    FieldDefinition getFieldDefinition(String fieldName) {
        return this.fieldDefinitions.get(fieldName);
    }

    List<String> getTextSearchableFields() {
        if (this.textSearchableFields == null) {
            this.textSearchableFields = new ArrayList<String>();
            this.textSearchableFields.add("_plain");
            for (FieldDefinition fieldDef : this.fieldDefinitions.values()) {
                if (!fieldDef.isFullTextSearchable() || "_xmlvals".equals(fieldDef.getName())) continue;
                this.textSearchableFields.add(fieldDef.getName());
            }
        }
        return this.textSearchableFields;
    }

    public Float getFieldBoost(String field) {
        return fieldBoosts.get(field);
    }

    public boolean isConfigured(String fieldname) {
        return this.getFieldDefinition(fieldname) != null;
    }

    public boolean isTextSearchable(String fieldname) {
        FieldDefinition fieldDef = this.getFieldDefinition(fieldname);
        if (fieldDef == null) {
            return false;
        }
        return fieldDef.isFullTextSearchable();
    }

    public boolean isFieldSearchable(String fieldname) {
        FieldDefinition fieldDef = this.getFieldDefinition(fieldname);
        if (fieldDef == null) {
            return false;
        }
        return fieldDef.isFieldSearchable();
    }

    public boolean isFilter(String fieldname) {
        return filterFields.contains(fieldname);
    }

    public boolean isTokenized(String fieldname) {
        if ("_plain".equals(fieldname)) {
            return true;
        }
        FieldDefinition fieldDef = this.getFieldDefinition(fieldname);
        if (fieldDef == null || !fieldDef.isFieldSearchable()) {
            return true;
        }
        return fieldDef.getFieldSearchAttr().isTokenized();
    }

    public boolean isLemmatized(String fieldname) {
        if ("_plain".equals(fieldname)) {
            return true;
        }
        FieldDefinition fieldDef = this.getFieldDefinition(fieldname);
        if (fieldDef == null || !fieldDef.isFieldSearchable()) {
            return true;
        }
        return fieldDef.getFieldSearchAttr().isLemmatized();
    }

    public boolean isCaseSensitive(String fieldname) {
        if ("_plain".equals(fieldname)) {
            return false;
        }
        FieldDefinition fieldDef = this.getFieldDefinition(fieldname);
        if (fieldDef == null || !fieldDef.isFieldSearchable()) {
            return true;
        }
        return fieldDef.getFieldSearchAttr().isCaseSensitive();
    }

    public boolean isParametric(String fieldname) {
        FieldDefinition fieldDef = this.getFieldDefinition(fieldname);
        return fieldDef != null && fieldDef.isParametricSearchable();
    }

    public boolean isDate(String fieldname) {
        FieldDefinition fieldDef = this.getFieldDefinition(fieldname);
        if (fieldDef == null || !fieldDef.isParametricSearchable()) {
            return false;
        }
        return fieldDef.getParametricSearchAttr().getType().equals((Object)FieldDefinition.ParametricType.Date);
    }

    public boolean isDecimal(String fieldname) {
        FieldDefinition fieldDef = this.getFieldDefinition(fieldname);
        if (fieldDef == null || !fieldDef.isParametricSearchable()) {
            return false;
        }
        return fieldDef.getParametricSearchAttr().getType().equals((Object)FieldDefinition.ParametricType.Decimal);
    }

    public int getDecimalPrecision(String fieldname) {
        FieldDefinition fieldDef = this.getFieldDefinition(fieldname);
        if (fieldDef == null || !fieldDef.isParametricSearchable()) {
            return 0;
        }
        return fieldDef.getParametricSearchAttr().getPrecision();
    }

    static {
        filterFields.add("language");
        filterFields.add("url");
        filterFields.add("uri");
        filterFields.add("doctype");
        filterFields.add("fileext");
        filterFields.add("site");
        fieldBoosts = new HashMap();
    }
}

