/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.search.query.ExtendedTermQuery;
import org.apache.lucene.index.Term;

public class ProximityTerm {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private boolean lemmatize;
    private boolean required;
    private ExtendedTermQuery termQuery;

    public ProximityTerm(ExtendedTermQuery term, boolean lemmatize, boolean required) {
        this.lemmatize = lemmatize;
        this.required = required;
        this.termQuery = term;
    }

    public Term[] computeTerm(boolean removeStopwords, boolean lemmatization) {
        Term[] termArray;
        if (removeStopwords && !this.required && this.termQuery.isStopword()) {
            return null;
        }
        Term[] lemmas = null;
        if (this.lemmatize && lemmatization && this.termQuery.mustLemmatize()) {
            lemmas = this.termQuery.computeLemmaTerms();
        }
        if (lemmas != null) {
            termArray = lemmas;
        } else {
            Term[] termArray2 = new Term[1];
            termArray = termArray2;
            termArray2[0] = this.termQuery.getTerm();
        }
        return termArray;
    }
}

