/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ScoringWeights;
import com.ibm.es.nuvo.search.TextSearcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProximityQuery
extends Query {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 1L;
    private static final Config DEFAULT_CONFIG = new Config(2.0f, 5, 3.5f, 20, 0.2f);
    private static final int DEFAULT_MAX_TERM_COUNT = 100;
    private int maxTermCount = 100;
    private Query textQuery;
    private IndexReader indexReader;
    List<ProximityTermPosition> ptpList = null;
    private List<List<Term[]>> termList = null;
    private String field = null;

    public void setTextQuery(Query textQuery) {
        this.textQuery = textQuery;
    }

    public Query getTextQuery() {
        return this.textQuery;
    }

    public void setMaxTermCount(int maxTermCount) {
        this.maxTermCount = maxTermCount;
    }

    public void addTermGroup(List<Term[]> group) {
        if (group == null || group.size() < 2) {
            return;
        }
        if (this.termList == null) {
            this.termList = new LinkedList<List<Term[]>>();
        }
        if (this.field == null) {
            this.field = group.get(0)[0].field().intern();
        } else if (this.field != group.get(0)[0].field()) {
            return;
        }
        this.termList.add(group);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrittenQuery = this.textQuery.rewrite(reader);
        ProximityQuery q = this;
        if (rewrittenQuery != this.textQuery) {
            q = new ProximityQuery();
            q.field = this.field;
            q.setBoost(this.getBoost());
            q.setTextQuery(rewrittenQuery);
            q.setMaxTermCount(this.maxTermCount);
            q.termList = this.termList;
        }
        q.indexReader = reader;
        return q;
    }

    private void createProximityTermPositions(Searcher searcher) throws IOException {
        HashMap<Term, ProximityTermPosition> termPositionMap = new HashMap<Term, ProximityTermPosition>();
        this.ptpList = new ArrayList<ProximityTermPosition>();
        int termCount = 0;
        Iterator<List<Term[]>> groupIterator = this.termList.iterator();
        while (groupIterator.hasNext()) {
            ProximityTermPosition prev = null;
            for (Term[] curTerm : groupIterator.next()) {
                ProximityTermPosition next;
                if (curTerm.length == 1) {
                    next = (ProximityTermPosition)termPositionMap.get(curTerm[0]);
                    if (next == null) {
                        next = new SingleProximityTermPosition(this.indexReader, searcher, curTerm[0]);
                        termPositionMap.put(curTerm[0], next);
                        ++termCount;
                    }
                } else {
                    ProximityTermPosition[] ptp = new ProximityTermPosition[curTerm.length];
                    for (int i = 0; i < ptp.length; ++i) {
                        ptp[i] = (ProximityTermPosition)termPositionMap.get(curTerm[i]);
                        if (ptp[i] != null) continue;
                        ptp[i] = new SingleProximityTermPosition(this.indexReader, searcher, curTerm[i]);
                        termPositionMap.put(curTerm[i], ptp[i]);
                        ++termCount;
                    }
                    next = new MultipleProximityTermPosition(ptp);
                }
                this.ptpList.add(next);
                if (prev != null && prev != next) {
                    prev.addNeighbour(next);
                    next.addNeighbour(prev);
                }
                prev = next;
                if (termCount < this.maxTermCount) continue;
                break;
            }
            if (prev != null && prev.neighbours.isEmpty()) {
                this.ptpList.remove(prev);
            }
            if (termCount < this.maxTermCount) continue;
            break;
        }
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        Weight textWeight = this.textQuery.weight(searcher);
        return new ProximityWeight(searcher, textWeight);
    }

    private static float gauss(int dist, float deviation) {
        float f = (float)dist / deviation;
        f = (float)Math.exp(-0.5f * f * f);
        return f;
    }

    public String toString(String arg0) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<proximity score>[");
        for (int i = 0; i < this.termList.size(); ++i) {
            List<Term[]> proxGroup = this.termList.get(i);
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append("[");
            for (int j = 0; j < proxGroup.size(); ++j) {
                Term[] terms = proxGroup.get(j);
                if (j != 0) {
                    buffer.append(", ");
                }
                buffer.append("[");
                for (int k = 0; k < terms.length; ++k) {
                    if (k != 0) {
                        buffer.append(", ");
                    }
                    buffer.append(terms[k]);
                }
                buffer.append("]");
            }
            buffer.append("]");
        }
        buffer.append("](");
        buffer.append(this.textQuery);
        buffer.append(")");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    static /* synthetic */ Config access$200() {
        return DEFAULT_CONFIG;
    }

    private static final class ProxScoreAccumulator {
        private Map<Float, MutableFloat> scores = new HashMap<Float, MutableFloat>();

        private ProxScoreAccumulator() {
        }

        void reset() {
            this.scores.clear();
        }

        void addScore(float weight, float score) {
            MutableFloat mf = this.scores.get(Float.valueOf(weight));
            if (mf == null) {
                mf = new MutableFloat(score);
                this.scores.put(Float.valueOf(weight), mf);
            } else {
                mf.add(score);
            }
        }

        float getOverallScore(Similarity sim) {
            float score = 0.0f;
            Iterator<MutableFloat> it = this.scores.values().iterator();
            while (it.hasNext()) {
                score += sim.tf(it.next().get());
            }
            return score;
        }

        private static final class MutableFloat {
            private float value;

            MutableFloat(float value) {
                this.value = value;
            }

            void add(float v) {
                this.value += v;
            }

            float get() {
                return this.value;
            }
        }
    }

    private class ProximityScorer
    extends Scorer {
        private Scorer textScorer;
        private PriorityQueue<ProximityTermPosition> scoreQueue;
        private ProxScoreAccumulator proxScoreAccumulator;
        private Config config;
        private byte[] norms;
        private float[] gaussBuffer;
        private Similarity similarity;

        protected ProximityScorer(Scorer textScorer, Similarity similarity, byte[] norms, Config config) {
            super(similarity);
            this.scoreQueue = null;
            this.proxScoreAccumulator = null;
            this.textScorer = textScorer;
            this.scoreQueue = new PriorityQueue();
            this.proxScoreAccumulator = new ProxScoreAccumulator();
            this.norms = norms;
            this.config = config;
            this.similarity = similarity;
            this.createGaussBuffer();
        }

        private void createGaussBuffer() {
            this.gaussBuffer = new float[this.config.windowSize];
            for (int i = 0; i < this.config.windowSize; ++i) {
                this.gaussBuffer[i] = ProximityQuery.gauss(i, this.config.gaussDeviation);
            }
        }

        public boolean next() throws IOException {
            if (this.textScorer.next()) {
                return true;
            }
            Iterator<ProximityTermPosition> it = ProximityQuery.this.ptpList.iterator();
            while (it.hasNext()) {
                it.next().close();
            }
            return false;
        }

        public int doc() {
            return this.textScorer.doc();
        }

        public float score() throws IOException {
            float textScore = this.textScorer.score();
            float proximityScore = this.calculateProximityScore();
            float score = (textScore + proximityScore * this.config.proximityWeight) / (1.0f + this.config.proximityWeight);
            return score;
        }

        private float calculateProximityScore() throws IOException {
            int curDoc = this.doc();
            this.scoreQueue.clear();
            float lengthNorm = Similarity.decodeNorm((byte)this.norms[this.doc()]);
            int sumOfFreqs = 0;
            int maxTermFreq = 0;
            int posCounter = 0;
            ProximityTermPosition termWithMaxFreq = null;
            for (ProximityTermPosition curTerm : ProximityQuery.this.ptpList) {
                if (!curTerm.nextDocument(curDoc) || !curTerm.nextPosition()) continue;
                ++posCounter;
                int curFreq = curTerm.getMaxFreq();
                this.scoreQueue.add(curTerm);
                sumOfFreqs += curFreq;
                if (termWithMaxFreq != null && curFreq <= maxTermFreq) continue;
                termWithMaxFreq = curTerm;
                maxTermFreq = curFreq;
            }
            if (termWithMaxFreq == null || sumOfFreqs == 0) {
                return 0.0f;
            }
            termWithMaxFreq.setMaxFreq((int)Math.min((float)maxTermFreq, Math.max((float)this.config.minNumberOfPositionsToProcess, this.config.fractionOfPositionsToProcess * (float)maxTermFreq)));
            this.proxScoreAccumulator.reset();
            while (this.scoreQueue.size() >= 2 && termWithMaxFreq.getMaxFreq() > 0) {
                int dist;
                ProximityTermPosition top = this.scoreQueue.poll();
                ProximityTermPosition second = this.scoreQueue.peek();
                int lastPosition = 0;
                boolean more = true;
                while (more && top.getCurPosition() <= second.getCurPosition()) {
                    lastPosition = top.getCurPosition();
                    more = top.nextPosition();
                    ++posCounter;
                }
                if (top.isAdjacent(second) && (dist = Math.max(0, Math.abs(second.getCurPosition() - lastPosition) - 1)) < this.config.windowSize) {
                    float s = this.gaussBuffer[dist];
                    this.proxScoreAccumulator.addScore(top.getWeight(), s);
                    this.proxScoreAccumulator.addScore(second.getWeight(), s);
                }
                if (!more) continue;
                this.scoreQueue.add(top);
            }
            return this.proxScoreAccumulator.getOverallScore(this.similarity) * lengthNorm * (float)sumOfFreqs / (float)posCounter;
        }

        public boolean skipTo(int target) throws IOException {
            return this.textScorer.skipTo(target);
        }

        public Explanation explain(int doc) throws IOException {
            return this.textScorer.explain(doc);
        }
    }

    private class ProximityWeight
    implements Weight {
        private static final long serialVersionUID = 1L;
        private Weight textWeight;
        private Searcher searcher;
        private Config config = ProximityQuery.access$200();

        ProximityWeight(Searcher searcher, Weight textWeight) throws IOException {
            TextSearcher textSearcher;
            CollectionConfiguration colConfig;
            this.searcher = searcher;
            this.textWeight = textWeight;
            ProximityQuery.this.createProximityTermPositions(this.searcher);
            ScoringWeights weights = null;
            if (searcher instanceof TextSearcher && (colConfig = (textSearcher = (TextSearcher)searcher).getCollectionConfiguration()) != null) {
                weights = colConfig.getScoringWeights();
            }
            if (weights != null) {
                this.config = new Config((float)weights.getProximityWeight(), weights.getProximityWindowSize(), (float)weights.getProximityGaussDeviation(), weights.getProximityMinNumberOfPositionsToProcess(), (float)weights.getProximityFractionOfPositionsToProcess());
            }
        }

        public Query getQuery() {
            return ProximityQuery.this;
        }

        public float getValue() {
            return this.textWeight.getValue();
        }

        public float sumOfSquaredWeights() throws IOException {
            float boost = ProximityQuery.this.getBoost();
            return boost * boost * this.textWeight.sumOfSquaredWeights();
        }

        public void normalize(float norm) {
            this.textWeight.normalize(norm);
            Iterator<ProximityTermPosition> it = ProximityQuery.this.ptpList.iterator();
            while (it.hasNext()) {
                it.next().normalize(norm);
            }
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            Scorer textScorer = this.textWeight.scorer(reader);
            return new ProximityScorer(textScorer, ProximityQuery.this.getSimilarity(this.searcher), reader.norms(ProximityQuery.this.field), this.config);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return null;
        }
    }

    private static class SingleProximityTermPosition
    extends ProximityTermPosition {
        private int freq;
        private float idf;
        private float weight;
        private IndexReader reader;
        private TermPositions termPositions;
        private Term term;

        SingleProximityTermPosition(IndexReader reader, Searcher searcher, Term term) throws IOException {
            this.reader = reader;
            this.term = term;
            this.idf = searcher.getSimilarity().idf(term, searcher);
            this.weight = 0.0f;
            this.termPositions = null;
        }

        float getWeight() {
            return this.weight;
        }

        void normalize(float norm) {
            this.weight = this.idf * this.idf * norm;
        }

        public boolean nextDocument(int document) throws IOException {
            this.curPosition = -1;
            if (this.termPositions == null) {
                this.termPositions = this.reader.termPositions(this.term);
                this.termPositions.next();
            }
            if (this.termPositions.doc() < document && !this.termPositions.skipTo(document)) {
                return false;
            }
            if (this.termPositions.doc() == document) {
                this.freq = this.termPositions.freq();
                return true;
            }
            return false;
        }

        public boolean nextPosition() throws IOException {
            if (this.freq == 0) {
                return false;
            }
            this.curPosition = this.termPositions.nextPosition();
            --this.freq;
            return true;
        }

        int getMaxFreq() {
            return this.freq;
        }

        void setMaxFreq(int freq) {
            this.freq = freq;
        }

        public void close() throws IOException {
            if (this.termPositions != null) {
                this.termPositions.close();
            }
        }
    }

    private static class MultipleProximityTermPosition
    extends ProximityTermPosition {
        ProximityTermPosition[] ptp;
        PriorityQueue<ProximityTermPosition> ptpQueue;
        private float weight;
        int freq;

        MultipleProximityTermPosition(ProximityTermPosition[] ptp) throws IOException {
            this.ptp = ptp;
            this.ptpQueue = new PriorityQueue();
        }

        float getWeight() {
            return this.weight;
        }

        void normalize(float norm) {
            for (int i = 0; i < this.ptp.length; ++i) {
                this.ptp[i].normalize(norm);
            }
        }

        public boolean nextDocument(int document) throws IOException {
            this.ptpQueue.clear();
            this.curPosition = -1;
            this.freq = 0;
            for (int i = 0; i < this.ptp.length; ++i) {
                if (!this.ptp[i].nextDocument(document)) continue;
                this.freq = Math.max(this.freq, this.ptp[i].getMaxFreq());
                this.ptpQueue.offer(this.ptp[i]);
            }
            return !this.ptpQueue.isEmpty();
        }

        public boolean nextPosition() throws IOException {
            int topPosition;
            ProximityTermPosition top;
            if (this.freq == 0) {
                return false;
            }
            while (this.ptpQueue.peek().curPosition <= this.curPosition) {
                top = this.ptpQueue.poll();
                boolean more = true;
                while (more && top.curPosition <= this.curPosition) {
                    more = top.nextPosition();
                }
                if (more) {
                    this.ptpQueue.offer(top);
                }
                if (!this.ptpQueue.isEmpty()) continue;
                return false;
            }
            top = this.ptpQueue.peek();
            this.curPosition = topPosition = top.getCurPosition();
            this.weight = top.getWeight();
            --this.freq;
            return true;
        }

        int getMaxFreq() {
            return this.freq;
        }

        void setMaxFreq(int freq) {
            this.freq = freq;
        }

        public void close() throws IOException {
            for (int i = 0; i < this.ptp.length; ++i) {
                this.ptp[i].close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ProximityTermPosition
    implements Comparable<ProximityTermPosition> {
        private List<ProximityTermPosition> neighbours = new LinkedList<ProximityTermPosition>();
        protected int curPosition = -1;

        private ProximityTermPosition() {
        }

        void addNeighbour(ProximityTermPosition nextTerm) {
            this.neighbours.add(nextTerm);
        }

        boolean isAdjacent(ProximityTermPosition other) {
            return this.neighbours.contains(other);
        }

        abstract float getWeight();

        abstract void normalize(float var1);

        abstract boolean nextDocument(int var1) throws IOException;

        abstract boolean nextPosition() throws IOException;

        int getCurPosition() {
            return this.curPosition;
        }

        abstract int getMaxFreq();

        abstract void setMaxFreq(int var1);

        abstract void close() throws IOException;

        @Override
        public int compareTo(ProximityTermPosition other) {
            if (this.getCurPosition() < other.getCurPosition()) {
                return -1;
            }
            if (this.getCurPosition() > other.getCurPosition()) {
                return 1;
            }
            return 0;
        }
    }

    private static class Config {
        private float proximityWeight;
        private int windowSize;
        private float gaussDeviation;
        private int minNumberOfPositionsToProcess;
        private float fractionOfPositionsToProcess;

        Config(float proximityWeight, int windowSize, float gaussDeviation, int minNumberOfPositionsToProcess, float fractionOfPositionsToProcess) {
            this.proximityWeight = proximityWeight;
            this.windowSize = windowSize;
            this.gaussDeviation = gaussDeviation;
            this.minNumberOfPositionsToProcess = minNumberOfPositionsToProcess;
            this.fractionOfPositionsToProcess = fractionOfPositionsToProcess;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{proxWeight: ");
            sb.append(this.proximityWeight);
            sb.append(", windowSize: ");
            sb.append(this.windowSize);
            sb.append(", gaussDeviation: ");
            sb.append(this.gaussDeviation);
            sb.append(", minNumberOfPositions: ");
            sb.append(this.minNumberOfPositionsToProcess);
            sb.append(", fractionOfPositions: ");
            sb.append(this.fractionOfPositionsToProcess);
            sb.append("}");
            return sb.toString();
        }
    }
}

