/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.search.query.EarlyTerminationIndicator;
import com.ibm.es.nuvo.search.query.SpellSuggestionCandidate;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightQueryTerms;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedQuery {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String queryString;
    private Query query;
    private List<Term> filterTerms;
    private List<Term> termsForQuicklinks;
    private Map<String, HighlightQueryTerms> termsForSummarizer;
    private List<SpellSuggestionCandidate> spellCandidates;
    private List<Term> removedStopwords;
    private List<String> addedSynonyms;
    private Set<String> queryFields;
    private List<Message> invalidMessages;
    private EarlyTerminationIndicator earlyTerminationIndicator;
    private static final String[] dummyStringArray = new String[0];

    public ParsedQuery(String queryString) {
        this.queryString = queryString;
        this.query = null;
        this.filterTerms = new ArrayList<Term>();
        this.termsForQuicklinks = new ArrayList<Term>();
        this.termsForSummarizer = new HashMap<String, HighlightQueryTerms>();
        this.spellCandidates = new ArrayList<SpellSuggestionCandidate>();
        this.removedStopwords = new ArrayList<Term>();
        this.addedSynonyms = new ArrayList<String>();
        this.queryFields = new HashSet<String>();
        this.invalidMessages = new ArrayList<Message>();
        this.earlyTerminationIndicator = new EarlyTerminationIndicator();
    }

    public List<Term> getFilterTerms() {
        return this.filterTerms;
    }

    public List<Term> getTermsForQuicklinks() {
        return this.termsForQuicklinks;
    }

    public HighlightQueryTerms getTermsForSummarizer(String field) {
        HighlightQueryTerms ret = this.termsForSummarizer.get(field);
        if (ret == null) {
            ret = new HighlightQueryTerms();
            this.termsForSummarizer.put(field, ret);
        }
        return ret;
    }

    public Map<String, HighlightQueryTerms> getTermsForSummarizer() {
        return this.termsForSummarizer;
    }

    public List<SpellSuggestionCandidate> getSpellSuggestionCandidates() {
        return this.spellCandidates;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public List<Term> getRemovedStopwords() {
        return this.removedStopwords;
    }

    public List<String> getAddedSynonyms() {
        return this.addedSynonyms;
    }

    public void addQueryField(String fieldName) {
        this.queryFields.add(fieldName);
    }

    public String[] getQueryFields() {
        return this.queryFields.toArray(dummyStringArray);
    }

    public List<Message> getMessages() {
        return this.invalidMessages;
    }

    public EarlyTerminationIndicator getEarlyTerminationIndicator() {
        return this.earlyTerminationIndicator;
    }

    public void print(PrintStream out) {
        out.println(this.getQueryString() + ": ");
        out.println("  query     = " + this.getQuery());
        out.println("  fields    = " + this.queryFields);
        out.println("  strings   = " + this.getTermsForQuicklinks());
        out.println("  terms     = ");
        Set<Map.Entry<String, HighlightQueryTerms>> termsByField = this.termsForSummarizer.entrySet();
        for (Map.Entry<String, HighlightQueryTerms> curField : termsByField) {
            out.println("\t" + curField.getKey() + ": " + curField.getValue());
        }
        out.println("  filters   = " + this.getFilterTerms());
        out.println("  spelling  = " + this.getSpellSuggestionCandidates());
        out.println("  synonyms  = " + this.getAddedSynonyms());
        out.println("  stopwords = " + this.getRemovedStopwords());
        out.println("  messages  = ");
        for (Message msg : this.getMessages()) {
            System.out.println("    " + msg.getFormattedText());
        }
    }
}

