/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.search.query.ParametricRangePositions;
import com.ibm.es.nuvo.search.query.ParametricRangeQuery;
import java.io.IOException;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

final class ParametricRangeScorer
extends Scorer {
    private Weight weight;
    private ParametricRangePositions rangePositions;
    private int doc;
    private final int[] docs = new int[32];
    private int pointer;
    private int pointerMax;

    ParametricRangeScorer(Weight weight, TermPositions tp, Similarity similarity, String lower, String upper, boolean inclusive) throws IOException {
        super(similarity);
        this.weight = weight;
        this.rangePositions = new ParametricRangePositions(tp, lower, upper, inclusive);
    }

    public void score(HitCollector hc) throws IOException {
        this.next();
        this.score(hc, Integer.MAX_VALUE);
    }

    protected boolean score(HitCollector c, int end) throws IOException {
        while (this.doc < end) {
            c.collect(this.doc, 1.0f);
            ++this.pointer;
            if (this.pointer >= this.docs.length || this.pointer >= this.pointerMax) {
                this.pointerMax = this.read();
                if (this.pointerMax != 0) {
                    this.pointer = 0;
                } else {
                    this.rangePositions.close();
                    this.doc = Integer.MAX_VALUE;
                    break;
                }
            }
            this.doc = this.docs[this.pointer];
        }
        return true;
    }

    public int doc() {
        return this.doc;
    }

    public boolean next() throws IOException {
        ++this.pointer;
        if (this.pointer >= this.pointerMax) {
            this.pointerMax = this.read();
            if (this.pointerMax != 0) {
                this.pointer = 0;
            } else {
                this.rangePositions.close();
                this.doc = Integer.MAX_VALUE;
                return false;
            }
        }
        this.doc = this.docs[this.pointer];
        return true;
    }

    private int read() throws IOException {
        int index = 0;
        while (this.rangePositions.next()) {
            int freq = this.rangePositions.freq();
            for (int i = 0; i < freq; ++i) {
                this.rangePositions.nextPosition();
                this.docs[index++] = this.rangePositions.doc();
                if (index != this.docs.length) continue;
                return index;
            }
        }
        return index;
    }

    public float score() {
        return 1.0f;
    }

    public boolean skipTo(int target) throws IOException {
        ++this.pointer;
        while (this.pointer < this.pointerMax) {
            if (this.docs[this.pointer] >= target) {
                this.doc = this.docs[this.pointer];
                return true;
            }
            ++this.pointer;
        }
        boolean result = this.rangePositions.skipTo(target);
        if (result) {
            this.pointerMax = 1;
            this.pointer = 0;
            this.docs[this.pointer] = this.doc = this.rangePositions.doc();
        } else {
            this.doc = Integer.MAX_VALUE;
        }
        return result;
    }

    public Explanation explain(int docID) throws IOException {
        ParametricRangeQuery query = (ParametricRangeQuery)this.weight.getQuery();
        Explanation tfExplanation = new Explanation();
        int tf = 0;
        while (this.rangePositions.next()) {
            if (this.rangePositions.doc() != docID) continue;
            tf = this.rangePositions.freq();
        }
        this.rangePositions.close();
        tfExplanation.setValue(this.getSimilarity().tf(tf));
        tfExplanation.setDescription("tf(termFreq(" + query.getTerm() + ")=" + tf + ")");
        return tfExplanation;
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

