/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.search.query.ParametricRangeScorer;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class ParametricRangeQuery
extends Query {
    private static final long serialVersionUID = 6212973755629867312L;
    private String lowerRange;
    private String upperRange;
    private boolean inclusive;
    private Term term;

    public ParametricRangeQuery(Term term, String lowerRange, String upperRange, boolean inclusive) {
        if (term == null) {
            throw new IllegalArgumentException("term must be non-null");
        }
        this.lowerRange = lowerRange;
        this.upperRange = upperRange;
        this.term = term;
        this.inclusive = inclusive;
    }

    public Term getTerm() {
        return this.term;
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        return new TermWeight(searcher);
    }

    public void extractTerms(Set terms) {
        terms.add(this.getTerm());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParametricRangeQuery)) {
            return false;
        }
        ParametricRangeQuery other = (ParametricRangeQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.term.equals((Object)other.term);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.term.hashCode();
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        } else {
            buffer.append(field);
            buffer.append(":");
        }
        buffer.append(this.inclusive ? "[" : "{");
        buffer.append(this.lowerRange);
        buffer.append(" TO ");
        buffer.append(this.upperRange);
        buffer.append(this.inclusive ? "]" : "}");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public static void main(String[] args) {
    }

    private class TermWeight
    implements Weight {
        private static final long serialVersionUID = 478727591478395177L;
        private Similarity similarity;
        private float queryWeight;

        public TermWeight(Searcher searcher) throws IOException {
            this.similarity = ParametricRangeQuery.this.getSimilarity(searcher);
        }

        public String toString() {
            return "weight(" + (Object)((Object)ParametricRangeQuery.this) + ")";
        }

        public Query getQuery() {
            return ParametricRangeQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() {
            this.queryWeight = ParametricRangeQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float queryNorm) {
            this.queryWeight *= queryNorm;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            TermPositions termPositions = reader.termPositions(ParametricRangeQuery.this.term);
            if (termPositions == null) {
                return null;
            }
            return new ParametricRangeScorer(this, termPositions, this.similarity, ParametricRangeQuery.this.lowerRange, ParametricRangeQuery.this.upperRange, ParametricRangeQuery.this.inclusive);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation result = new Explanation();
            result.setDescription("ParametricRangeQuery product of:");
            result.setValue(this.queryWeight);
            result.addDetail(new Explanation(ParametricRangeQuery.this.getBoost(), "boost"));
            return result;
        }
    }
}

