/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.search.parametric.NumericPayloadRangeChecker;
import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;

public class ParametricRangePositions
implements TermPositions {
    private int doc;
    private int freq;
    private TermPositions termPositions;
    private PositionQueue posList;
    private NumericPayloadRangeChecker rangeChecker;

    public ParametricRangePositions(TermPositions tp, String lower, String upper, boolean inclusive) throws IOException {
        this(tp, lower, upper, inclusive, false);
    }

    public ParametricRangePositions(TermPositions tp, String lower, String upper, boolean inclusive, boolean invertSense) throws IOException {
        this.termPositions = tp;
        this.posList = new PositionQueue();
        this.rangeChecker = new NumericPayloadRangeChecker(lower, upper, inclusive, invertSense);
    }

    public final boolean next() throws IOException {
        return this.next(true);
    }

    private final boolean next(boolean enumerateToNextPosition) throws IOException {
        if (enumerateToNextPosition && !this.termPositions.next()) {
            return false;
        }
        this.posList.clear();
        while (this.posList.size() == 0) {
            for (int i = 0; i < this.termPositions.freq(); ++i) {
                int pos = this.termPositions.nextPosition();
                if (this.termPositions.getPayloadLength() < 2) continue;
                byte[] data = new byte[this.termPositions.getPayloadLength()];
                this.termPositions.getPayload(data, 0);
                if (!this.rangeChecker.checkIfInRange(data)) continue;
                this.posList.add(pos, data);
            }
            if (this.posList.size() != 0 || this.termPositions.next()) continue;
            this.doc = Integer.MAX_VALUE;
            this.freq = 0;
            return false;
        }
        this.doc = this.termPositions.doc();
        this.freq = this.posList.size();
        return true;
    }

    public final int nextPosition() {
        return this.posList.next();
    }

    public int getPayloadLength() {
        return this.posList.getPayloadBytes().length;
    }

    public final boolean skipTo(int target) throws IOException {
        this.termPositions.skipTo(target);
        return this.next(false);
    }

    public final int doc() {
        return this.doc;
    }

    public final int freq() {
        return this.freq;
    }

    public final void close() throws IOException {
        this.termPositions.close();
    }

    public void seek(Term arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void seek(TermEnum termEnum) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(int[] arg0, int[] arg1) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] getPayload(byte[] data, int offset) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isPayloadAvailable() {
        return false;
    }

    private static final class PositionQueue {
        private int arraySize = 16;
        private int index = 0;
        private int lastIndex = 0;
        private int[] array = new int[this.arraySize];
        private Vector<byte[]> payloads = new Vector(this.arraySize);

        private PositionQueue() {
        }

        final void add(int pos, byte[] payload) {
            if (this.lastIndex == this.arraySize) {
                this.growArray();
            }
            this.array[this.lastIndex] = pos;
            this.payloads.add(this.lastIndex, payload);
            ++this.lastIndex;
        }

        final int next() {
            return this.array[++this.index];
        }

        final byte[] getPayloadBytes() {
            return this.payloads.get(this.index);
        }

        final void clear() {
            this.index = -1;
            this.lastIndex = 0;
            this.payloads.clear();
        }

        final int size() {
            return this.lastIndex;
        }

        private void growArray() {
            int[] newArray = new int[this.arraySize * 2];
            System.arraycopy(this.array, 0, newArray, 0, this.arraySize);
            this.array = newArray;
            this.arraySize *= 2;
        }
    }
}

