/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.util.decimal.DecimalCondition;
import com.ibm.es.nuvo.util.decimal.DecimalTermDocs;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class ParametricQuery
extends Query {
    private static final long serialVersionUID = 4430461276273071040L;
    private DecimalCondition cond;
    private String field;

    public ParametricQuery(String field, DecimalCondition cond) {
        if (field == null) {
            throw new IllegalArgumentException("field must be non-null");
        }
        this.cond = cond;
        this.field = field;
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        return new ParametricWeight(searcher);
    }

    public void extractTerms(Set terms) {
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParametricQuery)) {
            return false;
        }
        ParametricQuery other = (ParametricQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.field.equals(other.field) && this.cond.equals(other.cond);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.field.hashCode();
    }

    public String toString(String fld) {
        return this.cond.toString(this.field) + ToStringUtils.boost((float)this.getBoost());
    }

    public String getField() {
        return this.field;
    }

    public DecimalCondition getCondition() {
        return this.cond;
    }

    private class ParametricWeight
    implements Weight {
        private static final long serialVersionUID = -2487037926705483730L;
        private Similarity similarity;
        private float queryWeight;

        public ParametricWeight(Searcher searcher) {
            this.similarity = ParametricQuery.this.getSimilarity(searcher);
        }

        public String toString() {
            return "weight(" + (Object)((Object)ParametricQuery.this) + ")";
        }

        public Query getQuery() {
            return ParametricQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() {
            this.queryWeight = ParametricQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float queryNorm) {
            this.queryWeight *= queryNorm;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            DecimalTermDocs termDocs = new DecimalTermDocs(reader, new Term(ParametricQuery.this.field, ""), ParametricQuery.this.cond);
            return new ParametricScorer(termDocs, this.similarity);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation result = new Explanation();
            result.setDescription("ParametricQuery product of:");
            result.setValue(this.queryWeight);
            result.addDetail(new Explanation(ParametricQuery.this.getBoost(), "boost"));
            return result;
        }

        private class ParametricScorer
        extends Scorer {
            private DecimalTermDocs termDocs;

            ParametricScorer(DecimalTermDocs decimalDocs, Similarity similarity) {
                super(similarity);
                this.termDocs = decimalDocs;
            }

            public int doc() {
                return this.termDocs.doc();
            }

            public boolean next() throws IOException {
                return this.termDocs.next();
            }

            public float score() {
                return 1.0f;
            }

            public boolean skipTo(int target) throws IOException {
                return this.termDocs.skipTo(target);
            }

            public Explanation explain(int docID) throws IOException {
                return null;
            }

            public String toString() {
                return "scorer(" + ParametricWeight.this + ")";
            }
        }
    }
}

