/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.search.query.LinguisticQueryParser;
import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public class NoLemmaTermEnum
extends FilteredTermEnum {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private FilteredTermEnum enumerator;
    private int count;

    public NoLemmaTermEnum(FilteredTermEnum enumerator) throws IOException {
        this.enumerator = enumerator;
        this.count = 1;
        if (!this.termCompare(this.term())) {
            this.next();
        }
    }

    public boolean next() throws IOException {
        while (this.count < LinguisticQueryParser.QUERY_EXPANSION_LIMIT && this.enumerator.next()) {
            Term term = this.enumerator.term();
            if (!this.termCompare(term)) continue;
            ++this.count;
            return true;
        }
        return false;
    }

    public Term term() {
        return this.enumerator.term();
    }

    public int docFreq() {
        return this.enumerator.docFreq();
    }

    public void close() throws IOException {
        this.enumerator.close();
    }

    protected boolean termCompare(Term term) {
        String text;
        if (term != null && (text = term.text()) != null && text.length() > 0) {
            return text.charAt(text.length() - 1) != '\u0001';
        }
        return false;
    }

    public float difference() {
        return this.enumerator.difference();
    }

    protected boolean endEnum() {
        return this.count >= LinguisticQueryParser.QUERY_EXPANSION_LIMIT;
    }
}

