/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.search.query.LinguisticQueryParser;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;

public class NoLemmaRangeQuery
extends RangeQuery {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 1L;

    public NoLemmaRangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive) {
        super(lowerTerm, upperTerm, inclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanQuery query = new BooleanQuery(true);
        boolean inclusive = super.isInclusive();
        Term lowerTerm = super.getLowerTerm();
        Term upperTerm = super.getUpperTerm();
        int count = 0;
        TermEnum enumerator = reader.terms(lowerTerm);
        try {
            boolean checkLower = false;
            if (!inclusive) {
                checkLower = true;
            }
            String testField = this.getField();
            do {
                Term term;
                if ((term = enumerator.term()) == null) return query;
                if (term.field() != testField) return query;
                int length = term.text().length();
                if (length > 0 && term.text().charAt(length - 1) == '\u0001' || checkLower && term.text().compareTo(lowerTerm.text()) <= 0) continue;
                checkLower = false;
                if (upperTerm != null) {
                    int compare = upperTerm.text().compareTo(term.text());
                    if (compare < 0) return query;
                    if (!inclusive && compare == 0) {
                        return query;
                    }
                }
                if (count >= LinguisticQueryParser.QUERY_EXPANSION_LIMIT) {
                    return query;
                }
                ++count;
                TermQuery tq = new TermQuery(term);
                tq.setBoost(this.getBoost());
                query.add((Query)tq, BooleanClause.Occur.SHOULD);
            } while (enumerator.next());
            return query;
        }
        finally {
            enumerator.close();
        }
    }
}

