/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.search.query.MatchNoDocsQuery;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public class NegatedQuery
extends Query {
    private static final long serialVersionUID = 1L;
    Query query;

    public NegatedQuery(Query q) {
        this.query = q;
    }

    public Query getQuery() {
        return this.query;
    }

    public String toString(String arg0) {
        return "NOT(" + this.query.toString() + ")";
    }

    public boolean equals(Object other) {
        if (other instanceof NegatedQuery) {
            return this.query.equals(((NegatedQuery)((Object)other)).query);
        }
        return false;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (this.query == rewritten) {
            return this;
        }
        if (rewritten instanceof MatchNoDocsQuery) {
            return new MatchAllDocsQuery();
        }
        return new NegatedQuery(rewritten);
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        Weight weight = this.query.weight(searcher);
        return new NegatedWeight(searcher, weight);
    }

    public void extractTerms(Set terms) {
    }

    private class NegatedWeight
    implements Weight {
        private static final long serialVersionUID = 1L;
        Searcher searcher;
        Weight weight;

        public NegatedWeight(Searcher searcher, Weight w) {
            this.searcher = searcher;
            this.weight = w;
        }

        public Query getQuery() {
            return NegatedQuery.this;
        }

        public float getValue() {
            return this.weight.getValue();
        }

        public float sumOfSquaredWeights() throws IOException {
            float boost = NegatedQuery.this.getBoost();
            return boost * boost * this.weight.sumOfSquaredWeights();
        }

        public void normalize(float norm) {
            this.weight.normalize(norm);
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            return new NegatedScorer(reader, this.weight.scorer(reader));
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation e = this.weight.explain(reader, doc);
            if (e.isMatch()) {
                Explanation e1 = new Explanation(0.0f, "match of negated query (" + this.weight.getQuery().toString() + ")");
                e1.addDetail(e);
                e1.setValue(0.0f);
                return e1;
            }
            Explanation e1 = new Explanation(0.0f, "non-match of negated query (" + this.weight.getQuery().toString() + ")");
            e1.addDetail(e);
            e1.setValue(this.weight.getValue());
            return e1;
        }

        private class NegatedScorer
        extends Scorer {
            IndexReader reader;
            Scorer scorer;
            int currentDoc;
            int nextMatch;
            int maxDoc;

            protected NegatedScorer(IndexReader reader, Scorer scorer) throws IOException {
                super(NegatedWeight.this.searcher.getSimilarity());
                this.reader = reader;
                this.scorer = scorer;
                this.maxDoc = reader.maxDoc();
                this.nextMatch = scorer.next() ? scorer.doc() : this.maxDoc;
                this.currentDoc = -1;
            }

            public boolean next() throws IOException {
                while (true) {
                    ++this.currentDoc;
                    if (this.currentDoc >= this.maxDoc) {
                        return false;
                    }
                    if (this.currentDoc >= this.nextMatch) {
                        this.nextMatch = this.scorer.next() ? this.scorer.doc() : this.maxDoc;
                        continue;
                    }
                    if (!this.reader.isDeleted(this.currentDoc)) break;
                }
                return true;
            }

            public int doc() {
                return this.currentDoc;
            }

            public float score() throws IOException {
                return NegatedWeight.this.weight.getValue();
            }

            public boolean skipTo(int doc) throws IOException {
                if (doc > this.nextMatch) {
                    this.nextMatch = this.scorer.skipTo(doc) ? this.scorer.doc() : this.maxDoc;
                }
                this.currentDoc = doc;
                if (this.nextMatch == doc) {
                    return this.next();
                }
                if (this.reader.isDeleted(doc)) {
                    return this.next();
                }
                return true;
            }

            public Explanation explain(int arg0) throws IOException {
                return null;
            }
        }
    }
}

