/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class MatchNoDocsQuery
extends Query {
    private static final long serialVersionUID = -1745992577144530001L;

    protected Weight createWeight(Searcher searcher) {
        return new MatchNoneWeight(searcher);
    }

    public void extractTerms(Set terms) {
    }

    public String toString(String field) {
        return "MatchNoDocsQuery" + ToStringUtils.boost((float)this.getBoost());
    }

    public boolean equals(Object o) {
        if (o instanceof MatchNoDocsQuery) {
            return this.getBoost() == ((MatchNoDocsQuery)((Object)o)).getBoost();
        }
        return false;
    }

    private class MatchNoneWeight
    implements Weight {
        private static final long serialVersionUID = -8000482020500736823L;
        private Similarity similarity;

        public MatchNoneWeight(Searcher searcher) {
            this.similarity = searcher.getSimilarity();
        }

        public String toString() {
            return "weight(" + (Object)((Object)MatchNoDocsQuery.this) + ")";
        }

        public Query getQuery() {
            return MatchNoDocsQuery.this;
        }

        public float getValue() {
            return MatchNoDocsQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() {
            return MatchNoDocsQuery.this.getBoost() * MatchNoDocsQuery.this.getBoost();
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) {
            return new MatchNoneScorer(this.similarity);
        }

        public Explanation explain(IndexReader reader, int doc) {
            return new Explanation(0.0f, "MatchNoDocsQuery");
        }
    }

    private class MatchNoneScorer
    extends Scorer {
        MatchNoneScorer(Similarity similarity) {
            super(similarity);
        }

        public boolean next() {
            return false;
        }

        public boolean skipTo(int target) {
            return false;
        }

        public int doc() {
            return -1;
        }

        public float score() {
            return 0.0f;
        }

        public Explanation explain(int docid) {
            return null;
        }
    }
}

