/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.indexer.DocumentStatus;
import com.ibm.es.nuvo.markup.query.MarkupContainsQuery;
import com.ibm.es.nuvo.normalizer.FieldNormalizer;
import com.ibm.es.nuvo.normalizer.LanguageNormalizer;
import com.ibm.es.nuvo.normalizer.MimetypeNormalizer;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType1;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType2;
import com.ibm.es.nuvo.search.query.EarlyTerminationQuery;
import com.ibm.es.nuvo.search.query.EnhancedPhraseQuery;
import com.ibm.es.nuvo.search.query.ExtendedBooleanClause;
import com.ibm.es.nuvo.search.query.ExtendedBooleanQuery;
import com.ibm.es.nuvo.search.query.ExtendedTermQuery;
import com.ibm.es.nuvo.search.query.MatchNoDocsQuery;
import com.ibm.es.nuvo.search.query.NegatedQuery;
import com.ibm.es.nuvo.search.query.NoLemmaFuzzyQuery;
import com.ibm.es.nuvo.search.query.NoLemmaRangeQuery;
import com.ibm.es.nuvo.search.query.NoLemmaWildcardQuery;
import com.ibm.es.nuvo.search.query.ParametricQuery;
import com.ibm.es.nuvo.search.query.ParsedQuery;
import com.ibm.es.nuvo.search.query.ProximityQuery;
import com.ibm.es.nuvo.search.query.ProximityTerm;
import com.ibm.es.nuvo.search.query.QueryFieldConfiguration;
import com.ibm.es.nuvo.search.query.QueryTokenizationHandler;
import com.ibm.es.nuvo.search.query.SpellSuggestionCandidate;
import com.ibm.es.nuvo.search.query.StaticScoreQuery;
import com.ibm.es.nuvo.search.query.WildcardPhraseQuery;
import com.ibm.es.nuvo.search.query.parser.QueryParser;
import com.ibm.es.nuvo.search.query.xpath.XPathQueryParser;
import com.ibm.es.nuvo.search.security.QueryBuilder;
import com.ibm.es.nuvo.search.security.UserSecurityContext;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightTerm;
import com.ibm.es.nuvo.synonym.index.SynonymIndexSearcher;
import com.ibm.es.nuvo.tokenizer.Tokenizer;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.tokenizer.TokenizerPool;
import com.ibm.es.nuvo.tokenizer.TokenizerProcessInput;
import com.ibm.es.nuvo.util.Iso8601Date;
import com.ibm.es.nuvo.util.decimal.Decimal;
import com.ibm.es.nuvo.util.decimal.DecimalCondition;
import com.ibm.es.nuvo.util.decimal.DecimalEquals;
import com.ibm.es.nuvo.util.decimal.DecimalLower;
import com.ibm.es.nuvo.util.decimal.DecimalNotEquals;
import com.ibm.es.nuvo.util.decimal.DecimalNotInRange;
import com.ibm.es.nuvo.util.decimal.DecimalRange;
import com.ibm.es.nuvo.util.decimal.DecimalUpper;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinguisticQueryParser
extends QueryParser {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Options options = new Options();
    private static Analyzer dummyAnalyzer = new SimpleAnalyzer();
    private ParsedQuery parsedQuery;
    private QueryFieldConfiguration fieldConfig;
    public static int QUERY_EXPANSION_LIMIT = BooleanQuery.getMaxClauseCount();
    private boolean enableProximity = true;
    private boolean enableStaticScore = true;
    private boolean enableSynonymExpansion = true;
    private long earlyTerminationTimeout = 0L;
    private Query securityConstraint;
    private Query languageConstraint;
    private Query scalarConstraint;
    public static boolean debug = false;

    private boolean isFilterTerm(Term term) {
        return this.fieldConfig.isFilter(term.field());
    }

    private boolean isExactTerm(Term term) {
        return !this.fieldConfig.isTokenized(term.field());
    }

    private boolean isSearchableField(String field) {
        return super.getField().equals(field) || this.fieldConfig.isFieldSearchable(field);
    }

    private void setFieldBoost(String field, Query query) {
        Float boost = this.fieldConfig.getFieldBoost(field);
        if (boost != null) {
            query.setBoost(boost.floatValue());
        }
    }

    public void setProximityScoringEnabled(boolean enabled) {
        this.enableProximity = enabled;
    }

    public void setStaticScoringEnabled(boolean enabled) {
        this.enableStaticScore = enabled;
    }

    public void setSynonymExpansionEnabled(boolean enabled) {
        this.enableSynonymExpansion = enabled;
    }

    public boolean isProximityScoringEnabled() {
        return this.enableProximity;
    }

    public boolean isStaticScoringEnabled() {
        return this.enableStaticScore;
    }

    public boolean isSynonymExpansionEnabled() {
        return this.enableSynonymExpansion;
    }

    public void setQueryLanguage(String queryLanguage) {
        this.options.setQueryLanguage(queryLanguage);
    }

    public void setSynonymSearcher(SynonymIndexSearcher synonymSearcher) {
        this.options.setSynonymIndexSearcher(synonymSearcher);
    }

    void setScalarConstraint(String uri) {
        this.scalarConstraint = null;
        if (uri == null) {
            return;
        }
        TermQuery query = new TermQuery(new Term("uri", uri));
        query.setBoost(0.0f);
        this.scalarConstraint = query;
    }

    void setLanguageConstraint(String languageFilter) {
        this.languageConstraint = null;
        if (languageFilter == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(languageFilter, ",");
        BooleanQuery boolQ = new BooleanQuery(true);
        while (tok.hasMoreElements()) {
            String lang = tok.nextToken();
            lang = LanguageNormalizer.normalize(lang);
            boolQ.add((Query)new TermQuery(new Term("language", lang)), BooleanClause.Occur.SHOULD);
        }
        if (boolQ.getClauses().length == 0) {
            return;
        }
        BooleanQuery query = boolQ.getClauses().length == 1 ? boolQ.getClauses()[0].getQuery() : boolQ;
        query.setBoost(0.0f);
        this.languageConstraint = query;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected Query getParametricQuery(String field, QueryParser.CompareOperator comp, String value) throws ParseException {
        if (!this.fieldConfig.isParametric(field)) {
            msg = new Message("S0232E.INVALID_PARAMETRIC_TERM");
            msg.addArgument(field);
            msg.addArgument(comp.toString());
            this.parsedQuery.getMessages().add(msg);
            return new MatchNoDocsQuery();
        }
        cond /* !! */  = null;
        if (this.fieldConfig.isDecimal(field)) {
            try {
                decValue = Decimal.parseDecimal(value, this.fieldConfig.getDecimalPrecision(field));
                if (comp.equals((Object)QueryParser.CompareOperator.EQ)) {
                    cond /* !! */  = new DecimalEquals(decValue);
                }
                if (comp.equals((Object)QueryParser.CompareOperator.NE)) {
                    cond /* !! */  = new DecimalNotEquals(decValue);
                }
                if (comp.equals((Object)QueryParser.CompareOperator.GE)) {
                    cond /* !! */  = new DecimalLower(decValue, true);
                }
                if (comp.equals((Object)QueryParser.CompareOperator.GT)) {
                    cond /* !! */  = new DecimalLower(decValue, false);
                }
                if (comp.equals((Object)QueryParser.CompareOperator.LE)) {
                    cond /* !! */  = new DecimalUpper(decValue, true);
                }
                if (!comp.equals((Object)QueryParser.CompareOperator.LT)) ** GOTO lbl72
                cond /* !! */  = new DecimalUpper(decValue, false);
            }
            catch (NumberFormatException e) {
                msg = new Message("S0230E.INVALID_DECIMAL_VALUE");
                msg.addArgument(field);
                msg.addArgument(value);
                this.parsedQuery.getMessages().add(msg);
                return new MatchNoDocsQuery();
            }
        } else if (this.fieldConfig.isDate(field)) {
            try {
                isoDate = Iso8601Date.parse(value);
                if (comp.equals((Object)QueryParser.CompareOperator.EQ)) {
                    if (isoDate.needsRounding()) {
                        cond /* !! */  = new DecimalRange(isoDate.date(), true, isoDate.roundUp(), true);
                    }
                    cond /* !! */  = new DecimalEquals(isoDate.date());
                }
                if (comp.equals((Object)QueryParser.CompareOperator.NE)) {
                    if (isoDate.needsRounding()) {
                        cond /* !! */  = new DecimalNotInRange(isoDate.date(), true, isoDate.roundUp(), true);
                    }
                    cond /* !! */  = new DecimalNotEquals(isoDate.date());
                }
                if (comp.equals((Object)QueryParser.CompareOperator.GE)) {
                    cond /* !! */  = new DecimalLower(isoDate.date(), true);
                }
                if (comp.equals((Object)QueryParser.CompareOperator.GT)) {
                    cond /* !! */  = new DecimalLower(isoDate.roundUp(), false);
                }
                if (comp.equals((Object)QueryParser.CompareOperator.LE)) {
                    cond /* !! */  = new DecimalUpper(isoDate.roundUp(), true);
                }
                if (!comp.equals((Object)QueryParser.CompareOperator.LT)) ** GOTO lbl72
                cond /* !! */  = new DecimalUpper(isoDate.date(), false);
            }
            catch (java.text.ParseException e) {
                msg = new Message("S0231E.INVALID_DATE_VALUE");
                msg.addArgument(field);
                msg.addArgument(value);
                this.parsedQuery.getMessages().add(msg);
                return new MatchNoDocsQuery();
            }
        } else {
            return new MatchNoDocsQuery();
        }
lbl72:
        // 16 sources

        this.parsedQuery.addQueryField(field);
        return new ParametricQuery(field, cond /* !! */ );
    }

    @Override
    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        if (!this.isSearchableField(field = FieldNormalizer.normalize(field))) {
            if (this.fieldConfig.isParametric(field)) {
                Query q1 = this.getParametricQuery(field, inclusive ? QueryParser.CompareOperator.GE : QueryParser.CompareOperator.GT, part1);
                Query q2 = this.getParametricQuery(field, inclusive ? QueryParser.CompareOperator.LE : QueryParser.CompareOperator.LT, part2);
                if (q1 instanceof MatchNoDocsQuery) {
                    return q1;
                }
                if (q2 instanceof MatchNoDocsQuery) {
                    return q2;
                }
                try {
                    return new ParametricQuery(field, new DecimalRange((DecimalLower)((ParametricQuery)q1).getCondition(), (DecimalUpper)((ParametricQuery)q2).getCondition()));
                }
                catch (Exception e) {
                    return new MatchNoDocsQuery();
                }
            }
            Message msg = new Message("S0229E.INVALID_TEXT_TERM");
            msg.addArgument(field);
            msg.addArgument((inclusive ? "[" : "{ ") + part1 + " TO " + part2 + (inclusive ? "]" : "}"));
            this.parsedQuery.getMessages().add(msg);
            return new MatchNoDocsQuery();
        }
        this.parsedQuery.addQueryField(field);
        if (!this.fieldConfig.isCaseSensitive(field)) {
            NormalizedStringBufferType2 normalizer = new NormalizedStringBufferType2();
            part1 = normalizer.append(part1).toString();
            normalizer.setLength(0);
            part2 = normalizer.append(part2).toString();
        }
        NoLemmaRangeQuery q = new NoLemmaRangeQuery(new Term(field, part1), new Term(field, part2), inclusive);
        this.setFieldBoost(field, (Query)q);
        return q;
    }

    @Override
    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (!this.isSearchableField(field = FieldNormalizer.normalize(field))) {
            Message msg = new Message("S0229E.INVALID_TEXT_TERM");
            msg.addArgument(field);
            msg.addArgument(termStr);
            this.parsedQuery.getMessages().add(msg);
            return new MatchNoDocsQuery();
        }
        this.parsedQuery.addQueryField(field);
        if (!this.fieldConfig.isCaseSensitive(field)) {
            NormalizedStringBufferType2 normalizer = new NormalizedStringBufferType2();
            termStr = normalizer.append(termStr).toString();
        }
        NoLemmaFuzzyQuery q = new NoLemmaFuzzyQuery(new Term(field, termStr), minSimilarity, super.getFuzzyPrefixLength());
        this.setFieldBoost(field, (Query)q);
        return q;
    }

    @Override
    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (!this.isSearchableField(field = FieldNormalizer.normalize(field))) {
            Message msg = new Message("S0229E.INVALID_TEXT_TERM");
            msg.addArgument(field);
            msg.addArgument(termStr);
            this.parsedQuery.getMessages().add(msg);
            return new MatchNoDocsQuery();
        }
        if (!this.fieldConfig.isTokenized(field)) {
            return this.getUntokenizedWildcardQuery(field, termStr);
        }
        return this.getFieldQuery(field, termStr, -1, -1, true);
    }

    private Query getUntokenizedWildcardQuery(String field, String termStr) {
        if (WildcardPhraseQuery.isPureWildcard(termStr)) {
            return null;
        }
        this.parsedQuery.addQueryField(field);
        if (!this.fieldConfig.isCaseSensitive(field)) {
            NormalizedStringBufferType2 normalizer = new NormalizedStringBufferType2();
            termStr = normalizer.append(termStr).toString();
        }
        NoLemmaWildcardQuery q = new NoLemmaWildcardQuery(new Term(field, termStr));
        this.setFieldBoost(field, (Query)q);
        return q;
    }

    @Override
    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        return this.getWildcardQuery(field, termStr + '*');
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, int start, int end, boolean attached) throws ParseException {
        if (!this.isSearchableField(field = FieldNormalizer.normalize(field))) {
            if (this.fieldConfig.isParametric(field)) {
                return this.getParametricQuery(field, QueryParser.CompareOperator.EQ, queryText);
            }
            Message msg = new Message("S0229E.INVALID_TEXT_TERM");
            msg.addArgument(field);
            msg.addArgument(queryText);
            this.parsedQuery.getMessages().add(msg);
            return new MatchNoDocsQuery();
        }
        if (!(this.fieldConfig.isTokenized(field) || queryText.indexOf(42) < 0 && queryText.indexOf(63) < 0)) {
            return this.getUntokenizedWildcardQuery(field, queryText);
        }
        this.parsedQuery.addQueryField(field);
        if ("language".equals(field)) {
            queryText = LanguageNormalizer.normalize(queryText);
        } else if ("doctype".equals(field)) {
            String mimeType = MimetypeNormalizer.normalize(queryText);
            queryText = mimeType != null ? mimeType : queryText.toLowerCase();
        }
        ArrayList<ExtendedTermQuery> terms = new ArrayList<ExtendedTermQuery>();
        if (!this.fieldConfig.isTokenized(field)) {
            if (!this.fieldConfig.isCaseSensitive(field)) {
                NormalizedStringBufferType2 normalizer = new NormalizedStringBufferType2();
                queryText = normalizer.append(queryText).toString();
            }
            ExtendedTermQuery term = new ExtendedTermQuery(field, queryText);
            term.setBegin(start);
            term.setEnd(end);
            terms.add(term);
        } else {
            Tokenizer tokenizer = null;
            try {
                tokenizer = this.options.getTokenizerPool().aquire(this.options.getCollectionConfig().getId());
                tokenizer.process(new QueryTokenizationHandler(field, start, terms, this.fieldConfig.isLemmatized(field)), new TokenizerProcessInput(queryText, null, this.options.getQueryLanguage()));
                if (terms.size() == 0) {
                    Query query = null;
                    return query;
                }
            }
            catch (TokenizerException e) {
                ParseException pe = new ParseException("Tokenization of query term \"" + queryText + "\" failed. ");
                pe.initCause((Throwable)e);
                throw pe;
            }
            finally {
                if (tokenizer != null) {
                    this.options.getTokenizerPool().release(tokenizer);
                }
            }
        }
        EnhancedPhraseQuery phrase = new EnhancedPhraseQuery(terms, attached);
        this.setFieldBoost(field, phrase);
        return phrase;
    }

    @Override
    protected Query getFieldQuery(String field, String queryText, int slop, int start, int end, boolean attached) throws ParseException {
        Query query = this.getFieldQuery(field, queryText, start, end, attached);
        if (query instanceof EnhancedPhraseQuery) {
            EnhancedPhraseQuery phrase = (EnhancedPhraseQuery)query;
            phrase.setSlop(slop);
        }
        return query;
    }

    protected Query getSynonymQuery(String field, String queryText, boolean isPhrase) throws ParseException {
        Query query = this.getFieldQuery(field, queryText, -1, -1, false);
        if (query instanceof EnhancedPhraseQuery) {
            EnhancedPhraseQuery phrase = (EnhancedPhraseQuery)query;
            if (isPhrase) {
                phrase.setSlop(0);
            }
            phrase.setSynonym();
        }
        return query;
    }

    @Override
    protected Query getBooleanQuery(Vector clauses, boolean disableCoord) throws ParseException {
        ExtendedBooleanClause clause;
        if (0 == clauses.size()) {
            return null;
        }
        List<List<ProximityTerm>> proxGroups = null;
        if (this.isProximityScoringEnabled()) {
            proxGroups = this.findLexicalAffinities(clauses);
        }
        this.findSpellSuggestions(clauses);
        if (this.isSynonymExpansionEnabled() && this.options.getSynonymIndexSearcher() != null) {
            clauses = this.expandSynonyms(clauses);
        }
        if (1 == clauses.size() && BooleanClause.Occur.MUST_NOT == (clause = (ExtendedBooleanClause)((Object)clauses.elementAt(0))).getOccur()) {
            clause.setQuery(new NegatedQuery(clause.getQuery()));
            clause.setOccur(BooleanClause.Occur.MUST);
        }
        ExtendedBooleanQuery booleanQuery = new ExtendedBooleanQuery(disableCoord);
        for (int i = 0; i < clauses.size(); ++i) {
            booleanQuery.add((ExtendedBooleanClause)((Object)clauses.elementAt(i)));
        }
        if (proxGroups != null) {
            booleanQuery.setProximityTerms(proxGroups);
        }
        return booleanQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Query getOpaqueQuery(String schema, String value) throws ParseException {
        if ("xpath".equals(schema)) {
            XPathQueryParser xqp = null;
            try {
                xqp = XPathQueryParser.requestParser();
                Query query = xqp.parse(value, this.options.cloneForXPath());
                return query;
            }
            finally {
                if (xqp != null) {
                    XPathQueryParser.releaseParser(xqp);
                }
            }
        }
        return super.getOpaqueQuery(schema, value);
    }

    List<List<ProximityTerm>> findLexicalAffinities(Vector<ExtendedBooleanClause> clauses) {
        ArrayList<ArrayList<ProximityTerm>> proxGroups = null;
        ArrayList<ProximityTerm> proxGroup = null;
        ExtendedTermQuery firstTerm = null;
        boolean lemmatizeFirstTerm = false;
        boolean requiredFirstTerm = false;
        for (int i = 0; i < clauses.size(); ++i) {
            ExtendedTermQuery term;
            EnhancedPhraseQuery q;
            ArrayList<ExtendedTermQuery> terms;
            ExtendedTermQuery currentTerm = null;
            boolean lemmatizeCurrent = false;
            boolean requiredCurrent = false;
            ExtendedBooleanClause clause = clauses.get(i);
            if (clause.getOccur() != BooleanClause.Occur.MUST_NOT && clause.getQuery() instanceof EnhancedPhraseQuery && (terms = (q = (EnhancedPhraseQuery)clause.getQuery()).getTerms()).size() == 1 && !(term = terms.get(0)).isWildcard() && !this.isFilterTerm(term.getTerm()) && !this.isExactTerm(term.getTerm())) {
                currentTerm = term;
                lemmatizeCurrent = q.isAutoQuote();
                boolean bl = requiredCurrent = !q.isAutoQuote() || clause.hasExplicitModifier();
            }
            if (!(firstTerm == null || currentTerm != null && firstTerm.getTerm().field().equals(currentTerm.getTerm().field()))) {
                if (proxGroup != null) {
                    if (proxGroups == null) {
                        proxGroups = new ArrayList();
                    }
                    proxGroups.add(proxGroup);
                    proxGroup = null;
                }
                firstTerm = null;
            }
            if (currentTerm == null) continue;
            if (firstTerm == null) {
                firstTerm = currentTerm;
                lemmatizeFirstTerm = lemmatizeCurrent;
                requiredFirstTerm = requiredCurrent;
                continue;
            }
            if (proxGroup == null) {
                proxGroup = new ArrayList<ProximityTerm>();
                proxGroup.add(new ProximityTerm(firstTerm, lemmatizeFirstTerm, requiredFirstTerm));
            }
            proxGroup.add(new ProximityTerm(currentTerm, lemmatizeCurrent, requiredCurrent));
        }
        if (proxGroup != null) {
            if (proxGroups == null) {
                proxGroups = new ArrayList<ArrayList<ProximityTerm>>();
            }
            proxGroups.add(proxGroup);
        }
        return proxGroups;
    }

    Term singleCharNgramWildcard(ExtendedTermQuery term) {
        String termText;
        int termLength;
        if (term.isWildcard() && term.isNgram() && (termLength = (termText = term.getTerm().text()).length()) > 1) {
            return new Term(term.getTerm().field(), termText.substring(0, termLength - 1));
        }
        return null;
    }

    Term termForSynonymExpansion(ExtendedBooleanClause clause) {
        if (clause.hasExplicitModifier()) {
            return null;
        }
        Query query = clause.getQuery();
        if (!(query instanceof EnhancedPhraseQuery)) {
            return null;
        }
        EnhancedPhraseQuery phraseQuery = (EnhancedPhraseQuery)query;
        if (phraseQuery.getSlop() != 0 || !phraseQuery.isAutoQuote()) {
            return null;
        }
        ArrayList<ExtendedTermQuery> terms = phraseQuery.getTerms();
        if (terms.size() != 1) {
            return null;
        }
        ExtendedTermQuery term = terms.get(0);
        if (this.isFilterTerm(term.getTerm())) {
            return null;
        }
        if (term.isWildcard()) {
            Term singleCharTerm = this.singleCharNgramWildcard(term);
            if (singleCharTerm != null) {
                return singleCharTerm;
            }
            return null;
        }
        return term.getTerm();
    }

    Term phraseForSynonymExpansion(ExtendedBooleanClause clause) {
        if (clause.hasExplicitModifier()) {
            return null;
        }
        Query query = clause.getQuery();
        if (!(query instanceof EnhancedPhraseQuery)) {
            return null;
        }
        EnhancedPhraseQuery phraseQuery = (EnhancedPhraseQuery)query;
        ArrayList<ExtendedTermQuery> terms = phraseQuery.getTerms();
        if (phraseQuery.isAutoQuote() && terms.size() < 2) {
            return null;
        }
        if (this.isFilterTerm(terms.get(0).getTerm())) {
            return null;
        }
        for (int i = 0; i < terms.size(); ++i) {
            Term singleCharTerm;
            if (!terms.get(i).isWildcard()) continue;
            if (terms.size() == 1 && (singleCharTerm = this.singleCharNgramWildcard(terms.get(i))) != null) {
                return singleCharTerm;
            }
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        ExtendedTermQuery term0 = terms.get(0);
        if (term0.isNgram()) {
            buffer.append(terms.get(0).getTerm().text().trim());
        } else {
            buffer.append(terms.get(0).getTerm().text());
        }
        boolean isPrevNgram = terms.get(0).isNgram();
        for (int i = 1; i < terms.size(); ++i) {
            ExtendedTermQuery term = terms.get(i);
            String termText = term.getTerm().text();
            if (term.isNgram()) {
                if (!isPrevNgram) {
                    buffer.append(termText.trim());
                } else {
                    buffer.append(termText.substring(termText.length() - 1).trim());
                }
                isPrevNgram = true;
                continue;
            }
            if (!isPrevNgram && term.isSeparated()) {
                buffer.append(" ");
            }
            buffer.append(termText);
            isPrevNgram = false;
        }
        return new Term(terms.get(0).getTerm().field(), buffer.toString());
    }

    private Vector expandSynonyms(Vector<BooleanClause> clauses) throws ParseException {
        int i;
        boolean[] mustRemove = new boolean[clauses.size()];
        SynonymIndexSearcher synSearcher = this.options.getSynonymIndexSearcher();
        for (i = 0; i < clauses.size(); ++i) {
            int j;
            Term term;
            int end;
            mustRemove[i] = false;
            ExtendedBooleanClause clauseAtI = (ExtendedBooleanClause)clauses.get(i);
            Term phrase = this.phraseForSynonymExpansion(clauseAtI);
            if (phrase != null) {
                String[] synonyms = synSearcher.getSynonyms(phrase.text());
                if (debug) {
                    System.out.print("synonym phrase candidate: \"" + phrase.text() + "\" -> [");
                    if (synonyms != null && synonyms.length > 0) {
                        for (int k = 0; k < synonyms.length; ++k) {
                            System.out.print("\"" + synonyms[k] + "\" ");
                        }
                    }
                    System.out.println("]");
                }
                if (synonyms == null || synonyms.length <= 0) continue;
                Vector<BooleanClause> expansionClauses = new Vector<BooleanClause>();
                for (int j2 = 0; j2 < synonyms.length; ++j2) {
                    Query synonymQuery = this.getSynonymQuery(phrase.field(), synonyms[j2], true);
                    if (synonymQuery == null) continue;
                    expansionClauses.add(new BooleanClause(synonymQuery, BooleanClause.Occur.SHOULD));
                    this.parsedQuery.getAddedSynonyms().add(synonyms[j2]);
                }
                if (expansionClauses.size() <= 0) continue;
                clauseAtI.setOccur(BooleanClause.Occur.SHOULD);
                expansionClauses.add(clauseAtI);
                Query expansion = super.getBooleanQuery(expansionClauses, false);
                clauses.set(i, new ExtendedBooleanClause(expansion, clauseAtI.getOccur(), clauseAtI.hasExplicitModifier()));
                continue;
            }
            Term firstTerm = this.termForSynonymExpansion(clauseAtI);
            if (firstTerm == null) continue;
            int begin = i;
            Term[] terms = new Term[clauses.size() - begin];
            terms[0] = firstTerm;
            for (end = i + 1; end < clauses.size() && (term = this.termForSynonymExpansion((ExtendedBooleanClause)clauses.get(end))) != null && term.field().equals(firstTerm.field()); ++end) {
                terms[end - begin] = term;
            }
            String[] termStrings = new String[end - begin];
            for (int j3 = 0; j3 < end - begin; ++j3) {
                termStrings[j3] = terms[j3].text();
            }
            int[] candLength = synSearcher.identifyCandidates(termStrings);
            boolean canMatch = false;
            for (int j4 = 0; j4 < end - begin; ++j4) {
                if (candLength[j4] <= 0) continue;
                canMatch = true;
                break;
            }
            if (!canMatch) {
                i = end - 1;
                continue;
            }
            int[] endPos = new int[candLength.length];
            StringBuffer buffer = new StringBuffer();
            for (j = 0; j < end - begin; ++j) {
                buffer.append(termStrings[j]);
                endPos[j] = buffer.length();
                buffer.append(' ');
            }
            if (debug) {
                System.out.print("synonym candidate: " + buffer.toString() + "- ");
                for (j = 0; j < end - begin; ++j) {
                    System.out.print(" " + terms[j].text() + "(" + candLength[j] + ")");
                }
                System.out.println();
            }
            block8: for (int current = 0; current < end - begin; ++current) {
                int startPos = current == 0 ? 0 : endPos[current - 1] + 1;
                int length = candLength[current];
                if (current + begin + length > end) {
                    length = end - begin - current;
                }
                while (length > 0) {
                    String candidate = buffer.substring(startPos, endPos[current + length - 1]);
                    String[] synonyms = synSearcher.getSynonyms(candidate, length == 1);
                    if (debug) {
                        System.out.print("  match on \"" + candidate + "\" -> [");
                        if (synonyms.length > 0) {
                            for (int k = 0; k < synonyms.length; ++k) {
                                System.out.print("\"" + synonyms[k] + "\" ");
                            }
                        }
                        System.out.println("]");
                    }
                    if (synonyms != null && synonyms.length > 0) {
                        Vector<BooleanClause> expansionClauses = new Vector<BooleanClause>();
                        for (int j5 = 0; j5 < synonyms.length; ++j5) {
                            Query synonymQuery = this.getSynonymQuery(firstTerm.field(), synonyms[j5], false);
                            if (synonymQuery == null) continue;
                            expansionClauses.add(new BooleanClause(synonymQuery, BooleanClause.Occur.SHOULD));
                            this.parsedQuery.getAddedSynonyms().add(synonyms[j5]);
                        }
                        if (expansionClauses.size() > 0) {
                            Vector<BooleanClause> replacementClauses = new Vector<BooleanClause>();
                            for (int j6 = current; j6 < current + length; ++j6) {
                                replacementClauses.addElement(clauses.get(begin + j6));
                            }
                            Query replacement = super.getBooleanQuery(replacementClauses, false);
                            expansionClauses.add(new BooleanClause(replacement, BooleanClause.Occur.SHOULD));
                            Query expansion = super.getBooleanQuery(expansionClauses, false);
                            clauses.set(begin + current, new ExtendedBooleanClause(expansion, clauseAtI.getOccur(), clauseAtI.hasExplicitModifier()));
                            for (int j7 = 1; j7 < length; ++j7) {
                                mustRemove[begin + current + j7] = true;
                            }
                            current += length - 1;
                            continue block8;
                        }
                    }
                    --length;
                }
            }
            i = end - 1;
        }
        for (i = clauses.size() - 1; i >= 0; --i) {
            if (!mustRemove[i]) continue;
            clauses.remove(i);
        }
        return clauses;
    }

    boolean isCandidateForSpellSequence(ExtendedBooleanClause clause) {
        if (clause.hasExplicitModifier()) {
            return false;
        }
        Query query = clause.getQuery();
        if (!(query instanceof EnhancedPhraseQuery)) {
            return false;
        }
        EnhancedPhraseQuery phrase = (EnhancedPhraseQuery)query;
        return !phrase.isFieldAttached();
    }

    ExtendedTermQuery termForSpellSuggestion(ExtendedBooleanClause clause) {
        if (clause.getOccur() == BooleanClause.Occur.MUST_NOT) {
            return null;
        }
        Query query = clause.getQuery();
        if (!(query instanceof EnhancedPhraseQuery)) {
            return null;
        }
        EnhancedPhraseQuery phrase = (EnhancedPhraseQuery)query;
        if (!phrase.isAutoQuote()) {
            return null;
        }
        ArrayList<ExtendedTermQuery> terms = phrase.getTerms();
        if (terms.size() != 1) {
            return null;
        }
        ExtendedTermQuery term = (ExtendedTermQuery)((Object)terms.get(0));
        if (this.isFilterTerm(term.getTerm())) {
            return null;
        }
        if (term.isWildcard()) {
            return null;
        }
        return term;
    }

    EnhancedPhraseQuery phraseForSpellSuggestion(ExtendedBooleanClause clause) {
        if (clause.getOccur() == BooleanClause.Occur.MUST_NOT) {
            return null;
        }
        Query query = clause.getQuery();
        if (!(query instanceof EnhancedPhraseQuery)) {
            return null;
        }
        EnhancedPhraseQuery phrase = (EnhancedPhraseQuery)query;
        if (phrase.isAutoQuote()) {
            return null;
        }
        ArrayList<ExtendedTermQuery> terms = phrase.getTerms();
        if (terms.size() < 1) {
            return null;
        }
        ExtendedTermQuery term = (ExtendedTermQuery)((Object)terms.get(0));
        if (this.isFilterTerm(term.getTerm())) {
            return null;
        }
        return phrase;
    }

    boolean findSpellSuggestions(Vector<ExtendedBooleanClause> clauses) {
        ArrayList<ExtendedTermQuery> termsForSpell = new ArrayList<ExtendedTermQuery>();
        boolean suggestionFound = false;
        for (int current = 0; current < clauses.size(); ++current) {
            ExtendedBooleanClause clause = clauses.get(current);
            EnhancedPhraseQuery phrase = this.phraseForSpellSuggestion(clause);
            if (phrase != null) {
                ArrayList<ExtendedTermQuery> terms = phrase.getTerms();
                for (int i = 0; i < terms.size(); ++i) {
                    termsForSpell.clear();
                    while (i < terms.size() && !((ExtendedTermQuery)((Object)terms.get(i))).isWildcard()) {
                        termsForSpell.add((ExtendedTermQuery)((Object)terms.get(i)));
                        ++i;
                    }
                    if (!termsForSpell.isEmpty() && (suggestionFound = this.spellSuggestSequence(termsForSpell))) break;
                }
                if (!suggestionFound) continue;
                break;
            }
            ExtendedTermQuery term = this.termForSpellSuggestion(clause);
            if (term == null) continue;
            termsForSpell.clear();
            termsForSpell.add(term);
            if (this.isCandidateForSpellSequence(clause)) {
                ExtendedTermQuery nextTerm;
                ExtendedBooleanClause nextClause;
                while (current + 1 < clauses.size() && this.isCandidateForSpellSequence(nextClause = clauses.get(current + 1)) && (nextTerm = this.termForSpellSuggestion(nextClause)) != null && term.getTerm().field().equals(nextTerm.getTerm().field())) {
                    termsForSpell.add(nextTerm);
                    ++current;
                }
            }
            if (suggestionFound = this.spellSuggestSequence(termsForSpell)) break;
        }
        return suggestionFound;
    }

    boolean spellSuggestSequence(List<ExtendedTermQuery> terms) {
        if (terms.get(terms.size() - 1).getEnd() <= this.parsedQuery.getQueryString().length()) {
            this.parsedQuery.getSpellSuggestionCandidates().add(new SpellSuggestionCandidate(terms.get(0).getTerm().field(), terms));
        }
        return false;
    }

    protected Query handleSingleTerm(Query query) throws ParseException {
        if (query instanceof EnhancedPhraseQuery) {
            EnhancedPhraseQuery phrase = (EnhancedPhraseQuery)query;
            Vector<ExtendedBooleanClause> clauses = new Vector<ExtendedBooleanClause>();
            clauses.addElement(new ExtendedBooleanClause(phrase, BooleanClause.Occur.MUST, false));
            return this.getBooleanQuery(clauses);
        }
        return query;
    }

    private boolean hasSufficient(ExtendedTermQuery q, boolean inPhrase) {
        if (q.isWildcard()) {
            return !WildcardPhraseQuery.isPureWildcard(q.getTerm());
        }
        if (this.isFilterTerm(q.getTerm())) {
            return true;
        }
        return inPhrase || !q.isStopword() || q.isAllUpper();
    }

    private boolean hasSufficient(EnhancedPhraseQuery q) {
        ArrayList<ExtendedTermQuery> terms = q.getTerms();
        boolean inPhrase = !q.isAutoQuote() || terms.size() > 1;
        for (int i = 0; i < terms.size(); ++i) {
            if (!this.hasSufficient(terms.get(i), inPhrase)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSufficient(BooleanQuery q) {
        BooleanClause[] clauses = q.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            BooleanClause clause = clauses[i];
            if (clause.getOccur() == BooleanClause.Occur.MUST_NOT) continue;
            if (clause instanceof ExtendedBooleanClause && ((ExtendedBooleanClause)clause).hasExplicitModifier()) {
                return true;
            }
            Query cq = clause.getQuery();
            if (!this.hasSufficient(cq)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSufficient(Query q) {
        if (q instanceof MarkupContainsQuery) {
            return true;
        }
        if (q instanceof BooleanQuery) {
            return this.hasSufficient((BooleanQuery)q);
        }
        if (q instanceof EnhancedPhraseQuery) {
            return this.hasSufficient((EnhancedPhraseQuery)q);
        }
        if (q instanceof ExtendedTermQuery) {
            return this.hasSufficient((ExtendedTermQuery)q, false);
        }
        return !(q instanceof MatchNoDocsQuery);
    }

    private boolean isIgnored(ExtendedTermQuery q, boolean removeStopwords) {
        if (this.isFilterTerm(q.getTerm())) {
            return false;
        }
        return removeStopwords && q.isStopword() && !q.isAllUpper();
    }

    private boolean mustLemmatize(ExtendedTermQuery q, boolean lemmatize) {
        if (!lemmatize) {
            return false;
        }
        if (this.isFilterTerm(q.getTerm())) {
            return false;
        }
        if (this.isExactTerm(q.getTerm())) {
            return false;
        }
        return q.mustLemmatize();
    }

    private void addSiteHighlighting(Term term) throws ParseException {
        ArrayList<ExtendedTermQuery> siteTerms = new ArrayList<ExtendedTermQuery>();
        Tokenizer tokenizer = null;
        try {
            tokenizer = this.options.getTokenizerPool().aquire(this.options.getCollectionConfig().getId());
            tokenizer.process(new QueryTokenizationHandler("site", 0, siteTerms, false), new TokenizerProcessInput(term.text(), null, this.options.getQueryLanguage()));
        }
        catch (TokenizerException e) {
            ParseException pe = new ParseException("Tokenization of site term \"" + term.text() + "\" failed. ");
            pe.initCause((Throwable)e);
            throw pe;
        }
        finally {
            if (tokenizer != null) {
                this.options.getTokenizerPool().release(tokenizer);
            }
        }
        if (siteTerms.size() == 0) {
            return;
        }
        ArrayList<HighlightTerm> highlightTerms = new ArrayList<HighlightTerm>();
        for (int i = 0; i < siteTerms.size(); ++i) {
            highlightTerms.add(new HighlightTerm(siteTerms.get(i).getTerm(), null, siteTerms.get(i).isWildcard()));
        }
        if (highlightTerms.size() > 0) {
            this.parsedQuery.getTermsForSummarizer("url").addPhrase(highlightTerms);
        }
    }

    private Query postProcess(ExtendedTermQuery q, boolean removeStopwords, boolean lemmatize, boolean collectForQuicklinks, boolean collectTerms) throws ParseException {
        if (this.isIgnored(q, removeStopwords)) {
            this.parsedQuery.getRemovedStopwords().add(q.getTerm());
            return null;
        }
        if (q.isWildcard() && WildcardPhraseQuery.isPureWildcard(q.getTerm())) {
            return null;
        }
        Term term = q.getTerm();
        boolean mustLemmatize = this.mustLemmatize(q, lemmatize);
        boolean curTermIsFilterTerm = this.isFilterTerm(term);
        if (collectTerms) {
            HighlightTerm highlightTerm = new HighlightTerm(term, mustLemmatize ? q.getLemmas() : null, q.isWildcard());
            if (this.fieldConfig.isTextSearchable(term.field())) {
                for (String textSearchableField : this.fieldConfig.getTextSearchableFields()) {
                    this.parsedQuery.getTermsForSummarizer(textSearchableField).addSingleTerm(highlightTerm);
                }
            } else if (term.field().equals("fileext")) {
                this.parsedQuery.getTermsForSummarizer("url").addSingleTerm(highlightTerm);
            } else if (term.field().equals("site")) {
                this.addSiteHighlighting(term);
            } else {
                this.parsedQuery.getTermsForSummarizer(term.field()).addSingleTerm(highlightTerm);
            }
        }
        if (collectForQuicklinks && !curTermIsFilterTerm) {
            Term qlTerm = term;
            if (q.isWildcard()) {
                qlTerm = this.singleCharNgramWildcard(q);
            }
            if (qlTerm != null) {
                this.parsedQuery.getTermsForQuicklinks().add(qlTerm);
            }
        }
        if (curTermIsFilterTerm) {
            this.parsedQuery.getFilterTerms().add(term);
        }
        if (q.isWildcard()) {
            return new NoLemmaWildcardQuery(term);
        }
        if (!mustLemmatize) {
            return new TermQuery(term);
        }
        BooleanQuery boolQuery = new BooleanQuery(false);
        boolQuery.add(new BooleanClause((Query)q, BooleanClause.Occur.SHOULD));
        for (Term lemma : q.computeLemmaTerms()) {
            boolQuery.add(new BooleanClause((Query)new TermQuery(lemma), BooleanClause.Occur.SHOULD));
        }
        return boolQuery;
    }

    private Query postProcess(NoLemmaWildcardQuery q) throws ParseException {
        Term term = q.getTerm();
        if (this.isFilterTerm(term)) {
            this.parsedQuery.getFilterTerms().add(term);
        }
        if (this.isExactTerm(term)) {
            if ("site".equals(term.field())) {
                this.addSiteHighlighting(term);
            } else if ("fileext".equals(term.field())) {
                this.parsedQuery.getTermsForSummarizer("url").addSingleTerm(new HighlightTerm(term, null, true));
            } else {
                this.parsedQuery.getTermsForSummarizer(term.field()).addSingleTerm(new HighlightTerm(term, null, true));
            }
        }
        return q;
    }

    private Query postProcess(NegatedQuery q, boolean lemmatize) throws ParseException {
        return new NegatedQuery(this.postProcess(q.getQuery(), false, lemmatize, false));
    }

    private boolean postProcess(WildcardPhraseQuery phrase, ExtendedTermQuery q, boolean removeStopwords, boolean lemmatize, List<HighlightTerm> termsToCollect) {
        if (this.isIgnored(q, removeStopwords)) {
            this.parsedQuery.getRemovedStopwords().add(q.getTerm());
            return false;
        }
        Term term = q.getTerm();
        boolean mustLemmatize = this.mustLemmatize(q, lemmatize);
        if (q.isWildcard()) {
            phrase.addWildcard(term);
        } else if (!mustLemmatize) {
            phrase.add(term);
        } else {
            Term[] terms = q.computeTerms();
            phrase.add(terms);
        }
        if (termsToCollect != null) {
            termsToCollect.add(new HighlightTerm(term, mustLemmatize ? q.getLemmas() : null, q.isWildcard()));
        }
        if (this.isFilterTerm(term)) {
            this.parsedQuery.getFilterTerms().add(term);
            return false;
        }
        return true;
    }

    private Query postProcess(EnhancedPhraseQuery q, boolean removeStopwords, boolean lemmatize, boolean collectTerms) throws ParseException {
        if (!q.isAutoQuote()) {
            lemmatize = false;
            removeStopwords = false;
        }
        Query newQuery = null;
        ArrayList<ExtendedTermQuery> terms = q.getTerms();
        ArrayList<HighlightTerm> termsToCollect = collectTerms ? new ArrayList<HighlightTerm>() : null;
        boolean collectForQuickLinks = collectTerms && !q.isSynonym();
        int numTerms = terms.size();
        if (numTerms == 1) {
            newQuery = this.postProcess(terms.get(0), removeStopwords, lemmatize, collectForQuickLinks, collectTerms);
        } else {
            WildcardPhraseQuery phrase = new WildcardPhraseQuery();
            StringBuilder buffer = new StringBuilder();
            boolean prevWasNgram = false;
            String field = null;
            for (int i = 0; i < numTerms; ++i) {
                boolean collectThisTerm = this.postProcess(phrase, terms.get(i), false, lemmatize, termsToCollect);
                if (!collectThisTerm) continue;
                ExtendedTermQuery termI = terms.get(i);
                field = termI.getTerm().field();
                if (!collectForQuickLinks) continue;
                if (termI.isSeparated() && buffer.length() > 0) {
                    this.parsedQuery.getTermsForQuicklinks().add(new Term(termI.getTerm().field(), buffer.toString()));
                    buffer.setLength(0);
                    prevWasNgram = false;
                }
                if (termI.isWildcard()) {
                    prevWasNgram = false;
                    continue;
                }
                if (termI.isNgram()) {
                    String termText = termI.getTerm().text();
                    if (prevWasNgram) {
                        buffer.append(termText.substring(termText.length() - 1, termText.length()).trim());
                        continue;
                    }
                    buffer.append(termText.trim());
                    prevWasNgram = true;
                    continue;
                }
                buffer.append(termI.getTerm().text());
                prevWasNgram = true;
            }
            if (buffer.length() > 0) {
                this.parsedQuery.getTermsForQuicklinks().add(new Term(field, buffer.toString()));
            }
            if (!phrase.isEmpty()) {
                phrase.setSlop(q.getSlop());
                newQuery = phrase.rewrite();
            } else {
                newQuery = null;
            }
        }
        if (collectTerms && termsToCollect.size() > 0) {
            String field = ((HighlightTerm)termsToCollect.get(0)).getField();
            if (this.fieldConfig.isTextSearchable(field)) {
                for (String textSearchableField : this.fieldConfig.getTextSearchableFields()) {
                    this.parsedQuery.getTermsForSummarizer(textSearchableField).addPhrase(termsToCollect);
                }
            } else if (field.equals("fileext") || field.equals("site")) {
                this.parsedQuery.getTermsForSummarizer("url").addPhrase(termsToCollect);
            } else {
                this.parsedQuery.getTermsForSummarizer(field).addPhrase(termsToCollect);
            }
        }
        if (newQuery != null) {
            newQuery.setBoost(q.getBoost());
        }
        return newQuery;
    }

    private Query postProcess(BooleanQuery query, boolean removeStopwords, boolean lemmatize, boolean collectTerms) throws ParseException {
        BooleanClause clause;
        int i;
        BooleanQuery newQuery = new BooleanQuery();
        BooleanClause[] clauses = query.getClauses();
        int numParametric = 0;
        for (i = 0; i < clauses.length; ++i) {
            Query newClauseQuery;
            clause = clauses[i];
            Query clauseQuery = clause.getQuery();
            BooleanClause.Occur occur = clause.getOccur();
            boolean removeStopwords1 = removeStopwords;
            boolean collectTerms1 = collectTerms;
            if (occur == BooleanClause.Occur.MUST_NOT) {
                removeStopwords1 = false;
                collectTerms1 = false;
            }
            if (clause instanceof ExtendedBooleanClause && ((ExtendedBooleanClause)clause).hasExplicitModifier()) {
                removeStopwords1 = false;
            }
            if ((newClauseQuery = this.postProcess(clauseQuery, removeStopwords1, lemmatize, collectTerms1)) instanceof ParametricQuery && occur == BooleanClause.Occur.MUST) {
                ++numParametric;
            }
            if (newClauseQuery == null) continue;
            if (newClauseQuery instanceof MatchNoDocsQuery) {
                if (occur != BooleanClause.Occur.MUST) continue;
                return newClauseQuery;
            }
            BooleanClause newClause = new BooleanClause(newClauseQuery, occur);
            newQuery.add(newClause);
        }
        if (newQuery.getClauses().length == 0) {
            return null;
        }
        if (numParametric >= 2) {
            clauses = newQuery.getClauses();
            newQuery = new BooleanQuery();
            for (i = 0; i < clauses.length; ++i) {
                clause = clauses[i];
                if (!(clause.getQuery() instanceof ParametricQuery) || clause.getOccur() != BooleanClause.Occur.MUST || i + 1 >= clauses.length) {
                    newQuery.add(clause);
                    continue;
                }
                BooleanClause nextClause = clauses[i + 1];
                if (!(nextClause.getQuery() instanceof ParametricQuery) || nextClause.getOccur() != BooleanClause.Occur.MUST) {
                    newQuery.add(clause);
                    newQuery.add(nextClause);
                    ++i;
                    continue;
                }
                ParametricQuery q1 = (ParametricQuery)clause.getQuery();
                ParametricQuery q2 = (ParametricQuery)nextClause.getQuery();
                if (!q1.getField().equals(q2.getField())) {
                    newQuery.add(clause);
                    continue;
                }
                DecimalRange range = null;
                DecimalCondition cond1 = q1.getCondition();
                DecimalCondition cond2 = q2.getCondition();
                if (cond1 instanceof DecimalLower && cond2 instanceof DecimalUpper) {
                    range = new DecimalRange((DecimalLower)cond1, (DecimalUpper)cond2);
                } else if (cond2 instanceof DecimalLower && cond1 instanceof DecimalUpper) {
                    range = new DecimalRange((DecimalLower)cond2, (DecimalUpper)cond1);
                }
                if (range == null) {
                    newQuery.add(clause);
                    continue;
                }
                ParametricQuery rangeQuery = new ParametricQuery(q1.getField(), range);
                newQuery.add((Query)rangeQuery, BooleanClause.Occur.MUST);
                ++i;
            }
        }
        newQuery.setBoost(query.getBoost());
        if (query instanceof ExtendedBooleanQuery) {
            List<List<ProximityTerm>> proxGroups = ((ExtendedBooleanQuery)query).getProximityTerms();
            ArrayList termGroups = null;
            if (proxGroups != null) {
                for (int i2 = 0; i2 < proxGroups.size(); ++i2) {
                    List<ProximityTerm> group = proxGroups.get(i2);
                    ArrayList<Term[]> termGroup = new ArrayList<Term[]>();
                    for (int j = 0; j < group.size(); ++j) {
                        Term[] term = group.get(j).computeTerm(removeStopwords, lemmatize);
                        if (term == null) continue;
                        termGroup.add(term);
                    }
                    if (termGroup.size() <= 1) continue;
                    if (termGroups == null) {
                        termGroups = new ArrayList();
                    }
                    termGroups.add(termGroup);
                }
            }
            if (termGroups != null) {
                ProximityQuery proxQuery = new ProximityQuery();
                for (int i3 = 0; i3 < termGroups.size(); ++i3) {
                    proxQuery.addTermGroup((List)termGroups.get(i3));
                }
                proxQuery.setTextQuery((Query)newQuery);
                return proxQuery;
            }
        }
        return newQuery;
    }

    private Query postProcess(Query q, boolean removeStopwords, boolean lemmatize, boolean collectTerms) throws ParseException {
        if (q instanceof MarkupContainsQuery) {
            return q;
        }
        if (q instanceof BooleanQuery) {
            return this.postProcess((BooleanQuery)q, removeStopwords, lemmatize, collectTerms);
        }
        if (q instanceof EnhancedPhraseQuery) {
            return this.postProcess((EnhancedPhraseQuery)q, removeStopwords, lemmatize, collectTerms);
        }
        if (q instanceof NoLemmaWildcardQuery) {
            return this.postProcess((NoLemmaWildcardQuery)q);
        }
        if (q instanceof NegatedQuery) {
            return this.postProcess((NegatedQuery)q, lemmatize);
        }
        return q;
    }

    private Query postProcess(Query q) throws ParseException {
        q = this.handleSingleTerm(q);
        boolean removeStopwords = this.hasSufficient(q);
        if ((q = this.postProcess(q, removeStopwords, true, true)) instanceof MatchNoDocsQuery) {
            return null;
        }
        return q;
    }

    static boolean requiresTermHit(Query q) {
        if (q instanceof BooleanQuery) {
            boolean hasProblemClause = false;
            for (Object object : ((BooleanQuery)q).clauses()) {
                BooleanClause clause = (BooleanClause)object;
                if (clause.getOccur() == BooleanClause.Occur.MUST_NOT) continue;
                if (!LinguisticQueryParser.requiresTermHit(clause.getQuery())) {
                    hasProblemClause = true;
                    continue;
                }
                if (clause.getOccur() != BooleanClause.Occur.MUST) continue;
                return true;
            }
            return !hasProblemClause;
        }
        return !(q instanceof NegatedQuery);
    }

    @Override
    public Query parse(String query) throws ParseException {
        Query q = this.postProcess(super.parse(query));
        if (q != null) {
            if (this.securityConstraint != null || this.languageConstraint != null || this.scalarConstraint != null) {
                BooleanQuery boolQuery = new BooleanQuery(true);
                boolQuery.add(new BooleanClause(q, BooleanClause.Occur.MUST));
                if (this.languageConstraint != null) {
                    boolQuery.add(this.languageConstraint, BooleanClause.Occur.MUST);
                }
                if (this.scalarConstraint != null) {
                    boolQuery.add(this.scalarConstraint, BooleanClause.Occur.MUST);
                }
                if (this.securityConstraint != null) {
                    boolQuery.add(this.securityConstraint, BooleanClause.Occur.MUST);
                }
                q = boolQuery;
            } else if (!LinguisticQueryParser.requiresTermHit(q)) {
                BooleanQuery boolQuery = new BooleanQuery();
                boolQuery.add(q, BooleanClause.Occur.MUST);
                TermQuery termQuery = new TermQuery(DocumentStatus.SUCCESS_TERM);
                termQuery.setBoost(0.0f);
                boolQuery.add((Query)termQuery, BooleanClause.Occur.MUST);
                q = boolQuery;
            }
            if (this.isStaticScoringEnabled()) {
                q = new StaticScoreQuery(q);
            }
            if (this.earlyTerminationTimeout > 0L) {
                q = new EarlyTerminationQuery(q, this.earlyTerminationTimeout, this.parsedQuery.getEarlyTerminationIndicator());
            }
        }
        return q;
    }

    public ParsedQuery parseAndExtract(String queryString, String qLanguage, Properties queryProps) throws ParseException {
        this.options.setQueryProperties(queryProps);
        this.options.setQueryLanguage(qLanguage);
        queryString = new NormalizedStringBufferType1().append(queryString).toString();
        this.parsedQuery = new ParsedQuery(queryString);
        if (queryProps != null) {
            String synonymExpansion;
            String staticScoring;
            String proximityScoring;
            String languageFilter = queryProps.getProperty("languageFilter");
            this.setLanguageConstraint(languageFilter);
            if (debug) {
                System.out.println("LinguisticQueryParser: languageConstraint = " + this.languageConstraint);
            }
            String scalarFilter = queryProps.getProperty("scalarFilter");
            this.setScalarConstraint(scalarFilter);
            if (debug) {
                System.out.println("LinguisticQueryParser: scalarConstraint = " + this.scalarConstraint);
            }
            if ((proximityScoring = queryProps.getProperty("proximityScoring")) != null) {
                this.setProximityScoringEnabled(Boolean.valueOf(proximityScoring));
            }
            if ((staticScoring = queryProps.getProperty("staticScoring")) != null) {
                this.setStaticScoringEnabled(Boolean.valueOf(staticScoring));
            }
            if ((synonymExpansion = queryProps.getProperty("synonymExpansion")) != null) {
                this.setSynonymExpansionEnabled(Boolean.valueOf(synonymExpansion));
            }
            this.earlyTerminationTimeout = -1L;
            String earlyTermination = queryProps.getProperty("earlyTerminationTimeout");
            if (earlyTermination != null) {
                try {
                    this.earlyTerminationTimeout = Long.valueOf(earlyTermination);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (this.earlyTerminationTimeout == -1L) {
                this.earlyTerminationTimeout = this.options.getCollectionConfig().getQueryTimeout();
            }
        }
        Query q = this.parse(queryString);
        this.parsedQuery.setQuery(q);
        if (debug) {
            System.out.println("LinguisticQueryParser: parsedQuery = " + this.parsedQuery.getQuery());
        }
        return this.parsedQuery;
    }

    public LinguisticQueryParser(TokenizerPool pool, SynonymIndexSearcher synonymSearcher, CollectionConfiguration collectionConfig, UserSecurityContext securityContext, String fieldName) {
        super(fieldName != null ? fieldName : "_plain", dummyAnalyzer);
        this.options.setTokenizerPool(pool != null ? pool : GlobalSystem.getSingleInstance().getRuntimeTokenizerPool());
        this.options.setCollectionConfig(collectionConfig);
        this.setDefaultOperator(QueryParser.Operator.AND);
        this.options.setSynonymIndexSearcher(synonymSearcher);
        this.enableProximity = collectionConfig.getProximityScoring();
        this.enableStaticScore = true;
        this.fieldConfig = new QueryFieldConfiguration(collectionConfig);
        this.securityConstraint = collectionConfig.isSecureSearch() && collectionConfig.isSecureSearchPreFilter() ? QueryBuilder.buildSecurity(securityContext) : null;
    }

    public static class Options {
        private CollectionConfiguration collectionConfig;
        private TokenizerPool tokenizerPool;
        private SynonymIndexSearcher synonymIndexSearcher;
        private Properties queryProperties;
        private String queryLanguage;

        public CollectionConfiguration getCollectionConfig() {
            return this.collectionConfig;
        }

        public TokenizerPool getTokenizerPool() {
            return this.tokenizerPool;
        }

        public SynonymIndexSearcher getSynonymIndexSearcher() {
            return this.synonymIndexSearcher;
        }

        public Properties getQueryProperties() {
            return this.queryProperties;
        }

        public String getQueryLanguage() {
            return this.queryLanguage;
        }

        public void setCollectionConfig(CollectionConfiguration config) {
            this.collectionConfig = config;
        }

        public void setTokenizerPool(TokenizerPool tokenizerPool) {
            this.tokenizerPool = tokenizerPool;
        }

        public void setSynonymIndexSearcher(SynonymIndexSearcher synonymIndexSearcher) {
            this.synonymIndexSearcher = synonymIndexSearcher;
        }

        public void setQueryProperties(Properties queryProperties) {
            this.queryProperties = queryProperties;
        }

        public void setQueryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
        }

        public Options cloneForXPath() {
            Options options = new Options();
            options.setCollectionConfig(this.getCollectionConfig());
            options.setTokenizerPool(this.getTokenizerPool());
            options.setSynonymIndexSearcher(this.getSynonymIndexSearcher());
            options.setQueryLanguage(this.getQueryLanguage());
            Properties newProperties = (Properties)this.getQueryProperties().clone();
            newProperties.setProperty("earlyTerminationTimeout", "0");
            newProperties.setProperty("staticScoring", Boolean.toString(false));
            newProperties.remove("languageFilter");
            newProperties.remove("scalarFilter");
            newProperties.setProperty("disableSummarizer", Boolean.toString(true));
            options.setQueryProperties(newProperties);
            return options;
        }
    }
}

