/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType2;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;

public class ExtendedTermQuery
extends TermQuery {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 1L;
    private String[] lemmas;
    private boolean stopword;
    private boolean allUpper;
    private boolean separated;
    private boolean wildcard;
    private boolean ngram;
    private int begin = -1;
    private int end = -1;

    public ExtendedTermQuery(String field, String term) {
        super(new Term(field, term));
        this.lemmas = null;
        this.stopword = false;
        this.allUpper = false;
        this.separated = false;
        this.ngram = false;
    }

    public ExtendedTermQuery(String field, String term, String[] lemmas, boolean isStopword, boolean isAllUpper, boolean isSeparated, boolean isNgram) {
        super(new Term(field, new NormalizedStringBufferType2().append(term).toString()));
        if (lemmas != null) {
            for (int i = 0; i < lemmas.length; ++i) {
                lemmas[i] = new NormalizedStringBufferType2().append(lemmas[i]).append('\u0001').toString();
            }
        }
        this.lemmas = lemmas;
        this.stopword = isStopword;
        this.allUpper = isAllUpper;
        this.separated = isSeparated;
        this.ngram = isNgram;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean hasLemma() {
        return this.lemmas != null && this.lemmas.length > 0;
    }

    public String[] getLemmas() {
        if (this.hasLemma()) {
            return this.lemmas;
        }
        return null;
    }

    public boolean isStopword() {
        return this.stopword;
    }

    public boolean isAllUpper() {
        return this.allUpper;
    }

    public boolean isSeparated() {
        return this.separated;
    }

    public void setSeparated(boolean isSeparated) {
        this.separated = isSeparated;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public void setWildcard(boolean isWildcard) {
        this.wildcard = isWildcard;
    }

    public boolean isNgram() {
        return this.ngram;
    }

    public void setNgram(boolean isNgram) {
        this.ngram = isNgram;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append('[');
        if (this.lemmas != null) {
            for (int i = 0; i < this.lemmas.length; ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(this.lemmas[i]);
            }
            buffer.append('|');
        }
        if (this.begin >= 0) {
            buffer.append(this.begin);
            buffer.append("..");
            buffer.append(this.end);
            buffer.append("|");
        }
        if (this.stopword) {
            buffer.append("S");
        }
        if (this.allUpper) {
            buffer.append("U");
        }
        if (this.wildcard) {
            buffer.append("W");
        }
        if (this.ngram) {
            buffer.append("N");
        }
        if (this.separated) {
            buffer.append(" ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    public boolean mustLemmatize() {
        return this.hasLemma() && !this.isWildcard() && !this.isStopword() && !this.isAllUpper();
    }

    public Term[] computeLemmaTerms() {
        String field = this.getTerm().field();
        Term[] lemmaTerms = new Term[this.lemmas.length];
        for (int i = 0; i < lemmaTerms.length; ++i) {
            lemmaTerms[i] = new Term(field, this.lemmas[i]);
        }
        return lemmaTerms;
    }

    public Term[] computeTerms() {
        String field = this.getTerm().field();
        Term[] terms = new Term[this.lemmas.length + 1];
        terms[0] = this.getTerm();
        for (int i = 1; i < terms.length; ++i) {
            terms[i] = new Term(field, this.lemmas[i - 1]);
        }
        return terms;
    }
}

