/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.search.query.ExtendedTermQuery;
import java.util.ArrayList;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedPhraseQuery
extends Query {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 1L;
    private ArrayList<ExtendedTermQuery> terms;
    private int slop;
    private boolean autoQuote;
    private boolean synonym;
    private boolean attached;

    public EnhancedPhraseQuery(ArrayList<ExtendedTermQuery> terms, boolean attached) {
        this.terms = terms;
        this.slop = 0;
        this.autoQuote = true;
        this.synonym = false;
        this.attached = attached;
    }

    public boolean isFieldAttached() {
        return this.attached;
    }

    public boolean isSynonym() {
        return this.synonym;
    }

    public void setSynonym() {
        this.synonym = true;
    }

    public boolean isAutoQuote() {
        return this.autoQuote;
    }

    public void setSlop(int slop) {
        this.slop = slop;
        this.autoQuote = false;
    }

    public int getSlop() {
        return this.slop;
    }

    public ArrayList<ExtendedTermQuery> getTerms() {
        return this.terms;
    }

    public String toString(String defaultField) {
        return this.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.autoQuote) {
            buffer.append("(a)");
        }
        buffer.append("\"");
        for (int i = 0; i < this.terms.size(); ++i) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(this.terms.get(i).toString());
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append('~');
            buffer.append(this.slop);
        }
        return buffer.toString();
    }
}

