/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.query;

import com.ibm.es.nuvo.search.query.EarlyTerminationIndicator;
import com.ibm.es.nuvo.search.query.MatchNoDocsQuery;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class EarlyTerminationQuery
extends Query {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    EarlyTerminationIndicator terminatedEarly;
    long timeoutMillis;
    static final int checkInterval = 1000;
    private static final long serialVersionUID = 1L;
    private Query textQuery;

    public EarlyTerminationQuery(Query query, long timeoutMilliSecs, EarlyTerminationIndicator indicator) {
        this.textQuery = query;
        this.timeoutMillis = timeoutMilliSecs;
        this.terminatedEarly = indicator;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('<');
        buffer.append(this.timeoutMillis);
        buffer.append(" ms>");
        buffer.append(this.textQuery);
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof EarlyTerminationQuery)) {
            return false;
        }
        EarlyTerminationQuery other = (EarlyTerminationQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.textQuery.equals(other.textQuery);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        Weight textWeight = this.textQuery.weight(searcher);
        return new EarlyTerminationWeight(searcher, textWeight);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrittenTextQuery = this.textQuery.rewrite(reader);
        if (rewrittenTextQuery == null) {
            return new MatchNoDocsQuery();
        }
        if (rewrittenTextQuery != this.textQuery) {
            EarlyTerminationQuery rewrittenQuery = new EarlyTerminationQuery(rewrittenTextQuery, this.timeoutMillis, this.terminatedEarly);
            rewrittenQuery.setBoost(this.getBoost());
            return rewrittenQuery;
        }
        return this;
    }

    private class EarlyTerminationWeight
    implements Weight {
        private static final long serialVersionUID = 1L;
        private Searcher searcher;
        private Weight textWeight;

        public EarlyTerminationWeight(Searcher searcher, Weight textWeight) {
            this.searcher = searcher;
            this.textWeight = textWeight;
        }

        public String toString() {
            return this.textWeight.toString();
        }

        public Query getQuery() {
            return EarlyTerminationQuery.this;
        }

        public float getValue() {
            return this.textWeight.getValue();
        }

        public float sumOfSquaredWeights() throws IOException {
            float boost = EarlyTerminationQuery.this.getBoost();
            return boost * boost * this.textWeight.sumOfSquaredWeights();
        }

        public void normalize(float norm) {
            this.textWeight.normalize(norm);
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            Scorer textScorer = this.textWeight.scorer(reader);
            return new EarlyTerminationScorer(EarlyTerminationQuery.this.getSimilarity(this.searcher), textScorer);
        }

        public Explanation explain(IndexReader reader, int doc) {
            Explanation queryExpl = new Explanation();
            queryExpl.setDescription("EarlyTerminationQuery, timeout is:");
            queryExpl.setValue((float)EarlyTerminationQuery.this.timeoutMillis);
            if (EarlyTerminationQuery.this.getBoost() != 1.0f) {
                queryExpl.addDetail(new Explanation(EarlyTerminationQuery.this.getBoost(), "boost"));
            }
            return queryExpl;
        }
    }

    private class EarlyTerminationScorer
    extends Scorer {
        long timeoutNanoTime;
        int nextToCheck;
        int currentDoc;
        private Scorer textScorer;

        EarlyTerminationScorer(Similarity similarity, Scorer textScorer) {
            super(similarity);
            this.nextToCheck = 1000;
            this.currentDoc = 0;
            this.textScorer = textScorer;
            this.timeoutNanoTime = System.nanoTime() + 1000000L * EarlyTerminationQuery.this.timeoutMillis;
            this.nextToCheck = 1000;
        }

        private boolean checkTimeout() {
            if (this.currentDoc >= this.nextToCheck) {
                this.nextToCheck = this.currentDoc + 1000;
                if (System.nanoTime() >= this.timeoutNanoTime) {
                    EarlyTerminationQuery.this.terminatedEarly.set(true);
                    return false;
                }
            }
            return true;
        }

        public boolean next() throws IOException {
            if (this.checkTimeout() && this.textScorer.next()) {
                this.currentDoc = this.textScorer.doc();
                return true;
            }
            return false;
        }

        public boolean skipTo(int target) throws IOException {
            if (this.checkTimeout() && this.textScorer.skipTo(target)) {
                this.currentDoc = this.textScorer.doc();
                return true;
            }
            return false;
        }

        public int doc() {
            return this.currentDoc;
        }

        public float score() throws IOException {
            return this.textScorer.score();
        }

        public Explanation explain(int doc) {
            return null;
        }
    }
}

