/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.prefs;

import com.ibm.es.nuvo.common.search.app.beans.BasePreferencesBean;
import com.ibm.es.nuvo.search.prefs.MultiValuedPreference;
import com.ibm.es.nuvo.search.prefs.Preference;
import com.ibm.es.nuvo.search.prefs.SimplePreference;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class SearchPreferences
extends BasePreferencesBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Hashtable<String, Preference> preferencesMap;
    private static final String interfaceLanguagePreferenceName = "IL";
    private static final String queryLanguagePreferenceName = "QL";
    private static final String filterLanguagesPreferenceName = "FL";
    private static final String languageFilterOptionPreferenceName = "FO";
    private static final String prefsCookieName = "_prefs";
    private static final String defaultLanguage = "en_US";
    private static final String defaultFilterOption = "0";
    private static final int SECONDS_IN_A_YEAR = 31536000;
    private static final int cookieAge = 630720000;
    private static final long serialVersionUID = -3059429335248939101L;

    public SearchPreferences() {
        this.buildPreferencesMap();
        this.invokeSetters();
    }

    public void set(Cookie preferencesCookie) {
        this.initPreferences(preferencesCookie);
    }

    public Cookie getPrefsCookie() {
        StringBuilder sb = new StringBuilder();
        sb.append(interfaceLanguagePreferenceName);
        sb.append("=");
        sb.append(":");
        sb.append(queryLanguagePreferenceName);
        sb.append("=");
        String queryLanguage = this.getQL();
        sb.append(queryLanguage == null ? "" : queryLanguage);
        sb.append(":");
        sb.append(languageFilterOptionPreferenceName);
        sb.append("=");
        sb.append(this.getFO());
        sb.append(":");
        sb.append(filterLanguagesPreferenceName);
        sb.append("=");
        String[] docLanguages = this.getFL();
        if (docLanguages != null) {
            for (int i = 0; i < docLanguages.length; ++i) {
                sb.append(docLanguages[i]);
                sb.append("|");
            }
        }
        Cookie prefsCookie = new Cookie(prefsCookieName, sb.toString());
        prefsCookie.setMaxAge(630720000);
        return prefsCookie;
    }

    public static Cookie getPrefsCookie(HttpServletRequest request, boolean create) {
        Cookie prefsCookie = null;
        Cookie[] requestCookies = request.getCookies();
        if (requestCookies != null) {
            for (int i = 0; i < requestCookies.length; ++i) {
                if (!requestCookies[i].getName().equals(prefsCookieName)) continue;
                prefsCookie = requestCookies[i];
                break;
            }
        }
        if (prefsCookie == null && create) {
            Locale locale = request.getLocale();
            StringBuilder sb = new StringBuilder();
            sb.append(interfaceLanguagePreferenceName);
            sb.append("=");
            sb.append(locale.getLanguage());
            sb.append(":");
            sb.append(queryLanguagePreferenceName);
            sb.append("=");
            sb.append(locale.getLanguage());
            sb.append(":");
            sb.append(filterLanguagesPreferenceName);
            sb.append("=");
            sb.append(":");
            sb.append(languageFilterOptionPreferenceName);
            sb.append("=0");
            prefsCookie = new Cookie(prefsCookieName, sb.toString());
        }
        return prefsCookie;
    }

    private Preference[] getDefinedPreferences() {
        Preference[] prefs = new Preference[]{new SimplePreference(interfaceLanguagePreferenceName, defaultLanguage), new SimplePreference(queryLanguagePreferenceName, defaultLanguage), new SimplePreference(languageFilterOptionPreferenceName, defaultFilterOption), new MultiValuedPreference(filterLanguagesPreferenceName, "")};
        return prefs;
    }

    private void initPreferences(Cookie cookie) {
        String[] cookiePrefs = cookie.getValue().split(":");
        for (int i = 0; i < cookiePrefs.length; ++i) {
            String[] cookieNameValue = cookiePrefs[i].split("=");
            if (cookieNameValue.length != 2) continue;
            String name = cookieNameValue[0];
            String value = cookieNameValue[1];
            Preference pref = this.preferencesMap.get(name);
            if (pref == null) continue;
            pref.parse(value);
        }
        this.invokeSetters();
    }

    private void invokeSetters() {
        Collection<Preference> preferencesColl = this.preferencesMap.values();
        block4: for (Preference pref : preferencesColl) {
            Class<?> thisClass = this.getClass();
            Method[] methods = thisClass.getMethods();
            String targetMethodName = ("set" + pref.getName()).toLowerCase();
            Class<?> targetParameterType = pref.getValue().getClass();
            for (int i = 0; i < methods.length; ++i) {
                String methodName = methods[i].getName().toLowerCase();
                if (!methodName.equals(targetMethodName)) continue;
                try {
                    Method setter = thisClass.getMethod(methods[i].getName(), targetParameterType);
                    try {
                        setter.invoke((Object)this, pref.getValue());
                    }
                    catch (Exception e) {
                    }
                }
                catch (NoSuchMethodException e) {}
                continue block4;
            }
        }
    }

    private void buildPreferencesMap() {
        Preference[] definedPreferences = this.getDefinedPreferences();
        this.preferencesMap = new Hashtable(definedPreferences.length);
        for (int i = 0; i < definedPreferences.length; ++i) {
            Preference pref = definedPreferences[i];
            this.preferencesMap.put(pref.getName(), pref);
        }
    }
}

