/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.parametric;

import com.ibm.es.nuvo.util.Vint8;
import com.ibm.es.nuvo.util.Vlong8;
import java.nio.ByteBuffer;

public class NumericPayloadRangeChecker {
    private long lowerLong;
    private long upperLong;
    private double lowerDouble;
    private double upperDouble;
    private boolean inclusive;
    private long longValue;
    private double doubleValue;
    private boolean isRangeCheck;
    private long queryLong;
    private double queryDouble;
    private byte[] payloadBytes;
    private boolean invertSense;

    public NumericPayloadRangeChecker(String lower, String upper, boolean inclusive) {
        this(lower, upper, inclusive, false);
    }

    public NumericPayloadRangeChecker(String lower, String upper, boolean inclusive, boolean invertSense) {
        try {
            this.lowerLong = Long.parseLong(lower);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.upperLong = Long.parseLong(upper);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.lowerDouble = Double.parseDouble(lower);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.upperDouble = Double.parseDouble(upper);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.inclusive = inclusive;
        this.isRangeCheck = true;
        this.invertSense = invertSense;
    }

    public NumericPayloadRangeChecker(String term) {
        try {
            this.longValue = Long.parseLong(term);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.doubleValue = Double.parseDouble(term);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.isRangeCheck = false;
    }

    public byte getPayloadType() {
        return this.payloadBytes[0];
    }

    private long getLong() {
        Vint8.Position pos = new Vint8.Position(1);
        return Vlong8.decode(this.payloadBytes, pos);
    }

    private double getDouble() {
        ByteBuffer b = ByteBuffer.wrap(this.payloadBytes);
        return b.getDouble(1);
    }

    private void setPayloadBytes(byte[] newBytes) {
        this.payloadBytes = newBytes;
        this.translateBytesToFields();
    }

    private void translateBytesToFields() {
        if (this.payloadBytes[0] == 1) {
            this.queryDouble = this.getDouble();
        } else {
            this.queryLong = this.getLong();
        }
    }

    public boolean checkIfEqual(byte[] value) {
        if (this.isRangeCheck) {
            return false;
        }
        this.setPayloadBytes(value);
        byte type = this.getPayloadType();
        if (type == 0) {
            return this.queryLong == this.longValue ^ this.invertSense;
        }
        if (type == 1) {
            return this.queryDouble == this.doubleValue ^ this.invertSense;
        }
        return false;
    }

    public boolean checkIfInRange(byte[] value) {
        if (!this.isRangeCheck) {
            return false;
        }
        try {
            this.setPayloadBytes(value);
            byte type = this.getPayloadType();
            if (this.isRangeCheck) {
                if (type == 0) {
                    if (this.inclusive) {
                        return (this.queryLong >= this.lowerLong && this.queryLong <= this.upperLong) ^ this.invertSense;
                    }
                    return (this.queryLong > this.lowerLong && this.queryLong < this.upperLong) ^ this.invertSense;
                }
                if (type == 1) {
                    if (this.inclusive) {
                        return (this.queryDouble >= this.lowerDouble && this.queryDouble <= this.upperDouble) ^ this.invertSense;
                    }
                    return (this.queryDouble > this.lowerDouble && this.queryDouble < this.upperDouble) ^ this.invertSense;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        return false;
    }

    protected int serializedPayloadSize() {
        return this.payloadBytes.length;
    }

    protected void serializePayload(byte[] dest, int start) {
        for (int j = 0; j < this.payloadBytes.length; ++j) {
            dest[start + j] = this.payloadBytes[j];
        }
    }
}

