/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.parametric;

import com.ibm.es.nuvo.util.Vlong8;
import java.nio.ByteBuffer;
import org.apache.lucene.index.Payload;

public class NumericPayloadGenerator {
    public static final byte LONG_PAYLOAD = 0;
    public static final byte DOUBLE_PAYLOAD = 1;
    public static final int DOUBLE_PAYLOAD_LENGTH = 9;
    private byte[] payloadBytes;

    public NumericPayloadGenerator(long value) {
        this.payloadBytes = new byte[Vlong8.bytesNeeded(value) + 1];
        this.payloadBytes[0] = 0;
        Vlong8.encode(value, this.payloadBytes, 1);
    }

    public NumericPayloadGenerator(double value) {
        ByteBuffer b = ByteBuffer.allocate(9);
        b.put((byte)1);
        b.putDouble(value);
        this.payloadBytes = b.array();
    }

    public Payload getPayload() {
        return new Payload(this.payloadBytes);
    }

    public byte[] getBytes() {
        return this.payloadBytes;
    }

    protected int serializedPayloadSize() {
        return this.payloadBytes.length;
    }

    protected void serializePayload(byte[] dest, int start) {
        System.arraycopy(this.payloadBytes, 0, dest, start, this.payloadBytes.length);
    }
}

