/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.common;

import com.ibm.es.nuvo.httplistener.ContextType;
import com.ibm.es.nuvo.search.ResultImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public final class FileFetcherURI {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String FETCH_PARAM_URL = "url";
    public static final String FETCH_PARAM_MIME_TYPE = "type";
    public static final String FETCH_PARAM_CHARSET = "charset";
    public static final String FETCH_PARAM_SPACE_ID = "space";
    public static final String FETCH_COLLECTION_ID = "index";
    public static final String FETCH_QUERY_INDEX = "queryIndex";

    public static String constructFetchableURI(ResultImpl result) {
        return FileFetcherURI.constructFetchableURI(result.getDocumentID(), result.getCollectionID(), result.getDocumentType(), result.getCharset(), result.getSpaceId(), result.getQueryIndex());
    }

    public static String constructFetchableURI(String uri, String collectionId, String mimeType, String charSet, String spaceId, String queryIndex) {
        if (mimeType == null) {
            mimeType = "";
        }
        if (charSet == null) {
            charSet = "";
        }
        StringBuilder fetchURI = new StringBuilder();
        fetchURI.append(ContextType.Search.getContextPath());
        fetchURI.append("/fetch?");
        fetchURI.append("url=");
        try {
            fetchURI.append(URLEncoder.encode(uri, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        fetchURI.append("&");
        fetchURI.append("index=");
        try {
            fetchURI.append(URLEncoder.encode(collectionId, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        fetchURI.append("&");
        fetchURI.append("space=");
        fetchURI.append(spaceId);
        if (mimeType != null) {
            fetchURI.append('&');
            fetchURI.append("type=");
            try {
                fetchURI.append(URLEncoder.encode(mimeType, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        fetchURI.append('&');
        fetchURI.append("queryIndex=");
        if (queryIndex != null) {
            try {
                fetchURI.append(URLEncoder.encode(queryIndex, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        fetchURI.append("&");
        fetchURI.append("charset=");
        fetchURI.append(charSet);
        return fetchURI.toString();
    }
}

