/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.cache.transform.html;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.parser.transform.TransformationException;
import com.ibm.es.nuvo.parser.transform.TransformationManager;
import com.ibm.es.nuvo.parser.transform.TransformationService;
import com.ibm.es.nuvo.search.cache.CachedDocument;
import com.ibm.es.nuvo.search.cache.transform.binary.RawCachedDocumentTransformer;
import com.ibm.es.nuvo.util.transform.TransformedDocumentInputStream;
import java.io.PrintWriter;
import java.util.HashSet;

public class HtmlCachedDocumentTransformer
extends RawCachedDocumentTransformer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static HashSet<String> htmlMimeSet = new HashSet(10);
    private static final String searchHtmlFormat = "search-html";
    private static final String htmlFormat = "html";

    public void transform(CachedDocument doc, PrintWriter pw) throws ExtendedException {
        TransformationManager manager = null;
        try {
            manager = TransformationService.getManager();
            manager.initialize(null);
            String filterType = this.getFilterType(doc);
            TransformedDocumentInputStream tdInputStream = new TransformedDocumentInputStream(doc.getInputStream(), filterType, manager);
            String charSet = doc.getCharset();
            super.transform(tdInputStream, pw, charSet);
        }
        catch (TransformationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExtendedException(e);
        }
        finally {
            if (manager != null) {
                manager.terminate();
            }
        }
    }

    public String getTransformedMimeType() {
        return "text/html";
    }

    private String getFilterType(CachedDocument doc) {
        String format = searchHtmlFormat;
        try {
            String mimeType = doc.getMimeType();
            if (htmlMimeSet.contains(mimeType)) {
                format = htmlFormat;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return format;
    }

    static {
        htmlMimeSet.add("text/xml");
        htmlMimeSet.add("text/rtf");
        htmlMimeSet.add("text/plain");
        htmlMimeSet.add("text/html");
        htmlMimeSet.add("application/x-js-taro");
        htmlMimeSet.add("application/msword");
        htmlMimeSet.add("application/x-msexcel");
        htmlMimeSet.add("application/ms-project");
        htmlMimeSet.add("application/vnd.lotus-wordpro");
        htmlMimeSet.add("application/vnd.lotus-123");
        htmlMimeSet.add("application/vnd.wordperfect");
        htmlMimeSet.add("application/mswrite");
    }
}

