/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.cache.transform.binary;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.search.NoDocumentContentException;
import com.ibm.es.nuvo.search.cache.CachedDocument;
import com.ibm.es.nuvo.search.cache.transform.CachedDocumentTransformer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;

public class RawCachedDocumentTransformer
implements CachedDocumentTransformer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public void transform(CachedDocument doc, OutputStream os) throws ExtendedException {
        this.transform(doc.getInputStream(), os);
    }

    public void transform(CachedDocument doc, PrintWriter pw) throws ExtendedException {
        String charSet = doc.getCharset();
        this.transform(doc.getInputStream(), pw, charSet);
    }

    public String getTransformedMimeType() {
        return "application/binary";
    }

    protected void transform(InputStream is, OutputStream os) throws ExtendedException {
        if (is == null) {
            throw new NoDocumentContentException();
        }
        try {
            int c;
            while ((c = is.read()) != -1) {
                os.write(c);
            }
        }
        catch (IOException e) {
            throw new ExtendedException(e);
        }
    }

    protected void transform(InputStream is, PrintWriter pw, String charSet) throws ExtendedException {
        if (is == null) {
            throw new NoDocumentContentException();
        }
        try {
            int c;
            InputStreamReader reader;
            InputStreamReader inputStreamReader = reader = charSet != null ? new InputStreamReader(is, charSet) : new InputStreamReader(is, "UTF-8");
            while ((c = reader.read()) != -1) {
                pw.write(c);
            }
        }
        catch (IOException e) {
            throw new ExtendedException(e);
        }
    }
}

