/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.cache;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.search.cache.CacheResponder;
import com.ibm.es.nuvo.search.cache.CachedDocument;
import com.ibm.es.nuvo.search.cache.transform.html.HtmlCachedDocumentTransformer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HtmlCacheResponder
implements CacheResponder {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public void respond(CachedDocument cachedDoc, String uri, String decoratedUri, HttpServletRequest request, HttpServletResponse response) throws ExtendedException {
        if (cachedDoc == null) {
            throw new IllegalArgumentException();
        }
        try {
            String contentType = "text/html";
            String charSet = cachedDoc.getCharset();
            contentType = charSet == null ? contentType + ";charset=utf-8" : contentType + ";charset=" + charSet;
            response.setContentType(contentType);
            request.setAttribute("cacheURI", (Object)uri);
            request.setAttribute("decoratedUri", (Object)decoratedUri);
            RequestDispatcher requestDispatcher = request.getRequestDispatcher("/binaryCacheHeader.jsp");
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            HtmlCachedDocumentTransformer transformer = new HtmlCachedDocumentTransformer();
            transformer.transform(cachedDoc, response.getWriter());
        }
        catch (Exception e) {
            throw new ExtendedException(e);
        }
    }
}

