/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.cache;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.documentqueue.DocumentStreamCreateException;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.stream.DocumentFieldInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class CachedDocument
implements StreamedDocument {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String documentContentField = "_docContent";
    public static final String mimeTypeField = "_mimeType";
    public static final String charsetField = "_charset";
    public static final String crawlspaceField = "_crwsp";
    private Document doc;
    private Metadata metadata;

    public CachedDocument(Document doc) {
        this.doc = doc;
        this.readMetadata();
    }

    public InputStream getInputStream() {
        InflaterInputStream is = null;
        Field field = this.doc.getField(documentContentField);
        if (field != null) {
            is = new InflaterInputStream(new DocumentFieldInputStream(this.doc, documentContentField), new Inflater());
        }
        return is;
    }

    public String getMimeType() {
        return this.doc.get(mimeTypeField);
    }

    public String getCharset() {
        return this.doc.get(charsetField);
    }

    public String getCrawlspace() {
        if (this.metadata == null) {
            return this.doc.get(crawlspaceField);
        }
        return this.metadata.get("CrawlSpaceID");
    }

    public String getHtmlizedContents() {
        return this.doc.get("_htmlized");
    }

    public void dispose() {
    }

    public InputStream getCacheStream() throws DocumentStreamCreateException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMetadata() {
        DocumentFieldInputStream is = new DocumentFieldInputStream(this.doc, "_metadata");
        InflaterInputStream iis = new InflaterInputStream(is, new Inflater());
        try {
            this.metadata = Metadata.deserialize(iis);
        }
        catch (ParseException e) {
            this.metadata = new Metadata();
            if (Loggers.logger.isLoggable(Level.SEVERE)) {
                Message msg = new Message("S0223E.PARSE_ERROR_CACHED_METADATA");
                msg.addArgument(this.getUri());
                Loggers.logger.log(Level.SEVERE, new ExtendedException(msg, (Throwable)e));
            }
            return;
        }
        finally {
            block13: {
                try {
                    iis.close();
                }
                catch (IOException e) {
                    if (!Loggers.logger.isLoggable(Level.SEVERE)) break block13;
                    Message msg = new Message("S0224E.ERROR_CACHED_METADATA_CLOSE_STREAM");
                    msg.addArgument(this.getUri());
                    Loggers.logger.log(Level.SEVERE, new ExtendedException(msg, (Throwable)e));
                }
            }
        }
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public String getUri() {
        return this.doc.get("uri");
    }

    public void writeTo(XMLTagger tagger) throws IOException {
    }
}

