/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.cache;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.indexer.ExtendedIndexWriter;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.search.cache.CacheWriterInstantiationException;
import com.ibm.es.nuvo.util.stream.DocumentFieldOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheWriter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private StandardAnalyzer analyzer;
    private ExtendedIndexWriter indexWriter;
    private int bufferSize;
    private Directory dir;
    private String collectionId;
    private static final String defaultMimeType = "text/plain";
    private static final String defaultCharset = "ISO8859-1";

    public static CacheWriter open(String collectionId, String path, int bufferSize, boolean create, HashMap<String, String> properties) throws CacheWriterInstantiationException {
        FSDirectory directory = null;
        try {
            directory = FSDirectory.getDirectory((String)path);
        }
        catch (IOException e) {
            throw new CacheWriterInstantiationException(e);
        }
        return new CacheWriter(collectionId, (Directory)directory, bufferSize, create, properties);
    }

    public static CacheWriter open(String collectionId, Directory dir, int bufferSize, boolean create, HashMap<String, String> properties) throws CacheWriterInstantiationException {
        return new CacheWriter(collectionId, dir, bufferSize, create, properties);
    }

    public void close() throws IOException {
        this.indexWriter.close();
    }

    public void optimize() throws IOException {
        this.indexWriter.optimize();
    }

    public void shutdown() throws IOException {
        this.indexWriter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(String uri, Metadata docMetadata, InputStream is, Metadata origMetadata) throws IOException {
        String htmlized;
        Document doc = new Document();
        doc.add((Fieldable)new Field("uri", uri, Field.Store.YES, Field.Index.UN_TOKENIZED));
        Metadata crawlerMetadata = new Metadata();
        if (origMetadata != null) {
            crawlerMetadata.replaceMetadataPart(Metadata.Type.CrawlerFields, origMetadata.getMetadataPart(Metadata.Type.CrawlerFields));
            crawlerMetadata.replaceMetadataPart(Metadata.Type.CrawlerImplicit, origMetadata.getMetadataPart(Metadata.Type.CrawlerImplicit));
            crawlerMetadata.replaceMetadataPart(Metadata.Type.CrawlerMetadata, origMetadata.getMetadataPart(Metadata.Type.CrawlerMetadata));
        }
        DeflaterOutputStream oos = new DeflaterOutputStream((OutputStream)new DocumentFieldOutputStream(doc, "_metadata"), new Deflater(9));
        try {
            Metadata.serialize(oos, crawlerMetadata);
        }
        finally {
            oos.close();
        }
        String charEncoding = defaultCharset;
        if (docMetadata != null && (charEncoding = docMetadata.get("charset")) == null) {
            charEncoding = defaultCharset;
        }
        doc.add((Fieldable)new Field("_charset", charEncoding, Field.Store.YES, Field.Index.NO));
        String mimeType = defaultMimeType;
        if (docMetadata != null && (mimeType = docMetadata.get("doctype")) == null) {
            mimeType = defaultMimeType;
        }
        doc.add((Fieldable)new Field("_mimeType", mimeType, Field.Store.YES, Field.Index.NO));
        String crawlspace = docMetadata.get("CrawlSpaceID");
        if (crawlspace != null) {
            Field field = new Field("_crwsp", crawlspace, Field.Store.NO, Field.Index.NO_NORMS);
            doc.add((Fieldable)field);
        }
        if ((htmlized = docMetadata.get("_htmlized")) != null) {
            Field field = new Field("_htmlized", htmlized, Field.Store.COMPRESS, Field.Index.NO);
            doc.add((Fieldable)field);
        }
        if (is != null) {
            int numRead;
            DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)new DocumentFieldOutputStream(doc, "_docContent", this.bufferSize), new Deflater(9));
            byte[] docBuffer = new byte[this.bufferSize];
            while ((numRead = is.read(docBuffer, 0, this.bufferSize)) != -1) {
                dos.write(docBuffer, 0, numRead);
            }
            dos.close();
        }
        this.indexWriter.updateDocument(new Term("uri", uri), doc, (Analyzer)this.analyzer);
    }

    public void deleteDocument(String uri) throws IOException {
        this.indexWriter.deleteDocuments(new Term("uri", uri));
    }

    public void removeDocumentForCrawlspace(String crawlspace) throws IOException {
        this.indexWriter.deleteDocuments(new Term("_crwsp", crawlspace));
    }

    public Directory getDirectory() {
        return this.dir;
    }

    private CacheWriter(String collectionId, Directory dir, int bufferSize, boolean create, HashMap<String, String> properties) throws CacheWriterInstantiationException {
        try {
            this.collectionId = collectionId;
            this.dir = dir;
            this.analyzer = new StandardAnalyzer();
            this.indexWriter = new ExtendedIndexWriter(dir, (Analyzer)this.analyzer, create);
            this.setProperties(this.indexWriter, properties);
        }
        catch (Exception e) {
            throw new CacheWriterInstantiationException(e);
        }
        this.bufferSize = bufferSize;
    }

    private void setProperties(ExtendedIndexWriter writer, HashMap<String, String> properties) {
        try {
            int docs = Integer.parseInt(properties.get("MaxBufferedDocs"));
            writer.setMaxBufferedDocs(docs);
            writer.setMaxBufferedDeleteTerms(docs);
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("MaxBufferedDocs"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionId));
        }
        try {
            String value = properties.get("MaxMergeDocs");
            if (value != null) {
                int docs = value.equals("Integer.MAX_VALUE") ? Integer.MAX_VALUE : Integer.parseInt(value);
                writer.setMaxMergeDocs(docs);
            }
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("MaxMergeDocs"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionId));
        }
        try {
            String strBufferSize = properties.get("BufferSize");
            long writerBufferSize = 0xA00000L;
            if (strBufferSize != null) {
                writerBufferSize = Integer.parseInt(strBufferSize) * 1024 * 1024;
            }
            writer.setMaxBufferSize(writerBufferSize);
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("BufferSize"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionId));
        }
        try {
            writer.setMaxFieldLength(Integer.parseInt(properties.get("MaxFieldLength")));
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("MaxFieldLength"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionId));
        }
        try {
            writer.setMergeFactor(Integer.parseInt(properties.get("MergeFactor")));
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("MergeFactor"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionId));
        }
        writer.setUseCompoundFile("true".equals(properties.get("UseCompoundFile")));
    }
}

