/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.cache;

import com.ibm.es.nuvo.search.cache.CachedDocument;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class CacheSearcher
extends IndexSearcher {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private TermDocs termDocs = this.getIndexReader().termDocs();

    public CacheSearcher(String path) throws IOException {
        super(path);
    }

    public CachedDocument getCachedDocument(String uri) throws IOException {
        if (uri == null) {
            return null;
        }
        TermQuery query = new TermQuery(new Term("uri", uri));
        Hits hits = this.search((Query)query);
        assert (hits.length() <= 1);
        if (hits.length() == 0) {
            return null;
        }
        Document doc = hits.doc(0);
        return new CachedDocument(doc);
    }

    public synchronized boolean exists(String uri) throws IOException {
        int[] docs = new int[1];
        int[] freqs = new int[1];
        this.termDocs.seek(new Term("uri", uri));
        return this.termDocs.read(docs, freqs) == 1;
    }
}

