/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search.cache;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.search.cache.CacheResponder;
import com.ibm.es.nuvo.search.cache.CachedDocument;
import com.ibm.es.nuvo.search.cache.transform.binary.RawCachedDocumentTransformer;
import com.ibm.es.nuvo.util.url.URLEncoderDecoder;
import java.io.OutputStream;
import java.util.HashSet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BinaryCacheResponder
implements CacheResponder {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static HashSet<String> textTypes = new HashSet();

    public void respond(CachedDocument cachedDoc, String uri, String decoratedUri, HttpServletRequest request, HttpServletResponse response) throws ExtendedException {
        if (cachedDoc == null) {
            throw new IllegalArgumentException();
        }
        try {
            String charSet;
            String mimeType;
            String decodedUri = URLEncoderDecoder.decode(uri);
            String fileName = decodedUri.substring(decodedUri.lastIndexOf("/") + 1);
            response.addHeader("Content-Disposition", "inline; filename=" + (fileName != null ? fileName : ""));
            RawCachedDocumentTransformer transformer = new RawCachedDocumentTransformer();
            String contentType = mimeType = cachedDoc.getMimeType();
            if (this.isTextDocument(mimeType)) {
                contentType = "text/html";
            }
            contentType = (charSet = cachedDoc.getCharset()) == null ? contentType + ";charset=utf-8" : contentType + ";charset=" + charSet;
            response.setContentType(contentType);
            if (this.isTextDocument(mimeType)) {
                request.setAttribute("cacheURI", (Object)uri);
                request.setAttribute("decoratedUri", (Object)decoratedUri);
                RequestDispatcher requestDispatcher = request.getRequestDispatcher("/binaryCacheHeader.jsp");
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                transformer.transform(cachedDoc, response.getWriter());
            } else {
                transformer.transform(cachedDoc, (OutputStream)response.getOutputStream());
            }
        }
        catch (ExtendedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExtendedException(e);
        }
    }

    private boolean isTextDocument(String mimeType) {
        return textTypes.contains(mimeType);
    }

    static {
        textTypes.add("text/html");
        textTypes.add("text/plain");
        textTypes.add("text/xml");
    }
}

