/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.FieldDefinition;
import com.ibm.es.nuvo.configuration.FieldDefinitions;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.search.QueryImpl;
import com.ibm.es.nuvo.search.ResultFetcher;
import com.ibm.es.nuvo.search.ResultImpl;
import com.ibm.es.nuvo.search.query.ParsedQuery;
import com.ibm.es.nuvo.search.summarizer.Summarizer;
import com.ibm.es.nuvo.search.summarizer.SummarizerException;
import com.ibm.es.nuvo.search.summarizer.queryterms.HighlightQueryTerms;
import com.ibm.es.nuvo.search.util.StoredDocumentLoader;
import com.ibm.es.nuvo.tokenizer.TokenizedDocument;
import com.ibm.es.nuvo.util.parser.Utils;
import com.ibm.siapi.search.Query;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;

class SimpleResultFetcher
implements ResultFetcher {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected IndexReader indexReader;
    private StoredDocumentLoader storedDocumentLoader;
    protected Query query;
    protected ParsedQuery parsedQuery;
    protected ScoreDoc[] docs;
    protected String collectionId;
    protected String[] queriedFields;
    protected String[] mandatoryFields;
    protected static final String FIELD_VALUE_SEPARATOR = ", ";

    public SimpleResultFetcher(IndexReader reader, StoredDocumentLoader storedDocumentLoader, Query query, ParsedQuery parsedQuery, ScoreDoc[] docs, String collectionId, String[] queriedFields) {
        this.indexReader = reader;
        this.storedDocumentLoader = storedDocumentLoader;
        this.query = query;
        this.parsedQuery = parsedQuery;
        this.docs = docs;
        this.collectionId = collectionId;
        this.queriedFields = queriedFields;
        if (query != null) {
            this.mandatoryFields = ((QueryImpl)query).getMandatoryFields();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultImpl[] fetch(int firstResult, int numResults) throws ExtendedException {
        Summarizer.Summary[] summaries = null;
        Summarizer.Summary[] titles = null;
        Summarizer.Summary[] uris = null;
        List<Map<String, Summarizer.Summary>> highlightedFields = null;
        ArrayList mandatoryFieldValues = null;
        Map<String, FieldDefinition> fieldDefinitions = null;
        ResultImpl[] resultArray = null;
        if (!this.resultsFetchable(firstResult, numResults)) {
            return new ResultImpl[0];
        }
        int numResultsToFetch = Math.min(numResults, this.docs.length - firstResult);
        resultArray = new ResultImpl[numResultsToFetch];
        String disableSummarizer = this.query.getProperties().getProperty("disableSummarizer");
        boolean doSummarize = disableSummarizer == null || Boolean.valueOf(disableSummarizer) == false;
        boolean bl = this.query.isAttributeReturned(-1) || this.query.isAttributeReturned(-2) || this.query.isAttributeReturned(-11) || this.queriedFields != null && this.queriedFields.length > 0;
        Summarizer summarizer = null;
        if (doSummarize &= bl) {
            summarizer = new Summarizer(this.indexReader);
        }
        Document[] loadedDocuments = new Document[numResultsToFetch];
        for (int i = 0; i < numResultsToFetch; ++i) {
            loadedDocuments[i] = this.storedDocumentLoader.loadStoredDocument(this.indexReader, this.docs[i + firstResult].doc);
        }
        try {
            block37: {
                if (doSummarize) {
                    int i;
                    TokenizedDocument[] tokenizedDocuments = new TokenizedDocument[numResultsToFetch];
                    ScoreDoc[] scoreDocs = new ScoreDoc[numResultsToFetch];
                    try {
                        for (i = 0; i < numResultsToFetch; ++i) {
                            scoreDocs[i] = this.docs[i + firstResult];
                            tokenizedDocuments[i] = TokenizedDocument.readDocument(loadedDocuments[i], false);
                        }
                        if (this.query.isAttributeReturned(-1)) {
                            summaries = summarizer.getSummaries(scoreDocs, loadedDocuments, tokenizedDocuments, 0, numResultsToFetch, this.parsedQuery.getTermsForSummarizer("_plain"), "_plain");
                        }
                        if (this.query.isAttributeReturned(-2)) {
                            titles = summarizer.highlightTerms(scoreDocs, loadedDocuments, tokenizedDocuments, 0, numResultsToFetch, this.parsedQuery.getTermsForSummarizer("title"), "title");
                        }
                        if (this.query.isAttributeReturned(-11)) {
                            uris = summarizer.highlightTerms(scoreDocs, loadedDocuments, tokenizedDocuments, 0, numResultsToFetch, this.parsedQuery.getTermsForSummarizer("url"), "url");
                        }
                        if (this.queriedFields != null && this.queriedFields.length > 0) {
                            highlightedFields = summarizer.highlightTerms(scoreDocs, loadedDocuments, tokenizedDocuments, 0, numResultsToFetch, this.parsedQuery.getTermsForSummarizer(), this.queriedFields);
                        }
                        if (this.mandatoryFields == null || this.mandatoryFields.length <= 0) break block37;
                        mandatoryFieldValues = new ArrayList();
                        for (i = 0; i < numResultsToFetch; ++i) {
                            HashMap fieldMap = new HashMap();
                            mandatoryFieldValues.add(fieldMap);
                        }
                        for (i = 0; i < this.mandatoryFields.length; ++i) {
                            Summarizer.Summary[] fieldSummaries = summarizer.highlightTerms(scoreDocs, loadedDocuments, tokenizedDocuments, 0, numResultsToFetch, new HighlightQueryTerms(), this.mandatoryFields[i]);
                            for (int j = 0; j < numResultsToFetch; ++j) {
                                ((Map)mandatoryFieldValues.get(j)).put(this.mandatoryFields[i], fieldSummaries[j]);
                            }
                        }
                    }
                    catch (SummarizerException e) {
                        if (Loggers.logger.isLoggable(Level.SEVERE)) {
                            Message msg = new Message("S0006W.DYNAMIC_SUMMARY_CREATION_FAILURE");
                            msg.addArgument(this.query.getText());
                            msg.addArgument(this.collectionId);
                            ExtendedException exc = new ExtendedException(msg, (Throwable)e);
                            Loggers.logger.log(exc);
                        }
                    }
                    finally {
                        for (i = 0; i < numResultsToFetch; ++i) {
                            if (tokenizedDocuments[i] == null) continue;
                            tokenizedDocuments[i].close();
                        }
                    }
                }
            }
            int hitsIndex = firstResult;
            for (int j = 0; j < numResultsToFetch; ++j) {
                int docId = this.docs[hitsIndex].doc;
                float score = this.docs[hitsIndex].score;
                Document d = loadedDocuments[j];
                resultArray[j] = new ResultImpl(d, docId, score, this.query, this.collectionId);
                if (this.query.isAttributeReturned(-1) && summaries != null) {
                    resultArray[j].setDescription(summaries[j].toString());
                }
                if (this.query.isAttributeReturned(-2) && titles != null) {
                    resultArray[j].setTitle(titles[j].toString());
                }
                if (this.query.isAttributeReturned(-11) && uris != null) {
                    resultArray[j].setHighlightedDocumentURI(uris[j].toString());
                }
                if (highlightedFields != null) {
                    Map<String, Summarizer.Summary> fieldValues = highlightedFields.get(j);
                    for (int k = 0; k < this.queriedFields.length; ++k) {
                        Summarizer.Summary fieldValue = fieldValues.get(this.queriedFields[k]);
                        if (fieldValue == null || !fieldValue.containsHighlightedTerms()) continue;
                        resultArray[j].setMetadataValue(this.queriedFields[k], fieldValue.toString());
                        if (fieldValue.getShortVersionBreakPosition() <= 0) continue;
                        resultArray[j].setMetadataValueShort(this.queriedFields[k], fieldValue.toString().substring(0, fieldValue.getShortVersionBreakPosition()));
                    }
                }
                if (this.queriedFields != null && this.queriedFields.length > 0) {
                    if (fieldDefinitions == null) {
                        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
                        CollectionConfiguration collectionConfig = configurationManager.getCollection(this.collectionId);
                        fieldDefinitions = collectionConfig.getFieldDefinitions().getFieldDefinitions(FieldDefinitions.ALL);
                    }
                    for (int k = 0; k < this.queriedFields.length; ++k) {
                        FieldDefinition fieldDef;
                        String fieldName = this.queriedFields[k];
                        if (!fieldDefinitions.containsKey(fieldName) || d.getValues(fieldName) == null || (fieldDef = fieldDefinitions.get(fieldName)) == null) continue;
                        FieldDefinition.FieldSearchAttributes attr = fieldDef.getFieldSearchAttr();
                        if (!fieldDef.isParametricSearchable() && attr.isTokenized()) continue;
                        String singleValue = this.createSingleValue(d, fieldName, fieldDef);
                        if (!attr.isTokenized()) {
                            singleValue = Utils.entityEncode(singleValue);
                        }
                        resultArray[j].setMetadataValue(fieldName, singleValue);
                        if (singleValue.length() <= 170) continue;
                        resultArray[j].setMetadataValueShort(fieldName, SimpleResultFetcher.createShortMetadataValue(singleValue));
                    }
                }
                if (this.mandatoryFields != null && this.mandatoryFields.length > 0) {
                    if (fieldDefinitions == null) {
                        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
                        CollectionConfiguration collectionConfig = configurationManager.getCollection(this.collectionId);
                        fieldDefinitions = collectionConfig.getFieldDefinitions().getFieldDefinitions(FieldDefinitions.ALL);
                    }
                    Set<Object> currentFields = resultArray[j].getMetadata() == null ? new Properties().keySet() : resultArray[j].getMetadata().keySet();
                    Map fieldValues = (Map)mandatoryFieldValues.get(j);
                    for (int k = 0; k < this.mandatoryFields.length; ++k) {
                        Summarizer.Summary fieldValue = (Summarizer.Summary)fieldValues.get(this.mandatoryFields[k]);
                        if (fieldValue == null || fieldValue.toString() == null || currentFields.contains(this.mandatoryFields[k]) || fieldValue == null) continue;
                        String value = fieldValue.toString();
                        FieldDefinition fieldDef = fieldDefinitions.get(this.mandatoryFields[k]);
                        if (fieldDef == null) continue;
                        FieldDefinition.FieldSearchAttributes attr = fieldDef.getFieldSearchAttr();
                        if (fieldDef.isParametricSearchable() || !attr.isTokenized()) {
                            value = this.createSingleValue(d, this.mandatoryFields[k], fieldDef);
                        }
                        if (!attr.isTokenized()) {
                            value = Utils.entityEncode(value);
                        }
                        resultArray[j].setMetadataValue(this.mandatoryFields[k], value);
                        if (fieldValue.getShortVersionBreakPosition() > 0) {
                            resultArray[j].setMetadataValueShort(this.mandatoryFields[k], value.substring(0, fieldValue.getShortVersionBreakPosition()));
                            continue;
                        }
                        if (value.length() <= 170) continue;
                        resultArray[j].setMetadataValueShort(this.mandatoryFields[k], SimpleResultFetcher.createShortMetadataValue(value));
                    }
                }
                ++hitsIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultArray = null;
        }
        return resultArray;
    }

    protected boolean resultsFetchable(int firstResult, int numResults) {
        return firstResult >= 0 && numResults > 0 && firstResult <= this.docs.length - 1;
    }

    protected String createSingleValue(Document d, String fieldName, FieldDefinition fieldDef) {
        String[] values = d.getValues(fieldName);
        StringBuilder displayValue = new StringBuilder();
        FieldDefinition.ParametricSearchAttributes paramAttr = fieldDef.getParametricSearchAttr();
        if (paramAttr.getType().equals((Object)FieldDefinition.ParametricType.Date)) {
            Locale locale = this.query.getQueryLanguage() == null ? Locale.getDefault() : new Locale(this.query.getQueryLanguage());
            DateFormat format = DateFormat.getDateTimeInstance(0, 0, locale);
            for (int i = 0; i < values.length; ++i) {
                try {
                    values[i] = format.format(new Date(Long.parseLong(values[i])));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < values.length; ++i) {
            displayValue.append(values[i]);
            if (i >= values.length - 1) continue;
            displayValue.append(FIELD_VALUE_SEPARATOR);
        }
        return displayValue.toString();
    }

    private static String createShortMetadataValue(String value) {
        char[] c = value.toCharArray();
        for (int i = 170; i > 0; --i) {
            if (!Character.isWhitespace(c[i])) continue;
            value = value.substring(0, i);
            break;
        }
        return value;
    }
}

