/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import com.ibm.es.nuvo.search.FacetSearcher;
import com.ibm.es.nuvo.search.TextSearcher;
import com.ibm.es.nuvo.search.cache.CacheSearcher;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;

public class SearcherFactory {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static IndexSearcher getInstance(IndexDescriptor.IndexType type, String indexPath, CollectionConfiguration collectionConfig) throws IOException, TaxonomyIndexerException {
        IndexSearcher searcher = null;
        if (type == IndexDescriptor.IndexType.Cache) {
            searcher = new CacheSearcher(indexPath);
        } else if (type != IndexDescriptor.IndexType.Anchor) {
            searcher = type == IndexDescriptor.IndexType.Text ? new TextSearcher(indexPath, collectionConfig) : (type == IndexDescriptor.IndexType.Facet ? new FacetSearcher(collectionConfig) : new IndexSearcher(indexPath));
        }
        return searcher;
    }
}

