/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.facet.CountSelectedFacets;
import com.ibm.es.nuvo.facet.FacetHitCollector;
import com.ibm.es.nuvo.facet.WorkingFacetCounter;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.quicklinks.index.QuicklinksWriter;
import com.ibm.es.nuvo.search.ACLResultFilter;
import com.ibm.es.nuvo.search.CollectionInfoImpl;
import com.ibm.es.nuvo.search.CustomHitCollector;
import com.ibm.es.nuvo.search.DelegateHitCollector;
import com.ibm.es.nuvo.search.DupEliminatingResultFilter;
import com.ibm.es.nuvo.search.EmptyQueryException;
import com.ibm.es.nuvo.search.ExactDupEliminatingResultFilter;
import com.ibm.es.nuvo.search.FacetSearcher;
import com.ibm.es.nuvo.search.FilteringAndBatchingResultFetcher;
import com.ibm.es.nuvo.search.InvalidQueryTermException;
import com.ibm.es.nuvo.search.NearDupEliminatingResultFilter;
import com.ibm.es.nuvo.search.QueryImpl;
import com.ibm.es.nuvo.search.QueryLimitExceededException;
import com.ibm.es.nuvo.search.ResultImpl;
import com.ibm.es.nuvo.search.ResultSetImpl;
import com.ibm.es.nuvo.search.SearchableInstantiationException;
import com.ibm.es.nuvo.search.SearcherFactory;
import com.ibm.es.nuvo.search.SimpleResultFetcher;
import com.ibm.es.nuvo.search.SpellCorrectionImpl;
import com.ibm.es.nuvo.search.cache.CacheSearcher;
import com.ibm.es.nuvo.search.cache.CachedDocument;
import com.ibm.es.nuvo.search.query.ExtendedTermQuery;
import com.ibm.es.nuvo.search.query.LinguisticQueryParser;
import com.ibm.es.nuvo.search.query.ParsedQuery;
import com.ibm.es.nuvo.search.query.SpellSuggestionCandidate;
import com.ibm.es.nuvo.search.security.UserSecurityContext;
import com.ibm.es.nuvo.search.util.StoredDocumentLoader;
import com.ibm.es.nuvo.spell.SpellChecker;
import com.ibm.es.nuvo.spell.SpellSuggestionSearcher;
import com.ibm.es.nuvo.spell.querylog.QueryRuntimeStatistics;
import com.ibm.es.nuvo.synonym.index.SynonymIndexSearcher;
import com.ibm.es.nuvo.tokenizer.Tokenizer;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.util.Vint8;
import com.ibm.es.nuvo.util.Vlong8;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.common.CollectionInfo;
import com.ibm.siapi.search.FieldInfo;
import com.ibm.siapi.search.Result;
import com.ibm.siapi.search.ResultSet;
import com.ibm.siapi.search.Searchable;
import com.ibm.siapi.search.SpellCorrection;
import com.ibm.siapi.search.StreamingResultSet;
import com.ibm.siapi.search.SynonymExpansion;
import com.ibm.supa.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.search.TopDocs;

public class SearchableImpl
implements Searchable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private StoredDocumentLoader storedDocumentLoader = new StoredDocumentLoader.SimpleStoredDocumentLoader();
    private IndexSearcher[] searchers = new IndexSearcher[IndexDescriptor.IndexType.values().length];
    private CollectionConfiguration collectionConfig;
    private String collectionId = null;
    private Properties properties = new Properties();
    private boolean synonymExpansionEnabled = true;
    private boolean spellingCorrectionEnabled = true;
    private static final long defaultRefreshInterval = 60000L;
    private long refreshInterval = 60000L;
    private long lastRefreshTime = System.currentTimeMillis();
    private CollectionInfo collectionInfo;
    private static final int maxHits = 1000;
    private boolean proximityScoring = true;
    private long[] docHashCodes;
    private QueryRuntimeStatistics queryStats;

    SearchableImpl(String collectionId) throws SearchableInstantiationException {
        this.collectionId = collectionId;
        this.queryStats = GlobalSystem.getSingleInstance().getQueryRuntimeStatistics();
        try {
            ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
            this.collectionConfig = configManager.getCollection(collectionId);
            if (!this.collectionConfig.isEnabledForSearch()) {
                Message msg = new Message("S0074E.INDEX_DISABLED_FOR_SEARCH");
                msg.addArgument(collectionId);
                throw new SearchableInstantiationException(msg);
            }
            this.collectionInfo = new CollectionInfoImpl(this.collectionConfig.getId(), this.collectionConfig.getId());
            this.initIndexSearcher(IndexDescriptor.IndexType.Cache);
            this.initIndexSearcher(IndexDescriptor.IndexType.QuickLink);
            this.initIndexSearcher(IndexDescriptor.IndexType.Synonym);
            this.initIndexSearcher(IndexDescriptor.IndexType.Text);
            IndexDescriptor taxiDescriptor = this.collectionConfig.getIndexDescriptorFor(IndexDescriptor.IndexType.Facet);
            if (taxiDescriptor != null && taxiDescriptor.isEnabled()) {
                this.initIndexSearcher(IndexDescriptor.IndexType.Facet);
            }
            this.setSpellCorrectionEnabled(this.collectionConfig.isEnabledForSpellCorrection());
            this.setSynonymExpansionEnabled(true);
            this.setProximityScoringEnabled(this.collectionConfig.getProximityScoring());
            IndexSearcher textIndexSearcher = this.getIndexSearcher(IndexDescriptor.IndexType.Text);
            CollectionConfiguration.DupElimination dupRemoval = this.collectionConfig.getRemoveDuplicates();
            if (dupRemoval == CollectionConfiguration.DupElimination.Exact || dupRemoval == CollectionConfiguration.DupElimination.NearAndExact) {
                this.docHashCodes = this.getDocHashCodes(textIndexSearcher.getIndexReader());
            }
        }
        catch (Exception e) {
            throw new SearchableInstantiationException(e);
        }
    }

    public int count(com.ibm.siapi.search.Query query) throws SiapiException {
        ResultSet results = this.search(query);
        return results.getAvailableNumberOfResults();
    }

    public String[] getAvailableAttributeValues(int attributeType) {
        return null;
    }

    public FieldInfo[] getAvailableFields() {
        return null;
    }

    public CollectionInfo getCollectionInfo() {
        return this.collectionInfo;
    }

    public String getDefaultLanguage() {
        return null;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        String value = null;
        if (this.properties != null) {
            value = this.properties.getProperty(name);
        }
        return value;
    }

    public SpellCorrection[] getSpellCorrections(String queryText) {
        return null;
    }

    public SynonymExpansion[] getSynonymExpansions(String queryText) {
        return null;
    }

    public boolean isSpellCorrectionEnabled() {
        return this.spellingCorrectionEnabled;
    }

    public boolean isSynonymExpansionEnabled() {
        return this.synonymExpansionEnabled;
    }

    public StreamingResultSet searchStreaming(com.ibm.siapi.search.Query query) throws SiapiException {
        return null;
    }

    public void setProperty(String name, String value) throws SiapiException {
        this.properties.setProperty(name, value);
    }

    public void setSpellCorrectionEnabled(boolean enabled) throws SiapiException {
        this.spellingCorrectionEnabled = enabled;
    }

    public void setSynonymExpansionEnabled(boolean enabled) throws SiapiException {
        this.synonymExpansionEnabled = enabled;
    }

    public void setProximityScoringEnabled(boolean enabled) {
        this.proximityScoring = enabled;
    }

    public ResultSet search(com.ibm.siapi.search.Query query) throws SiapiException {
        try {
            if (this.queryStats.isQueryPerDayLimitExceeded()) {
                throw new QueryLimitExceededException(1, 24);
            }
        }
        catch (ExtendedException e) {
            SiapiException exc = new SiapiException(1, 24, "");
            exc.initCause((Throwable)e);
            throw exc;
        }
        long startQueryTime = System.currentTimeMillis();
        ParsedQuery parsedQuery = null;
        String queryString = query.getText();
        SynonymIndexSearcher synIndexSearcher = null;
        if (this.isSynonymExpansionEnabled() || -14 == query.getSynonymExpansionMode()) {
            try {
                synIndexSearcher = new SynonymIndexSearcher(this.getIndexSearcher(IndexDescriptor.IndexType.Synonym));
            }
            catch (Exception ignore) {
                synIndexSearcher = null;
            }
        }
        QueryImpl queryImpl = (QueryImpl)query;
        LinguisticQueryParser queryParser = new LinguisticQueryParser(null, synIndexSearcher, this.collectionConfig, queryImpl.getCredentials(), null);
        try {
            parsedQuery = queryParser.parseAndExtract(queryString, query.getQueryLanguage(), query.getProperties());
        }
        catch (ParseException e) {
            Throwable e1 = e.getCause();
            if (e1 != null && e1 instanceof TokenizerException) {
                SiapiException exc = new SiapiException(1, 24, "");
                exc.initCause(e1);
                throw exc;
            }
            SiapiException exc = new SiapiException(1, 15, "");
            throw exc;
        }
        List<Message> parserMessages = parsedQuery.getMessages();
        if (parserMessages != null && parserMessages.size() > 0) {
            Message msg = new Message("S0233E.QUERY_CONTAINS_INVALID_TERMS");
            InvalidQueryTermException exc = new InvalidQueryTermException(msg, parserMessages);
            throw exc;
        }
        if (parsedQuery.getQuery() == null) {
            throw new EmptyQueryException(1, 24);
        }
        try {
            Result[] quickLinksResults = null;
            if (query.isPredefinedResultsEnabled()) {
                quickLinksResults = this.doQuickLinksSearch(query, parsedQuery);
            }
            boolean filter = Boolean.valueOf(query.getProperty("filter"));
            String[] queriedFields = parsedQuery.getQueryFields();
            Vector<String> v = new Vector<String>(Arrays.asList(queriedFields));
            v.remove("title");
            v.remove("url");
            v.remove("_plain");
            queriedFields = v.toArray(new String[0]);
            ResultsWrapper searchResults = this.doTextSearch(query, parsedQuery, filter, queriedFields);
            long endQueryTime = System.currentTimeMillis();
            long evaluationTime = endQueryTime - startQueryTime;
            int numResults = searchResults.getAvailableResults() + (quickLinksResults == null ? 0 : quickLinksResults.length);
            SpellCorrection[] corrections = null;
            if (this.spellingCorrectionEnabled || query.isSpellCorrectionEnabled()) {
                corrections = this.doSuggestionsLookup(parsedQuery, query.getQueryLanguage(), numResults);
            }
            boolean resultsTruncated = parsedQuery.getEarlyTerminationIndicator().isTerminatedEarly() || searchResults.removedDuplicates();
            return new ResultSetImpl(searchResults.getResults(), quickLinksResults, searchResults.getFacets(), null, corrections, evaluationTime, numResults, searchResults.getTotalResults(), queriedFields, resultsTruncated);
        }
        catch (Exception e) {
            SiapiException exc = new SiapiException(1, 24, "");
            exc.initCause((Throwable)e);
            throw exc;
        }
    }

    public void search(com.ibm.siapi.search.Query query, CustomHitCollector collector) throws SiapiException {
        ParsedQuery parsedQuery = null;
        String queryString = query.getText();
        SynonymIndexSearcher synIndexSearcher = null;
        Properties queryProps = query.getProperties();
        String synonymExpansion = queryProps.getProperty("synonymExpansion");
        try {
            if (synonymExpansion != null && Boolean.valueOf(synonymExpansion).booleanValue()) {
                synIndexSearcher = new SynonymIndexSearcher(this.getIndexSearcher(IndexDescriptor.IndexType.Synonym));
            }
        }
        catch (Exception ex) {
            synIndexSearcher = null;
        }
        LinguisticQueryParser queryParser = new LinguisticQueryParser(null, synIndexSearcher, this.collectionConfig, null, null);
        try {
            parsedQuery = queryParser.parseAndExtract(queryString, query.getQueryLanguage(), query.getProperties());
        }
        catch (ParseException e) {
            Throwable e1 = e.getCause();
            if (e1 != null && e1 instanceof TokenizerException) {
                SiapiException exc = new SiapiException(1, 24, "");
                exc.initCause(e1);
                throw exc;
            }
            SiapiException exc = new SiapiException(1, 15, "");
            throw exc;
        }
        if (parsedQuery.getQuery() == null) {
            throw new EmptyQueryException(1, 24);
        }
        try {
            IndexSearcher searcher = this.getIndexSearcher(IndexDescriptor.IndexType.Text);
            if (searcher != null) {
                collector.setQuery(query);
                collector.setIndexSearcher(searcher);
                searcher.search(parsedQuery.getQuery(), (HitCollector)collector);
            }
        }
        catch (RuntimeException e) {
            if (e.getMessage().equals("Abnormal end from runtime")) {
                SiapiException exc = new SiapiException(1, 24, "");
                exc.initCause((Throwable)e);
                throw exc;
            }
        }
        catch (Exception e) {
            SiapiException exc = new SiapiException(1, 24, "");
            exc.initCause((Throwable)e);
            throw exc;
        }
    }

    public CachedDocument getCachedDocument(String uri, UserSecurityContext usc) throws IOException, ExtendedException {
        CachedDocument doc = null;
        CacheSearcher searcher = (CacheSearcher)this.getIndexSearcher(IndexDescriptor.IndexType.Cache);
        if (searcher != null) {
            doc = searcher.getCachedDocument(uri);
            if (doc != null && usc != null && this.collectionConfig.isSecureSearchPostFilter() && !ACLResultFilter.isAuthorized(uri, this.collectionId, usc)) {
                doc = null;
            }
            if (doc != null && usc != null && !usc.hasPermission(this.collectionId, Permission.User.VIEW)) {
                doc = null;
            }
        }
        return doc;
    }

    public synchronized void destroy() throws IOException {
        for (IndexDescriptor.IndexType type : IndexDescriptor.IndexType.values()) {
            IndexSearcher searcher = this.getIndexSearcher(type);
            if (searcher == null) continue;
            searcher.close();
        }
    }

    public synchronized long numberOfDocuments() {
        IndexSearcher searcher = this.getIndexSearcher(IndexDescriptor.IndexType.Text);
        return searcher.getIndexReader().numDocs();
    }

    public synchronized boolean refreshRequired() throws IOException {
        boolean refreshRequired = false;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRefreshTime >= this.refreshInterval) {
            for (IndexDescriptor.IndexType type : IndexDescriptor.IndexType.values()) {
                IndexReader indexReader;
                IndexSearcher searcher = this.getIndexSearcher(type);
                if (searcher == null || (indexReader = searcher.getIndexReader()).isCurrent()) continue;
                refreshRequired = true;
                break;
            }
        }
        return refreshRequired;
    }

    public synchronized boolean exists(String uri) throws IOException {
        int[] docs = new int[1];
        int[] freqs = new int[1];
        IndexReader reader = this.getIndexSearcher(IndexDescriptor.IndexType.Text).getIndexReader();
        TermDocs termDocs = reader.termDocs();
        termDocs.seek(new Term("uri", uri));
        return termDocs.read(docs, freqs) == 1;
    }

    void setRefreshedTime(long time) {
        this.lastRefreshTime = time;
    }

    private boolean resultsFetchable(ScoreDoc[] docs, int firstResult, int numResults) {
        return firstResult >= 0 && numResults > 0 && firstResult <= docs.length - 1;
    }

    private ResultsWrapper doTextSearch(com.ibm.siapi.search.Query query, ParsedQuery parsedQuery, boolean filter, String[] queriedFields) throws ExtendedException {
        ResultsWrapper resultsWrapper = null;
        try {
            boolean enableACLFilter = this.collectionConfig.isSecureSearch() && this.collectionConfig.isSecureSearchPostFilter();
            boolean removedDups = false;
            IndexSearcher textIndexSearcher = this.getIndexSearcher(IndexDescriptor.IndexType.Text);
            if (textIndexSearcher != null) {
                CollectionConfiguration.DupElimination dupRemoval = this.collectionConfig.getRemoveDuplicates();
                TopDocCollector hitCollector = null;
                Object wrappedHitCollector = hitCollector = new TopDocCollector(1000);
                FacetHitCollector facetHitCollector = null;
                CountSelectedFacets countedFacets = null;
                FacetSearcher taxiSearcher = (FacetSearcher)this.getIndexSearcher(IndexDescriptor.IndexType.Facet);
                if (taxiSearcher != null) {
                    String[] list;
                    String[] testCategories = list = new String[]{"language", "Publisher", "Price", "Category", "Author", "Publication Date", "Salesrank", "Subject"};
                    WorkingFacetCounter[] workingFacetArray = new WorkingFacetCounter[testCategories.length];
                    int maxDepth = 2;
                    for (int cat = 0; cat < testCategories.length; ++cat) {
                        System.out.println("Category: " + testCategories[cat]);
                        WorkingFacetCounter wfc = null;
                        try {
                            workingFacetArray[cat] = wfc = new WorkingFacetCounter(taxiSearcher.getTaxiReader(), testCategories[cat]);
                            continue;
                        }
                        catch (TaxonomyIndexerException tie) {
                            workingFacetArray[cat] = null;
                        }
                    }
                    Properties flags = new Properties();
                    flags.put("delayCounting", "true");
                    countedFacets = new CountSelectedFacets(taxiSearcher.getTaxiReader(), textIndexSearcher.getIndexReader(), workingFacetArray, maxDepth, flags);
                    facetHitCollector = new FacetHitCollector(countedFacets);
                    wrappedHitCollector = new DelegateHitCollector((HitCollector)hitCollector, facetHitCollector);
                }
                textIndexSearcher.search(parsedQuery.getQuery(), (HitCollector)wrappedHitCollector);
                TopDocs topDocs = hitCollector.topDocs();
                ScoreDoc[] scoreDocs = topDocs.scoreDocs;
                if (countedFacets != null) {
                    int numResults = 10;
                    int topK = 50;
                    long start2 = System.currentTimeMillis();
                    countedFacets.postProcess(numResults);
                    long end2 = System.currentTimeMillis();
                    System.out.println("postProcess took " + (end2 - start2));
                    start2 = System.currentTimeMillis();
                    countedFacets.takmiCount(topK, numResults);
                    end2 = System.currentTimeMillis();
                    System.out.println("takmiCount took " + (end2 - start2) + " index numdocs " + textIndexSearcher.getIndexReader().numDocs());
                }
                if (scoreDocs.length == 0) {
                    resultsWrapper = new ResultsWrapper(null, 0, 0, false, null);
                } else {
                    int numRequestedResults = query.getNumRequestedResults();
                    int firstRequestedResult = query.getFirstRequestedResult();
                    Result[] resultArray = null;
                    if (!this.resultsFetchable(scoreDocs, firstRequestedResult, numRequestedResults)) {
                        resultArray = new ResultImpl[]{};
                    } else {
                        SimpleResultFetcher simpleFetcher = new SimpleResultFetcher(textIndexSearcher.getIndexReader(), this.storedDocumentLoader, query, parsedQuery, scoreDocs, this.collectionId, queriedFields);
                        FilteringAndBatchingResultFetcher fetcher = new FilteringAndBatchingResultFetcher(simpleFetcher);
                        if (enableACLFilter) {
                            fetcher.addFilter(new ACLResultFilter(this.collectionId, ((QueryImpl)query).getCredentials()));
                        }
                        DupEliminatingResultFilter exactDupFilter = null;
                        DupEliminatingResultFilter nearDupFilter = null;
                        if (filter) {
                            int maxNumberOfResultsToDedup = 5 * numRequestedResults;
                            if (dupRemoval == CollectionConfiguration.DupElimination.Exact) {
                                exactDupFilter = new ExactDupEliminatingResultFilter(maxNumberOfResultsToDedup, this.docHashCodes);
                                fetcher.addFilter(exactDupFilter);
                            } else if (dupRemoval == CollectionConfiguration.DupElimination.NearAndExact) {
                                exactDupFilter = new ExactDupEliminatingResultFilter(maxNumberOfResultsToDedup, this.docHashCodes);
                                fetcher.addFilter(exactDupFilter);
                                nearDupFilter = new NearDupEliminatingResultFilter(maxNumberOfResultsToDedup);
                                fetcher.addFilter(nearDupFilter);
                            }
                        }
                        resultArray = fetcher.fetch(firstRequestedResult, numRequestedResults);
                        if (exactDupFilter != null) {
                            removedDups |= exactDupFilter.dupsRemoved();
                        }
                        if (nearDupFilter != null) {
                            removedDups |= nearDupFilter.dupsRemoved();
                        }
                        if (resultArray != null) {
                            for (int i = 0; i < resultArray.length; ++i) {
                                Result result = resultArray[i];
                                result.setProperty("cached", "false");
                                CacheSearcher cacheSearcher = (CacheSearcher)this.getIndexSearcher(IndexDescriptor.IndexType.Cache);
                                if (cacheSearcher == null || !cacheSearcher.exists(result.getDocumentID())) continue;
                                result.setProperty("cached", "true");
                            }
                        }
                    }
                    resultsWrapper = new ResultsWrapper(resultArray, scoreDocs.length, topDocs.totalHits, removedDups, countedFacets);
                }
            }
        }
        catch (Exception e) {
            Message msg = new Message("S0007E.QUERY_EVALUATION_FAILURE");
            msg.addArgument(query.getText());
            msg.addArgument(this.collectionId);
            msg.addArgument(this.collectionConfig.getIndexDescriptorFor(IndexDescriptor.IndexType.Text).getAbsolutePath());
            ExtendedException exc = new ExtendedException(msg, (Throwable)e);
            if (Loggers.logger.isLoggable(Level.SEVERE)) {
                Loggers.logger.log(exc);
            }
            throw exc;
        }
        return resultsWrapper;
    }

    private Result[] doQuickLinksSearch(com.ibm.siapi.search.Query query, ParsedQuery parsedQuery) throws ExtendedException {
        ArrayList<ResultImpl> results = null;
        IndexSearcher quicklinksSearcher = this.getIndexSearcher(IndexDescriptor.IndexType.QuickLink);
        if (quicklinksSearcher != null) {
            try {
                Query qlQuery = this.buildQuicklinksQuery(parsedQuery);
                Hits hits = quicklinksSearcher.search(qlQuery);
                if (hits.length() > 0) {
                    results = new ArrayList<ResultImpl>();
                    for (int i = 0; i < hits.length(); ++i) {
                        Document doc = hits.doc(i);
                        ResultImpl result = new ResultImpl(doc, hits.id(i), hits.score(i), query, this.collectionId);
                        result.setDescription(doc.get("_static_summary"));
                        result.setTitle(doc.get("title"));
                        results.add(result);
                    }
                }
            }
            catch (Exception e) {
                Message msg = new Message("S0007E.QUERY_EVALUATION_FAILURE");
                msg.addArgument(query.getText());
                msg.addArgument(this.collectionId);
                msg.addArgument(this.collectionConfig.getIndexDescriptorFor(IndexDescriptor.IndexType.QuickLink).getAbsolutePath());
                ExtendedException exc = new ExtendedException(msg, (Throwable)e);
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(exc);
                }
                throw exc;
            }
        }
        if (results == null) {
            return null;
        }
        return results.toArray(new ResultImpl[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpellCorrectionImpl[] doSuggestionsLookup(ParsedQuery query, String queryLocale, int numResults) {
        if (numResults > 0 || null == query) {
            return null;
        }
        String language = null;
        String country = null;
        List<SpellSuggestionCandidate> candidates = query.getSpellSuggestionCandidates();
        if (candidates.size() > 0) {
            IndexReader indexReader;
            if (queryLocale.length() >= 2) {
                language = queryLocale.substring(0, 2);
            }
            if (queryLocale.length() >= 5) {
                country = queryLocale.substring(3, 5);
            }
            if (null == language) {
                language = "en";
            }
            if (null == country && language.equalsIgnoreCase("en")) {
                country = "US";
            }
            if (0 == (indexReader = this.getIndexSearcher(IndexDescriptor.IndexType.Text).getIndexReader()).numDocs()) {
                return null;
            }
            Tokenizer tokenizer = null;
            try {
                tokenizer = GlobalSystem.getSingleInstance().getTokenizerPool().aquire(this.collectionId);
                SpellSuggestionSearcher searcher = new SpellSuggestionSearcher(indexReader, tokenizer, language, country);
                String queryString = query.getQueryString();
                for (SpellSuggestionCandidate candidate : candidates) {
                    if (this.isSkippable(candidate)) continue;
                    ExtendedTermQuery[] termQueries = candidate.getTerms();
                    int start = termQueries[0].getBegin();
                    int end = termQueries[termQueries.length - 1].getEnd();
                    String candidateString = queryString.substring(start, end);
                    String[] suggestions = searcher.getSuggestions(candidate.field(), candidateString);
                    if (null == suggestions || 0 == suggestions.length) continue;
                    String prefix = queryString.substring(0, start);
                    String postfix = queryString.substring(end);
                    for (int i = 0; i < suggestions.length; ++i) {
                        suggestions[i] = prefix + suggestions[i] + postfix;
                    }
                    SpellCorrectionImpl[] corrections = null;
                    corrections = new SpellCorrectionImpl[]{new SpellCorrectionImpl(queryString, suggestions)};
                    SpellCorrectionImpl[] spellCorrectionImplArray = corrections;
                    return spellCorrectionImplArray;
                }
                SpellCorrectionImpl[] spellCorrectionImplArray = null;
                return spellCorrectionImplArray;
            }
            catch (TokenizerException e) {
                if (Loggers.logger.isLoggable(Level.FINE)) {
                    ExtendedException eeToLog = new ExtendedException(new Message("S0018W.SPELL_SUGGESTION_LOOKUP_FAILED", SpellChecker.NaturalLanguage), (Throwable)e);
                    Loggers.logger.log(Level.FINE, eeToLog);
                }
                SpellCorrectionImpl[] spellCorrectionImplArray = null;
                return spellCorrectionImplArray;
            }
            finally {
                if (null != tokenizer) {
                    GlobalSystem.getSingleInstance().getTokenizerPool().release(tokenizer);
                }
            }
        }
        return null;
    }

    private boolean isSkippable(SpellSuggestionCandidate candidate) {
        if (null == candidate) {
            return true;
        }
        ExtendedTermQuery[] terms = candidate.getTerms();
        if (null == terms || terms.length == 0) {
            return true;
        }
        for (ExtendedTermQuery term : terms) {
            if (term.hasLemma() || term.isStopword()) continue;
            return false;
        }
        return true;
    }

    private Query buildQuicklinksQuery(ParsedQuery parsedQuery) throws Exception {
        List<Term> quicklinksTerms = parsedQuery.getTermsForQuicklinks();
        BooleanQuery query = new BooleanQuery();
        String[] tokenizedTerms = new String[quicklinksTerms.size()];
        for (int i = 0; i < tokenizedTerms.length; ++i) {
            tokenizedTerms[i] = quicklinksTerms.get(i).text();
        }
        String keywordTerm = QuicklinksWriter.createKeywordTerm(tokenizedTerms);
        query.add(new BooleanClause((Query)new TermQuery(new Term("_keywords", keywordTerm)), BooleanClause.Occur.SHOULD));
        return query;
    }

    private IndexSearcher getIndexSearcher(IndexDescriptor.IndexType type) {
        return this.searchers[type.ordinal()];
    }

    private boolean isIndexMandatory(IndexDescriptor.IndexType type) {
        return type == IndexDescriptor.IndexType.Text;
    }

    private void initIndexSearcher(IndexDescriptor.IndexType type) throws ExtendedException {
        block4: {
            String path = this.collectionConfig.getIndexPath(type);
            if (path != null) {
                try {
                    this.searchers[type.ordinal()] = SearcherFactory.getInstance(type, path, this.collectionConfig);
                }
                catch (Exception e) {
                    if (!this.isIndexMandatory(type)) break block4;
                    Message msg = new Message("S0004E.INDEXREADER_CREATION_FAILURE");
                    msg.addArgument(path);
                    ExtendedException exc = new ExtendedException(msg, (Throwable)e);
                    if (Loggers.logger.isLoggable(Level.SEVERE)) {
                        Loggers.logger.log(exc);
                    }
                    throw exc;
                }
            }
        }
    }

    private long[] getDocHashCodes(IndexReader reader) {
        long[] hashCodes;
        block3: {
            hashCodes = new long[reader.maxDoc()];
            try {
                TermPositions tpos = reader.termPositions(new Term("_dochash", "_dochash"));
                while (tpos.next()) {
                    tpos.nextPosition();
                    byte[] docHash = new byte[tpos.getPayloadLength()];
                    if (docHash == null || docHash.length <= 0) continue;
                    tpos.getPayload(docHash, 0);
                    hashCodes[tpos.doc()] = Vlong8.decode(docHash, new Vint8.Position(1));
                }
            }
            catch (Exception e) {
                Message msg = new Message("S0210W.DOCHASH_INIT_FAILURE");
                msg.addArgument(this.collectionId);
                ExtendedException exc = new ExtendedException(msg, (Throwable)e);
                if (!Loggers.logger.isLoggable(Level.WARNING)) break block3;
                Loggers.logger.log(exc);
            }
        }
        return hashCodes;
    }

    private static class ResultsWrapper {
        private Result[] results = null;
        private CountSelectedFacets facets;
        private int totalResults = 0;
        private int availableResults = 0;
        private boolean removedDups = false;

        public ResultsWrapper(Result[] results, int availableResults, int totalResults, boolean removedDups, CountSelectedFacets countedFacets) {
            this.results = results;
            this.facets = countedFacets;
            this.availableResults = availableResults;
            this.totalResults = totalResults;
            this.removedDups = removedDups;
        }

        public Result[] getResults() {
            return this.results;
        }

        public CountSelectedFacets getFacets() {
            return this.facets;
        }

        public int getAvailableResults() {
            return this.availableResults;
        }

        public int getTotalResults() {
            return this.totalResults;
        }

        public boolean removedDuplicates() {
            return this.removedDups;
        }
    }
}

