/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.search.SearchableImpl;
import com.ibm.es.nuvo.search.SearchableInstantiationException;
import com.ibm.es.nuvo.util.threadpool.Task;
import com.ibm.es.nuvo.util.threadpool.TaskEventListener;
import java.util.ArrayList;
import java.util.logging.Level;

public class SearchableFactory {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static SearchableFactory factory;
    private ArrayList<TaskEventListener> listeners = new ArrayList();

    public static SearchableFactory getInstance() {
        if (factory == null) {
            factory = new SearchableFactory();
        }
        return factory;
    }

    public void addListener(TaskEventListener l) {
        this.listeners.add(l);
    }

    public synchronized void createSearchableAsync(String collectionId) {
        GlobalSystem.getSingleInstance().getTaskPool().schedule(new WarmupTask(collectionId));
    }

    public SearchableImpl createSearchable(String collectionId) throws SearchableInstantiationException {
        SearchableImpl searchable = null;
        searchable = new SearchableImpl(collectionId);
        searchable.setRefreshedTime(System.currentTimeMillis());
        return searchable;
    }

    private SearchableFactory() {
    }

    private class WarmupTask
    extends Task {
        private String collectionId;
        private SearchableImpl searchable;

        public WarmupTask(String collectionId) {
            this.collectionId = collectionId;
            this.searchable = null;
            for (int i = 0; i < SearchableFactory.this.listeners.size(); ++i) {
                this.addEventListener((TaskEventListener)SearchableFactory.this.listeners.get(i));
            }
        }

        public void executeTask() {
            block2: {
                try {
                    this.searchable = SearchableFactory.this.createSearchable(this.collectionId);
                }
                catch (Exception e) {
                    ExtendedException ee = new ExtendedException(e);
                    if (!Loggers.logger.isLoggable(Level.SEVERE)) break block2;
                    Loggers.logger.log(Level.SEVERE, ee);
                }
            }
        }

        public Object getEvent() {
            return new AsyncSearchableCreationEvent(this.collectionId, this.searchable);
        }
    }

    public class AsyncSearchableCreationEvent {
        private String collectionId;
        private SearchableImpl searchable;

        public AsyncSearchableCreationEvent(String collectionId, SearchableImpl s) {
            this.collectionId = collectionId;
            this.searchable = s;
        }

        public String getCollectionId() {
            return this.collectionId;
        }

        public SearchableImpl getSearchable() {
            return this.searchable;
        }
    }
}

