/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search;

import com.ibm.es.nuvo.cache.CacheEvictionHandler;
import com.ibm.es.nuvo.cache.CacheException;
import com.ibm.es.nuvo.cache.CacheLoader;
import com.ibm.es.nuvo.cache.ObjectCache;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.search.ReferenceCountedObject;
import com.ibm.es.nuvo.search.SearchableFactory;
import com.ibm.es.nuvo.search.SearchableImpl;
import com.ibm.es.nuvo.search.SearchableQuiesceListener;
import com.ibm.es.nuvo.util.threadpool.TaskEventListener;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.common.ApplicationInfo;
import com.ibm.siapi.search.RemoteFederator;
import com.ibm.siapi.search.SearchService;
import com.ibm.siapi.search.Searchable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class SearchServiceImpl
implements SearchService,
TaskEventListener {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private ObjectCache<String, ReferenceCountedSearchableWrapper> activeSearchables;
    private Hashtable<String, SearchableImpl> droppedSearchables;
    private static SearchServiceImpl searchService;
    private static SearchableFactory searchableFactory;
    private static final int minSearchables = 1;
    private HashSet<String> activeWarmupSet;
    private Hashtable<String, ReferenceCountedSearchableWrapper> pendingDropSearchable;
    private HashSet<String> pendingDropCollection;

    public static SearchServiceImpl getInstance() {
        if (searchService == null) {
            GlobalConfiguration globalConfig = GlobalConfiguration.getConfiguration();
            int maxSearchables = globalConfig.getNumberOfSearchables();
            searchService = new SearchServiceImpl(maxSearchables);
        }
        return searchService;
    }

    public synchronized void addQuiesceListener(SearchableQuiesceListener l) {
    }

    public synchronized Searchable getSearchable(ApplicationInfo appInfo, String collectionId) throws SiapiException {
        try {
            ReferenceCountedSearchableWrapper s = this.activeSearchables.get(collectionId);
            SearchableImpl searchable = s.getSearchable();
            if (searchable.numberOfDocuments() == 0L) {
                this.dropCollection(collectionId);
                s = new ReferenceCountedSearchableWrapper(searchableFactory.createSearchable(collectionId));
                this.activeSearchables.replace(collectionId, s, true);
            } else if (searchable.refreshRequired() && !this.activeWarmupSet.contains(collectionId)) {
                this.activeWarmupSet.add(collectionId);
                searchableFactory.createSearchableAsync(collectionId);
            }
            s.open();
            return s.getSearchable();
        }
        catch (Exception e) {
            SiapiException exc = new SiapiException(1, 24, "Failed to obtain searchable");
            exc.initCause((Throwable)e);
            throw exc;
        }
    }

    public synchronized void putSearchable(SearchableImpl s) throws ExtendedException {
        String collectionId = s.getCollectionInfo().getID();
        ReferenceCountedSearchableWrapper searchable = null;
        String key = Integer.toString(s.hashCode());
        searchable = this.pendingDropSearchable.containsKey(key) ? this.pendingDropSearchable.get(key) : this.activeSearchables.get(collectionId);
        searchable.close();
        if (searchable.getReferenceCount() == 0L && this.pendingDropSearchable.containsKey(key)) {
            this.droppedSearchables.put(key, s);
            this.notifyAll();
        }
    }

    public synchronized void update(Object event) {
        block9: {
            if (event != null && event instanceof SearchableFactory.AsyncSearchableCreationEvent) {
                SearchableFactory.AsyncSearchableCreationEvent evt = (SearchableFactory.AsyncSearchableCreationEvent)event;
                String collectionId = evt.getCollectionId();
                SearchableImpl s = evt.getSearchable();
                this.activeWarmupSet.remove(collectionId);
                if (this.pendingDropCollection.contains(collectionId)) {
                    try {
                        if (s != null) {
                            s.destroy();
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        if (Loggers.logger.isLoggable(Level.SEVERE)) {
                            Message msg = new Message("S0024E.SEARCHABLE_MATERIALIZATION_FAILED");
                            msg.addArgument(collectionId);
                            ExtendedException ee = new ExtendedException(msg);
                            Loggers.logger.log(Level.SEVERE, ee);
                        }
                        break block9;
                    }
                }
                if (s != null) {
                    try {
                        this.dropCollection(collectionId);
                        this.activeSearchables.put(collectionId, new ReferenceCountedSearchableWrapper(s));
                    }
                    catch (Exception e) {
                        if (!Loggers.logger.isLoggable(Level.SEVERE)) break block9;
                        Message msg = new Message("S0024E.SEARCHABLE_MATERIALIZATION_FAILED");
                        msg.addArgument(collectionId);
                        ExtendedException ee = new ExtendedException(msg);
                        Loggers.logger.log(Level.SEVERE, ee);
                    }
                }
            }
        }
    }

    public Searchable[] getAvailableSearchables(ApplicationInfo appInfo) throws SiapiException {
        throw new SiapiException(1, 8, "");
    }

    public RemoteFederator getFederator(ApplicationInfo appInfo, String federatorId) throws SiapiException {
        throw new SiapiException(1, 8, "");
    }

    public RemoteFederator[] getAvailableFederators(ApplicationInfo appInfo) throws SiapiException {
        throw new SiapiException(1, 8, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void drop(String collectionId) throws ExtendedException {
        if (this.activeSearchables.contains(collectionId)) {
            this.pendingDropCollection.add(collectionId);
            try {
                this.dropCollection(collectionId);
            }
            finally {
                this.pendingDropCollection.remove(collectionId);
            }
        }
    }

    private synchronized void dropCollection(String collectionId) throws ExtendedException {
        block11: {
            String key = null;
            try {
                if (!this.activeSearchables.contains(collectionId)) break block11;
                ReferenceCountedSearchableWrapper s = this.activeSearchables.get(collectionId);
                SearchableImpl searchable = s.getSearchable();
                key = Integer.toString(searchable.hashCode());
                this.activeSearchables.destroy(collectionId);
                this.pendingDropSearchable.put(key, s);
                if (s.getReferenceCount() == 0L) {
                    searchable.destroy();
                    break block11;
                }
                while (true) {
                    try {
                        do {
                            this.wait();
                        } while (!this.droppedSearchables.containsKey(key));
                        this.droppedSearchables.remove(key);
                        searchable.destroy();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                Message msg = new Message("S0025E.SEARCHABLE_DROP_FAILED");
                msg.addArgument(collectionId);
                throw new ExtendedException(msg, (Throwable)e);
            }
            finally {
                if (key != null) {
                    this.pendingDropSearchable.remove(key);
                }
            }
        }
    }

    private SearchServiceImpl(int maxSearchables) {
        if (maxSearchables < 1) {
            maxSearchables = 1;
        }
        Properties cacheProperties = new Properties();
        cacheProperties.put("cache.size", Integer.toString(maxSearchables));
        cacheProperties.put("cache.name", "<Searchable Cache>");
        this.activeSearchables = new ObjectCache(cacheProperties);
        this.activeSearchables.setCacheLoader(new SearchableLoader());
        this.activeSearchables.setEvictionHandler(new SearchableUnloader());
        searchableFactory = SearchableFactory.getInstance();
        searchableFactory.addListener(this);
        this.activeWarmupSet = new HashSet();
        this.pendingDropSearchable = new Hashtable();
        this.pendingDropCollection = new HashSet();
        this.droppedSearchables = new Hashtable();
    }

    private class ReferenceCountedSearchableWrapper
    implements ReferenceCountedObject {
        private long refCount;
        private SearchableImpl searchable;

        public ReferenceCountedSearchableWrapper(SearchableImpl s) {
            this.searchable = s;
            this.refCount = 0L;
        }

        public SearchableImpl getSearchable() {
            return this.searchable;
        }

        public void open() {
            ++this.refCount;
        }

        public void close() {
            if (this.refCount > 0L) {
                --this.refCount;
            }
        }

        public synchronized long getReferenceCount() {
            return this.refCount;
        }
    }

    private class SearchableUnloader
    implements CacheEvictionHandler {
        private SearchableUnloader() {
        }

        public void handle(Object searchable) {
            ReferenceCountedSearchableWrapper s = (ReferenceCountedSearchableWrapper)searchable;
            SearchableImpl searchableImpl = s.getSearchable();
            try {
                SearchServiceImpl.this.dropCollection(searchableImpl.getCollectionInfo().getID());
            }
            catch (Exception e) {
                Message msg = new Message("S0009E.SEARCHABLE_UNLOAD_FAILURE");
                msg.addArgument(searchableImpl.getCollectionInfo().getID());
                Loggers.logger.log(Level.SEVERE, msg);
            }
        }
    }

    private class SearchableLoader
    implements CacheLoader {
        private SearchableLoader() {
        }

        public Object load(Object collectionId) throws CacheException {
            ReferenceCountedSearchableWrapper searchable = null;
            try {
                searchable = new ReferenceCountedSearchableWrapper(searchableFactory.createSearchable((String)collectionId));
            }
            catch (Exception e) {
                Message msg = new Message("S0003E.SEARCHABLE_LOAD_FAILURE");
                msg.addArgument(collectionId);
                throw new CacheException(msg, (Throwable)e);
            }
            return searchable;
        }
    }
}

