/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.search;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.search.CustomHitCollector;
import com.ibm.es.nuvo.search.EmptyQueryException;
import com.ibm.es.nuvo.search.MultiMessageException;
import com.ibm.es.nuvo.search.QueryImpl;
import com.ibm.es.nuvo.search.QueryLimitExceededException;
import com.ibm.es.nuvo.search.SearchBeanInstantiationException;
import com.ibm.es.nuvo.search.SearchFactoryImpl;
import com.ibm.es.nuvo.search.SearchServiceImpl;
import com.ibm.es.nuvo.search.SearchableImpl;
import com.ibm.es.nuvo.search.cache.CachedDocument;
import com.ibm.es.nuvo.search.prefs.SearchPreferences;
import com.ibm.es.nuvo.search.security.UserSecurityContext;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Query;
import com.ibm.siapi.search.ResultSet;
import com.ibm.siapi.search.SearchFactory;
import java.util.logging.Level;

public class SearchBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private SearchServiceImpl searchService;
    private SearchFactory searchFactory;
    private static SearchBean searchBean;

    public static SearchBean getInstance() throws SearchBeanInstantiationException {
        if (searchBean == null) {
            searchBean = new SearchBean();
        }
        return searchBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResultSet(String queryString, SearchPreferences preferences, String collectionId, int startOff, int numResults, boolean filter, UserSecurityContext usc, long queryTimeout, String[] fields) throws ExtendedException {
        ResultSet resultSet;
        block12: {
            resultSet = null;
            SearchableImpl searchable = null;
            try {
                try {
                    searchable = (SearchableImpl)this.searchService.getSearchable(null, collectionId);
                }
                catch (SiapiException e) {
                    throw new ExtendedException(e);
                }
                if (searchable == null) break block12;
                try {
                    CollectionConfiguration config = ConfigurationManager.getConfigurationManager().getCollection(collectionId);
                    QueryImpl query = (QueryImpl)this.createQuery(queryString, preferences);
                    query.setQueryLanguage(preferences.getQL());
                    query.setPredefinedResultsEnabled(true);
                    query.setRequestedResultRange(startOff, numResults);
                    query.setReturnedAttribute(-1, config.getProvideDynamicSummary());
                    query.setReturnedAttribute(-10, true);
                    query.setReturnedAttribute(-2, true);
                    query.setReturnedAttribute(-11, true);
                    query.setReturnedAttribute(-6, true);
                    query.setReturnedAttribute(-8, true);
                    query.setReturnedAttribute(-9, true);
                    query.setReturnedAttribute(-3, true);
                    query.setProperty("filter", Boolean.toString(filter));
                    query.setProperty("languageFilter", this.getLanguageConstraints(preferences));
                    query.setProperty("earlyTerminationTimeout", Long.toString(queryTimeout));
                    query.setCredentials(usc);
                    query.setMandatoryFields(fields);
                    resultSet = searchable.search(query);
                }
                catch (SiapiException e) {
                    if (e.getType() == 15) {
                        Message msg = new Message("S0032E.QUERY_BAD_SYNTAX");
                        throw new ExtendedException(msg);
                    }
                    if (e instanceof EmptyQueryException) {
                        Message msg = new Message("S0077E.EMPTY_PARSED_QUERY");
                        throw new ExtendedException(msg);
                    }
                    if (e instanceof QueryLimitExceededException) {
                        Message msg = new Message("S0215E.PER_DAY_QUERY_LIMIT_EXCEEDED");
                        throw new ExtendedException(msg);
                    }
                    if (e instanceof MultiMessageException) {
                        throw new ExtendedException(e);
                    }
                    throw new ExtendedException(e.getCause());
                }
            }
            finally {
                if (searchable != null) {
                    this.searchService.putSearchable(searchable);
                }
            }
        }
        return resultSet;
    }

    public Query getSkeletonQuery(String queryString) throws SiapiException {
        return this.searchFactory.createQuery(queryString);
    }

    public void search(String collectionId, Query query, CustomHitCollector collector) throws ExtendedException {
        SearchableImpl searchable = null;
        try {
            try {
                searchable = (SearchableImpl)this.searchService.getSearchable(null, collectionId);
            }
            catch (SiapiException e) {
                throw new ExtendedException(e);
            }
            if (searchable != null) {
                searchable.search(query, collector);
            }
        }
        catch (SiapiException e) {
            if (e.getType() == 15) {
                Message msg = new Message("S0032E.QUERY_BAD_SYNTAX");
                throw new ExtendedException(msg);
            }
            if (e instanceof EmptyQueryException) {
                Message msg = new Message("S0077E.EMPTY_PARSED_QUERY");
                throw new ExtendedException(msg);
            }
            throw new ExtendedException(e.getCause());
        }
        finally {
            if (searchable != null) {
                this.searchService.putSearchable(searchable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedDocument getCachedDocument(String uri, String collectionId, UserSecurityContext usc) {
        CachedDocument doc = null;
        SearchableImpl searchable = null;
        try {
            searchable = (SearchableImpl)this.searchService.getSearchable(null, collectionId);
            if (searchable != null) {
                doc = searchable.getCachedDocument(uri, usc);
            }
        }
        catch (Exception e) {
            if (Loggers.logger.isLoggable(Level.SEVERE)) {
                Message msg = new Message("S0022E.CACHED_DOCUMENT_MATERIALIZATION_FAILURE");
                msg.addArgument(uri);
                msg.addArgument(collectionId);
                ExtendedException exc = new ExtendedException(msg, (Throwable)e);
                Loggers.logger.log(Level.SEVERE, exc);
            }
        }
        finally {
            if (searchable != null) {
                try {
                    this.searchService.putSearchable(searchable);
                }
                catch (Exception e) {}
            }
        }
        return doc;
    }

    private SearchBean() throws SearchBeanInstantiationException {
        try {
            this.searchFactory = new SearchFactoryImpl();
            this.searchService = SearchServiceImpl.getInstance();
        }
        catch (Exception e) {
            Message msg = new Message("S0002E.SEARCH_APP_INIT_FAILURE");
            throw new SearchBeanInstantiationException(msg, (Throwable)e);
        }
    }

    private Query createQuery(String queryString, SearchPreferences preferences) throws ExtendedException {
        try {
            Query query = this.searchFactory.createQuery(queryString);
            return query;
        }
        catch (SiapiException e) {
            throw new ExtendedException(e);
        }
    }

    private String getLanguageConstraints(SearchPreferences preferences) {
        String[] filterLanguages;
        String langConstraintsTerm = "";
        String filterOption = preferences.getFO();
        if (filterOption.equals("1") && (filterLanguages = preferences.getFL()) != null && filterLanguages.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (String lang : filterLanguages) {
                builder.append(lang + ",");
            }
            langConstraintsTerm = builder.toString();
        }
        return langConstraintsTerm;
    }
}

